/*
 * Decompiled with CFR 0.152.
 */
package blade.kit;

import blade.kit.DateKit;
import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class TaskKit {
    private static Logger logger = LoggerFactory.getLogger(TaskKit.class);
    private static ScheduledThreadPoolExecutor taskScheduler = new ScheduledThreadPoolExecutor(TaskKit.getBestPoolSize());
    private static List<Timer> timerList = new ArrayList<Timer>();

    public static ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long periodSeconds) {
        return TaskKit.scheduleAtFixedRate(task, 0L, periodSeconds, TimeUnit.SECONDS);
    }

    public static ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return taskScheduler.scheduleAtFixedRate(task, initialDelay, period, unit);
    }

    public static void scheduleAtFixedRate(Runnable task, String startTime, long period, TimeUnit unit) throws ParseException {
        Date dt = DateKit.dateFormat(startTime, "yyyy-MM-dd HH:mm:ss");
        TaskKit.scheduleAtFixedRate(task, dt, period, unit);
    }

    public static void scheduleAtFixedRate(final Runnable task, Date startTime, final long period, final TimeUnit unit) {
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                taskScheduler.scheduleAtFixedRate(task, 0L, period, unit);
                timer.cancel();
                timerList.remove(timer);
            }
        }, startTime);
        timerList.add(timer);
    }

    public static ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long periodSeconds) {
        return TaskKit.scheduleWithFixedDelay(task, 0L, periodSeconds, TimeUnit.SECONDS);
    }

    public static ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return taskScheduler.scheduleWithFixedDelay(task, initialDelay, period, unit);
    }

    public static void scheduleWithFixedDelay(Runnable task, String startTime, long period, TimeUnit unit) throws ParseException {
        Date dt = DateKit.dateFormat(startTime, "yyyy-MM-dd HH:mm:ss");
        TaskKit.scheduleWithFixedDelay(task, dt, period, unit);
    }

    public static void scheduleWithFixedDelay(final Runnable task, Date startTime, final long period, final TimeUnit unit) {
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                taskScheduler.scheduleWithFixedDelay(task, 0L, period, unit);
                timer.cancel();
                timerList.remove(timer);
            }
        }, startTime);
        timerList.add(timer);
    }

    public static void resizeThreadPool(int threadPoolSize) {
        taskScheduler.setCorePoolSize(threadPoolSize);
    }

    public static ScheduledThreadPoolExecutor getTaskScheduler() {
        return taskScheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void depose() {
        int timerNum = timerList.size();
        List<Timer> list = timerList;
        synchronized (list) {
            for (Timer t : timerList) {
                t.cancel();
            }
            timerList.clear();
        }
        List<Runnable> awaitingExecution = taskScheduler.shutdownNow();
        logger.info("Tasks stopping. Tasks awaiting execution: {}", timerNum + awaitingExecution.size());
    }

    public static void reset() {
        TaskKit.depose();
        taskScheduler = new ScheduledThreadPoolExecutor(TaskKit.getBestPoolSize());
    }

    private static int getBestPoolSize() {
        try {
            int cores = Runtime.getRuntime().availableProcessors();
            return (int)((double)cores / 0.09999999999999998);
        }
        catch (Throwable e) {
            return 10;
        }
    }
}

