/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.json;

import blade.kit.json.JSON;
import blade.kit.json.JSONArray;
import blade.kit.json.JSONLiteral;
import blade.kit.json.JSONObject;
import blade.kit.json.JSONParser;
import blade.kit.json.JSONWriter;
import blade.kit.json.WriterConfig;
import blade.kit.json.WritingBuffer;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;

public abstract class JSONValue
implements Serializable {
    @Deprecated
    public static final JSONValue TRUE = new JSONLiteral("true");
    @Deprecated
    public static final JSONValue FALSE = new JSONLiteral("false");
    @Deprecated
    public static final JSONValue NULL = new JSONLiteral("null");

    JSONValue() {
    }

    @Deprecated
    public static JSONValue readFrom(Reader reader) throws IOException {
        return new JSONParser(reader).parse();
    }

    @Deprecated
    public static JSONValue readFrom(String text) {
        try {
            return new JSONParser(text).parse();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Deprecated
    public static JSONValue valueOf(int value) {
        return JSON.value(value);
    }

    @Deprecated
    public static JSONValue valueOf(long value) {
        return JSON.value(value);
    }

    @Deprecated
    public static JSONValue valueOf(float value) {
        return JSON.value(value);
    }

    @Deprecated
    public static JSONValue valueOf(double value) {
        return JSON.value(value);
    }

    @Deprecated
    public static JSONValue valueOf(String string) {
        return JSON.value(string);
    }

    @Deprecated
    public static JSONValue valueOf(boolean value) {
        return JSON.value(value);
    }

    public boolean isObject() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isTrue() {
        return false;
    }

    public boolean isFalse() {
        return false;
    }

    public boolean isNull() {
        return false;
    }

    public JSONObject asObject() {
        throw new UnsupportedOperationException("Not an object: " + this.toString());
    }

    public JSONArray asArray() {
        throw new UnsupportedOperationException("Not an array: " + this.toString());
    }

    public int asInt() {
        throw new UnsupportedOperationException("Not a number: " + this.toString());
    }

    public long asLong() {
        throw new UnsupportedOperationException("Not a number: " + this.toString());
    }

    public float asFloat() {
        throw new UnsupportedOperationException("Not a number: " + this.toString());
    }

    public double asDouble() {
        throw new UnsupportedOperationException("Not a number: " + this.toString());
    }

    public String asString() {
        throw new UnsupportedOperationException("Not a string: " + this.toString());
    }

    public boolean asBoolean() {
        throw new UnsupportedOperationException("Not a boolean: " + this.toString());
    }

    public void writeTo(Writer writer) throws IOException {
        this.writeTo(writer, WriterConfig.MINIMAL);
    }

    public void writeTo(Writer writer, WriterConfig config) throws IOException {
        if (writer == null) {
            throw new NullPointerException("writer is null");
        }
        if (config == null) {
            throw new NullPointerException("config is null");
        }
        WritingBuffer buffer = new WritingBuffer(writer, 128);
        this.write(config.createWriter(buffer));
        buffer.flush();
    }

    public String toString() {
        return this.toString(WriterConfig.MINIMAL);
    }

    public String toString(WriterConfig config) {
        StringWriter writer = new StringWriter();
        try {
            this.writeTo(writer, config);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return writer.toString();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    abstract void write(JSONWriter var1) throws IOException;
}

