/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.logging;

import blade.kit.logging.Logger;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SimpleLogger
implements Logger {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private static PrintStream outprint = System.out;
    private int level = 200;
    protected String name;

    public SimpleLogger() {
        String currentClassName;
        this.name = currentClassName = Thread.currentThread().getStackTrace()[2].getClassName();
    }

    public SimpleLogger(Class<?> type) {
        this.name = type.getName();
    }

    private String getLevel(int level) {
        if (level <= 100) {
            return "TRACE";
        }
        if (level <= 200) {
            return "DEBUG";
        }
        if (level <= 300) {
            return "INFO";
        }
        if (level <= 400) {
            return "WARN";
        }
        if (level <= 500) {
            outprint = System.err;
            return "ERROR";
        }
        if (level <= 600) {
            return "FATAL";
        }
        return "DEBUG";
    }

    private String now() {
        return sdf.format(new Date());
    }

    public void trace(String message) {
        if (this.level <= 100) {
            this.log(100, message, new Object[0]);
        }
    }

    public void trace(String message, Object ... args) {
        if (this.level <= 100) {
            this.log(100, message, args);
        }
    }

    public void trace(String message, Throwable t) {
        if (this.level <= 100) {
            this.log(100, message, t, new Object[0]);
        }
    }

    public void trace(String message, Throwable t, Object ... args) {
        if (this.level <= 100) {
            this.log(100, message, t, args);
        }
    }

    @Override
    public void debug(String message) {
        if (this.level <= 200) {
            this.log(200, message, new Object[0]);
        }
    }

    @Override
    public void debug(String message, Object ... args) {
        if (this.level <= 200) {
            this.log(200, message, args);
        }
    }

    public void debug(String message, Throwable t) {
        if (this.level <= 200) {
            this.log(200, message, t, new Object[0]);
        }
    }

    public void debug(String message, Throwable t, Object ... args) {
        if (this.level <= 200) {
            this.log(200, message, t, args);
        }
    }

    @Override
    public void info(String message) {
        if (this.level <= 300) {
            this.log(300, message, new Object[0]);
        }
    }

    @Override
    public void info(String message, Object ... args) {
        if (this.level <= 300) {
            this.log(300, message, args);
        }
    }

    public void info(String message, Throwable t) {
        if (this.level <= 300) {
            this.log(300, message, t, new Object[0]);
        }
    }

    public void info(String message, Throwable t, Object ... args) {
        if (this.level <= 300) {
            this.log(300, message, t, args);
        }
    }

    @Override
    public void warn(String message) {
        if (this.level <= 400) {
            this.log(400, message, new Object[0]);
        }
    }

    @Override
    public void warn(String message, Object ... args) {
        if (this.level <= 400) {
            this.log(400, message, args);
        }
    }

    @Override
    public void warn(String message, Throwable t) {
        if (this.level <= 400) {
            this.log(400, message, t, new Object[0]);
        }
    }

    public void warn(String message, Throwable t, Object ... args) {
        if (this.level <= 400) {
            this.log(400, message, t, args);
        }
    }

    @Override
    public void error(String message) {
        if (this.level <= 500) {
            this.log(500, message, new Object[0]);
        }
    }

    @Override
    public void error(String message, Object ... args) {
        if (this.level <= 500) {
            this.log(500, message, args);
        }
    }

    @Override
    public void error(String message, Throwable t) {
        if (this.level <= 500) {
            this.log(500, message, t, new Object[0]);
        }
    }

    public void error(String message, Throwable t, Object ... args) {
        if (this.level <= 500) {
            this.log(500, message, t, args);
        }
    }

    public boolean isDebugEnabled() {
        return this.level <= 200;
    }

    public boolean isErrorEnabled() {
        return this.level <= 500;
    }

    public boolean isInfoEnabled() {
        return this.level <= 300;
    }

    public boolean isWarnEnabled() {
        return this.level <= 400;
    }

    public void log(int level, String message, Object ... args) {
        this.log(level, message, null, args);
    }

    public void log(int level, String message, Throwable t, Object ... args) {
        StringBuilder sb = new StringBuilder(this.now());
        sb.append(" ").append(this.getLevel(level)).append(" ");
        sb.append("[").append(Thread.currentThread().getName()).append("]").append(" ");
        sb.append(this.name).append(" | ");
        sb.append(this.format(message, args));
        outprint.println(sb.toString());
        if (t != null) {
            t.printStackTrace(System.err);
            System.err.flush();
        }
    }

    protected String format(String message, Object ... args) {
        if (message == null) {
            return null;
        }
        if (args == null || args.length == 0) {
            return message.toString();
        }
        String msg = String.format(message, args);
        if (msg.indexOf("{}") != -1) {
            for (Object arg : args) {
                String arg_str = "";
                if (null != arg) {
                    arg_str = arg.toString();
                    if (arg_str.indexOf("\\") != -1) {
                        arg_str = arg_str.replaceAll("\\\\", "/");
                    }
                    if (arg_str.indexOf("$") != -1) {
                        arg_str = arg_str.replaceAll("\\$", "_");
                    }
                }
                msg = msg.replaceFirst("\\{\\}", arg_str);
            }
        }
        return msg;
    }
}

