/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.mail;

import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class EmailHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailHandle.class);
    private MimeMessage mimeMsg;
    private Session session;
    private Properties props;
    private String sendUserName = "";
    private String sendUserPass = "";
    private Multipart mp;
    private List<FileDataSource> files = new LinkedList<FileDataSource>();

    public EmailHandle(String smtp) {
        this.setSmtpHost(smtp);
        this.createMimeMessage();
    }

    private void setSmtpHost(String hostName) {
        if (this.props == null) {
            this.props = System.getProperties();
        }
        this.props.put("mail.smtp.host", hostName);
    }

    public boolean createMimeMessage() {
        try {
            this.session = Session.getDefaultInstance((Properties)this.props, null);
            this.mimeMsg = new MimeMessage(this.session);
            this.mp = new MimeMultipart();
            return true;
        }
        catch (Exception e) {
            System.err.println("\u83b7\u53d6\u90ae\u4ef6\u4f1a\u8bdd\u5bf9\u8c61\u65f6\u53d1\u751f\u9519\u8bef\uff01" + e);
            return false;
        }
    }

    public void setNeedAuth(boolean need) {
        if (this.props == null) {
            this.props = System.getProperties();
        }
        if (need) {
            this.props.put("mail.smtp.auth", "true");
        } else {
            this.props.put("mail.smtp.auth", "false");
        }
    }

    public void setNamePass(String name, String pass) {
        this.sendUserName = name;
        this.sendUserPass = pass;
    }

    public boolean setSubject(String mailSubject) {
        try {
            this.mimeMsg.setSubject(mailSubject);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean setBody(String mailBody) {
        try {
            MimeBodyPart bp = new MimeBodyPart();
            bp.setContent((Object)("<meta http-equiv=Content-Type content=text/html; charset=UTF-8>" + mailBody), "text/html;charset=UTF-8");
            this.mp.addBodyPart((BodyPart)bp);
        }
        catch (Exception e) {
            System.err.println("\u8bbe\u7f6e\u90ae\u4ef6\u6b63\u6587\u65f6\u53d1\u751f\u9519\u8bef\uff01" + e);
            return false;
        }
        return true;
    }

    public boolean addFileAffix(String filename) {
        try {
            MimeBodyPart bp = new MimeBodyPart();
            FileDataSource fileds = new FileDataSource(filename);
            bp.setDataHandler(new DataHandler((DataSource)fileds));
            bp.setFileName(MimeUtility.encodeText((String)fileds.getName(), (String)"UTF-8", null));
            this.mp.addBodyPart((BodyPart)bp);
            this.files.add(fileds);
            return true;
        }
        catch (Exception e) {
            System.err.println("\u589e\u52a0\u90ae\u4ef6\u9644\u4ef6<" + filename + ">\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + e);
            return false;
        }
    }

    public boolean delFileAffix() {
        try {
            FileDataSource fileds2 = null;
            for (FileDataSource fileds2 : this.files) {
                if (fileds2 == null || fileds2.getFile() == null) continue;
                fileds2.getFile().delete();
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("\u5220\u9664\u90ae\u4ef6\u9644\u4ef6\u53d1\u751f\u9519\u8bef\uff1a" + e);
            return false;
        }
    }

    public boolean setFrom(String from) {
        try {
            this.mimeMsg.setFrom((Address)new InternetAddress(from));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean setTo(String to) {
        try {
            if (to == null) {
                return false;
            }
            this.mimeMsg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean setToList(String toList) {
        try {
            if (toList == null) {
                return false;
            }
            InternetAddress[] iaToList = InternetAddress.parse((String)toList);
            this.mimeMsg.setRecipients(Message.RecipientType.TO, (Address[])iaToList);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean setCopyTo(String copyto) {
        try {
            if (copyto == null) {
                return false;
            }
            this.mimeMsg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)copyto));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean setCopyToList(String copytoList) {
        try {
            if (copytoList == null) {
                return false;
            }
            InternetAddress[] iacopytoList = InternetAddress.parse((String)copytoList);
            this.mimeMsg.setRecipients(Message.RecipientType.CC, (Address[])iacopytoList);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean sendEmail() throws Exception {
        LOGGER.debug("Sending mail ...");
        this.mimeMsg.setContent(this.mp);
        this.mimeMsg.saveChanges();
        Session mailSession = Session.getInstance((Properties)this.props, null);
        Transport transport = mailSession.getTransport("smtp");
        transport.connect((String)this.props.get("mail.smtp.host"), this.sendUserName, this.sendUserPass);
        transport.sendMessage((Message)this.mimeMsg, this.mimeMsg.getRecipients(Message.RecipientType.TO));
        transport.close();
        LOGGER.debug("Send mail success.");
        return true;
    }
}

