/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository;

import com.bstek.urule.Utils;
import com.bstek.urule.console.DefaultRepositoryInteceptor;
import com.bstek.urule.console.Principal;
import com.bstek.urule.console.RepositoryInteceptor;
import com.bstek.urule.console.exception.NodeLockException;
import com.bstek.urule.console.repository.RepositoryBuilder;
import com.bstek.urule.console.repository.RepositoryReader;
import com.bstek.urule.console.repository.model.RepositoryFile;
import com.bstek.urule.console.repository.model.Type;
import com.bstek.urule.console.repository.model.VersionFile;
import com.bstek.urule.console.servlet.respackage.KnowledgePackageUpdateIntercepter;
import com.bstek.urule.exception.RuleException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.value.BinaryImpl;
import org.apache.jackrabbit.value.DateValue;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class BaseRepositoryService
implements RepositoryReader,
ApplicationContextAware {
    protected RepositoryBuilder repositoryBuilder;
    protected RepositoryImpl repository;
    protected Session session;
    protected VersionManager versionManager;
    protected RepositoryInteceptor repositoryInteceptor;
    protected KnowledgePackageUpdateIntercepter knowledgePackageUpdateIntercepter;

    public void createDir(String string, Principal principal) throws Exception {
        this.repositoryInteceptor.createDir(string);
        this.session.refresh(false);
        Node node = this.getRootNode();
        string = this.processPath(string);
        if (node.hasNode(string)) {
            throw new RuleException("Dir [" + string + "] already exist.");
        }
        boolean bl = false;
        String[] stringArray = string.split("/");
        Node node2 = node;
        for (String string2 : stringArray) {
            String[] stringArray2;
            if (StringUtils.isEmpty((String)string2)) continue;
            for (String string3 : stringArray2 = string2.split("\\.")) {
                if (StringUtils.isEmpty((String)string3)) continue;
                if (node2.hasNode(string3)) {
                    node2 = node2.getNode(string3);
                    continue;
                }
                node2 = node2.addNode(string3);
                node2.addMixin("mix:versionable");
                node2.addMixin("mix:lockable");
                node2.setProperty("_dir", true);
                node2.setProperty("_file", true);
                node2.setProperty("_create_user", principal.getName());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                DateValue dateValue = new DateValue(calendar);
                node2.setProperty("_create_date", (Value)dateValue);
                bl = true;
            }
        }
        if (bl) {
            this.session.save();
        }
    }

    public void saveFile(String string, String string2, boolean bl, String string3, Principal principal) throws Exception {
        string = Utils.decodeURL((String)string);
        this.session.refresh(false);
        this.repositoryInteceptor.saveFile(string, string2);
        string = this.processPath(string);
        int n = string.indexOf(":");
        if (n != -1) {
            string = string.substring(0, n);
        }
        this.session.refresh(false);
        Node node = this.getRootNode();
        if (!node.hasNode(string)) {
            throw new RuleException("File [" + string + "] not exist.");
        }
        Node node2 = node.getNode(string);
        this.lockCheck(node2, principal);
        boolean bl2 = this.versionManager.isCheckedOut(node2.getPath());
        if (!bl2) {
            this.versionManager.checkout(node2.getPath());
        }
        BinaryImpl binaryImpl = new BinaryImpl(string2.getBytes("utf-8"));
        node2.setProperty("_data", (Binary)binaryImpl);
        node2.setProperty("_file", true);
        node2.setProperty("_create_user", principal.getName());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        DateValue dateValue = new DateValue(calendar);
        node2.setProperty("_create_date", (Value)dateValue);
        if (bl && StringUtils.isNotBlank((String)string3)) {
            node2.setProperty("_version_comment", string3);
        }
        this.session.save();
        if (bl) {
            this.versionManager.checkin(node2.getPath());
        }
    }

    protected void lockCheck(Node node, Principal principal) throws Exception {
        String string = this.getNodeLockInfo(node);
        if (string != null) {
            if (string.equals(principal.getName())) {
                return;
            }
            throw new NodeLockException("\u3010" + node.getName() + "\u3011\u5df2\u88ab" + string + "\u9501\u5b9a!");
        }
    }

    protected String getNodeLockInfo(Node node) throws Exception {
        if (node.hasProperty("_lock_info")) {
            Property property = node.getProperty("_lock_info");
            String string = property.getString();
            return string;
        }
        return null;
    }

    protected void unlockNode(Node node) throws Exception {
        if (!node.hasProperty("_lock_info")) {
            return;
        }
        this.session.refresh(false);
        Property property = node.getProperty("_lock_info");
        property.remove();
        this.session.save();
    }

    protected void lockNode(Node node, Principal principal) throws Exception {
        this.session.refresh(false);
        node.setProperty("_lock_info", principal.getName());
        this.session.save();
    }

    @Override
    public List<RepositoryFile> loadProjects(String string) throws Exception {
        ArrayList<RepositoryFile> arrayList = new ArrayList<RepositoryFile>();
        Node node = this.getRootNode();
        NodeIterator nodeIterator = node.getNodes();
        while (nodeIterator.hasNext()) {
            Object object;
            Node node2 = nodeIterator.nextNode();
            if (!node2.hasProperty("_file") || StringUtils.isNotEmpty((String)string) && node2.hasProperty("_company_id") && !string.equals(object = node2.getProperty("_company_id").getString()) || node2.getName().indexOf("___resource_authority_config__file__") > -1) continue;
            object = new RepositoryFile();
            ((RepositoryFile)object).setType(Type.project);
            ((RepositoryFile)object).setName(node2.getName());
            ((RepositoryFile)object).setFullPath("/" + node2.getName());
            arrayList.add((RepositoryFile)object);
        }
        return arrayList;
    }

    @Override
    public List<VersionFile> getVersionFiles(String string) throws Exception {
        string = this.processPath(string);
        Node node = this.getRootNode();
        if (!node.hasNode(string)) {
            throw new RuleException("File [" + string + "] not exist.");
        }
        ArrayList<VersionFile> arrayList = new ArrayList<VersionFile>();
        Node node2 = node.getNode(string);
        VersionHistory versionHistory = this.versionManager.getVersionHistory(node2.getPath());
        VersionIterator versionIterator = versionHistory.getAllVersions();
        while (versionIterator.hasNext()) {
            Version version = versionIterator.nextVersion();
            String string2 = version.getName();
            if (string2.startsWith("jcr:")) continue;
            Node node3 = version.getFrozenNode();
            VersionFile versionFile = new VersionFile();
            versionFile.setName(version.getName());
            versionFile.setPath(node2.getPath());
            Property property = node3.getProperty("_create_user");
            versionFile.setCreateUser(property.getString());
            property = node3.getProperty("_create_date");
            versionFile.setCreateDate(property.getDate().getTime());
            if (node3.hasProperty("_version_comment")) {
                property = node3.getProperty("_version_comment");
                versionFile.setComment(property.getString());
            }
            if (node3.hasProperty("_actived")) {
                property = node3.getProperty("_actived");
                versionFile.setActived(property.getBoolean());
            }
            if (node3.hasProperty("_timestamp")) {
                property = node3.getProperty("_timestamp");
                versionFile.setTimestamp(property.getLong());
            }
            arrayList.add(0, versionFile);
        }
        Collections.sort(arrayList, new Comparator<VersionFile>(){

            @Override
            public int compare(VersionFile versionFile, VersionFile versionFile2) {
                return versionFile2.getCreateDate().compareTo(versionFile.getCreateDate());
            }
        });
        return arrayList;
    }

    @Override
    public InputStream readFile(String string) throws Exception {
        return this.readFile(string, null);
    }

    @Override
    public InputStream readFile(String string, String string2) throws Exception {
        if (StringUtils.isNotBlank((String)string2)) {
            this.repositoryInteceptor.readFile(string + ":" + string2);
            return this.a(string, string2);
        }
        this.repositoryInteceptor.readFile(string);
        Node node = this.getRootNode();
        int n = string.lastIndexOf(":");
        if (n > -1) {
            string2 = string.substring(n + 1, string.length());
            string = string.substring(0, n);
            return this.readFile(string, string2);
        }
        if (!node.hasNode(string = this.processPath(string))) {
            throw new RuleException("File [" + string + "] not exist.");
        }
        Node node2 = node.getNode(string);
        Property property = node2.getProperty("_data");
        Binary binary = property.getBinary();
        return binary.getStream();
    }

    private InputStream a(String string, String string2) throws Exception {
        string = this.processPath(string);
        Node node = this.getRootNode();
        if (!node.hasNode(string)) {
            throw new RuleException("File [" + string + "] not exist.");
        }
        Node node2 = node.getNode(string);
        VersionHistory versionHistory = this.versionManager.getVersionHistory(node2.getPath());
        Version version = versionHistory.getVersion(string2);
        Node node3 = version.getFrozenNode();
        Property property = node3.getProperty("_data");
        Binary binary = property.getBinary();
        return binary.getStream();
    }

    protected String processPath(String string) {
        if (string.startsWith("/")) {
            return string.substring(1, string.length());
        }
        return string;
    }

    public Node getRootNode() throws Exception {
        return this.session.getRootNode();
    }

    public Session getSession() {
        return this.session;
    }

    public void setRepositoryBuilder(RepositoryBuilder repositoryBuilder) {
        this.repositoryBuilder = repositoryBuilder;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        try {
            this.repository = this.repositoryBuilder.getRepository();
            SimpleCredentials simpleCredentials = new SimpleCredentials("admin", "admin".toCharArray());
            simpleCredentials.setAttribute("AutoRefresh", (Object)true);
            this.session = this.repository.login((Credentials)simpleCredentials, null);
            this.versionManager = this.session.getWorkspace().getVersionManager();
            Collection collection = applicationContext.getBeansOfType(RepositoryInteceptor.class).values();
            this.repositoryInteceptor = collection.size() == 0 ? new DefaultRepositoryInteceptor() : (RepositoryInteceptor)collection.iterator().next();
            Collection collection2 = applicationContext.getBeansOfType(KnowledgePackageUpdateIntercepter.class).values();
            if (collection2.size() > 0) {
                this.knowledgePackageUpdateIntercepter = (KnowledgePackageUpdateIntercepter)collection2.iterator().next();
            }
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }
}

