/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository;

import com.bstek.urule.Utils;
import com.bstek.urule.console.cache.ResourcePackageCache;
import com.bstek.urule.console.repository.BaseRepositoryService;
import com.bstek.urule.console.repository.KnowledgePackageRepositoryService;
import com.bstek.urule.console.repository.PackageData;
import com.bstek.urule.console.repository.model.FileType;
import com.bstek.urule.console.repository.model.ResourceItem;
import com.bstek.urule.console.repository.model.ResourcePackage;
import com.bstek.urule.console.repository.model.ServiceConfig;
import com.bstek.urule.console.repository.model.VersionFile;
import com.bstek.urule.console.servlet.respackage.KnowledgePackageUpdateIntercepter;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.KnowledgePackageImpl;
import com.bstek.urule.runtime.monitor.MonitorObject;
import com.bstek.urule.runtime.monitor.MonitorObjectField;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Value;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.value.BinaryImpl;
import org.apache.jackrabbit.value.DateValue;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class KnowledgePackageRepositoryServiceImpl
extends BaseRepositoryService
implements KnowledgePackageRepositoryService {
    private ResourcePackageCache a;

    @Override
    public void knowledgePackageStateChange(String string, boolean bl) {
        PackageData packageData = new PackageData(string);
        try {
            this.session.refresh(false);
            String string2 = "___knowledge_package_data__" + packageData.getProject() + "/" + packageData.getPackageId();
            if (!this.getRootNode().hasNode(string2)) {
                return;
            }
            Node node = this.getRootNode().getNode(string2);
            NodeIterator nodeIterator = node.getNodes();
            while (nodeIterator.hasNext()) {
                Node node2 = nodeIterator.nextNode();
                if (node2.hasProperty("_kp_state")) {
                    node2.getProperty("_kp_state").setValue(bl);
                    continue;
                }
                node2.setProperty("_kp_state", bl);
            }
            this.session.save();
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    @Override
    public List<ResourcePackage> loadProjectResourcePackages(String string) {
        try {
            Node node = this.getRootNode();
            String string2 = this.processPath(string) + "/" + "___res__package__file__";
            if (!node.hasNode(string2)) {
                return new ArrayList<ResourcePackage>();
            }
            Node node2 = node.getNode(string2);
            Property property = node2.getProperty("_data");
            Binary binary = property.getBinary();
            InputStream inputStream = binary.getStream();
            String string3 = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
            inputStream.close();
            return this.parseResourcePackages(string, string3);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    @Override
    public List<ResourcePackage> loadResourcePackagesByFile(String string) {
        int n;
        String string2 = string;
        if (string2.startsWith("/")) {
            string2 = string2.substring(1, string2.length());
            n = string2.indexOf("/");
            string2 = string2.substring(0, n);
        } else if (string2.startsWith("jcr:")) {
            if ((string2 = string2.substring(4, string2.length())).startsWith("/")) {
                string2 = string2.substring(1, string2.length());
                n = string2.indexOf("/");
                string2 = string2.substring(0, n);
            } else {
                n = string2.indexOf("/");
                string2 = string2.substring(0, n);
            }
        }
        try {
            Node node = this.getRootNode();
            String string3 = string2 + "/" + "___res__package__file__";
            if (!node.hasNode(string3)) {
                return new ArrayList<ResourcePackage>();
            }
            Node node2 = node.getNode(string3);
            Property property = node2.getProperty("_data");
            Binary binary = property.getBinary();
            InputStream inputStream = binary.getStream();
            String string4 = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
            inputStream.close();
            ArrayList<ResourcePackage> arrayList = new ArrayList<ResourcePackage>();
            List<ResourcePackage> list = this.parseResourcePackages(string2, string4);
            block2: for (ResourcePackage resourcePackage : list) {
                if (resourcePackage.getResourceItems() == null) continue;
                for (ResourceItem resourceItem : resourcePackage.getResourceItems()) {
                    if (!string.equals(resourceItem.getPath())) continue;
                    arrayList.add(resourcePackage);
                    continue block2;
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    public List<ResourcePackage> parseResourcePackages(String string, String string2) throws DocumentException, ParseException {
        ArrayList<ResourcePackage> arrayList = new ArrayList<ResourcePackage>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Document document = DocumentHelper.parseText((String)string2);
        Element element = document.getRootElement();
        for (Object e : element.elements()) {
            String string3;
            String string4;
            String string5;
            String string6;
            Element element2;
            if (!(e instanceof Element) || !(element2 = (Element)e).getName().equals("res-package")) continue;
            ResourcePackage resourcePackage = new ResourcePackage();
            String string7 = element2.attributeValue("create_date");
            if (string7 != null) {
                resourcePackage.setCreateDate(simpleDateFormat.parse(string7));
            }
            resourcePackage.setId(element2.attributeValue("id"));
            resourcePackage.setName(element2.attributeValue("name"));
            String string8 = element2.attributeValue("check");
            if (StringUtils.isNotBlank((String)string8)) {
                resourcePackage.setCheck(Boolean.valueOf(string8));
            } else {
                resourcePackage.setCheck(true);
            }
            if (resourcePackage.isCheck()) {
                resourcePackage.setCheckState("\u542f\u7528");
            } else {
                resourcePackage.setCheckState("\u5df2\u505c\u7528");
            }
            resourcePackage.setProject(string);
            String string9 = element2.attributeValue("monitor");
            if (StringUtils.isNotBlank((String)string9)) {
                resourcePackage.setMonitor(Boolean.valueOf(string9));
            }
            if (StringUtils.isNotBlank((String)(string6 = element2.attributeValue("show-log")))) {
                resourcePackage.setShowLog(Boolean.valueOf(string6));
            }
            if (StringUtils.isNotBlank((String)(string5 = element2.attributeValue("show-fired-flow-node-list")))) {
                resourcePackage.setShowFiredFlowNodeList(Boolean.valueOf(string5));
            }
            if (StringUtils.isNotBlank((String)(string4 = element2.attributeValue("show-matched-rule-list")))) {
                resourcePackage.setShowMatchedRuleList(Boolean.valueOf(string4));
            }
            if (StringUtils.isNotBlank((String)(string3 = element2.attributeValue("show-not-match-rule-list")))) {
                resourcePackage.setShowNotMatchRuleList(Boolean.valueOf(string3));
            }
            ArrayList<MonitorObject> arrayList2 = new ArrayList<MonitorObject>();
            ArrayList<MonitorObject> arrayList3 = new ArrayList<MonitorObject>();
            ArrayList<ResourceItem> arrayList4 = new ArrayList<ResourceItem>();
            for (Object e2 : element2.elements()) {
                Object object;
                if (!(e2 instanceof Element)) continue;
                Element element3 = (Element)e2;
                String string10 = element3.getName();
                if (string10.equals("res-package-item")) {
                    object = new ResourceItem();
                    ((ResourceItem)object).setName(element3.attributeValue("name"));
                    ((ResourceItem)object).setPackageId(resourcePackage.getId());
                    ((ResourceItem)object).setPath(element3.attributeValue("path"));
                    ((ResourceItem)object).setVersion(element3.attributeValue("version"));
                    arrayList4.add((ResourceItem)object);
                    continue;
                }
                if (string10.equals("input")) {
                    arrayList2.add(this.b(element3));
                    continue;
                }
                if (string10.equals("output")) {
                    arrayList3.add(this.b(element3));
                    continue;
                }
                if (string10.equals("service")) {
                    object = this.a(element3);
                    ((ServiceConfig)object).setEnabled(resourcePackage.isCheck());
                    resourcePackage.setService((ServiceConfig)object);
                    continue;
                }
                if (!string10.equals("quick-test-data")) continue;
                resourcePackage.setQuickTestData(element3.getText());
            }
            resourcePackage.setInputData(arrayList2);
            resourcePackage.setOutputData(arrayList3);
            resourcePackage.setResourceItems(arrayList4);
            arrayList.add(resourcePackage);
        }
        return arrayList;
    }

    private ServiceConfig a(Element element) {
        ServiceConfig serviceConfig = new ServiceConfig();
        String string = element.attributeValue("security");
        if (StringUtils.isNotBlank((String)string)) {
            serviceConfig.setSecurity(Boolean.valueOf(string));
        }
        if (serviceConfig.isSecurity()) {
            serviceConfig.setUsername(element.attributeValue("username"));
            serviceConfig.setPassword(element.attributeValue("password"));
        }
        ArrayList<MonitorObject> arrayList = new ArrayList<MonitorObject>();
        ArrayList<MonitorObject> arrayList2 = new ArrayList<MonitorObject>();
        for (Object e : element.elements()) {
            if (!(e instanceof Element)) continue;
            Element element2 = (Element)e;
            String string2 = element2.getName();
            if (string2.equals("input")) {
                arrayList.add(this.b(element2));
                continue;
            }
            if (!string2.equals("output")) continue;
            arrayList2.add(this.b(element2));
        }
        serviceConfig.setInputData(arrayList);
        serviceConfig.setOutputData(arrayList2);
        return serviceConfig;
    }

    private MonitorObject b(Element element) {
        MonitorObject monitorObject = new MonitorObject();
        ArrayList<MonitorObjectField> arrayList = new ArrayList<MonitorObjectField>();
        monitorObject.setFields(arrayList);
        monitorObject.setName(element.attributeValue("name"));
        for (Object e : element.elements()) {
            Element element2;
            String string;
            if (!(e instanceof Element) || !(string = (element2 = (Element)e).getName()).equals("field")) continue;
            MonitorObjectField monitorObjectField = new MonitorObjectField();
            monitorObjectField.setName(element2.attributeValue("name"));
            monitorObjectField.setLabel(element2.attributeValue("label"));
            arrayList.add(monitorObjectField);
        }
        return monitorObject;
    }

    @Override
    public void resetProjectResourcePackagesTag(String string) {
        try {
            string = Utils.decodeURL((String)string);
            String string2 = string + "/" + "___res__package__file__";
            string2 = this.processPath(string2);
            Node node = this.getRootNode();
            Node node2 = null;
            node2 = !node.hasNode(string2) ? node.addNode(string2) : node.getNode(string2);
            node2.setProperty("___res__package__file__tag__data_", String.valueOf(new Date().getTime()));
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    @Override
    public String getProjectResourcePackagesTag(String string) {
        try {
            String string2 = string + "/" + "___res__package__file__";
            string2 = this.processPath(string2);
            Node node = this.getRootNode();
            if (!node.hasNode(string2)) {
                return "";
            }
            Node node2 = node.getNode(string2);
            if (node2.hasProperty("___res__package__file__tag__data_")) {
                return node2.getProperty("___res__package__file__tag__data_").getString();
            }
            return "";
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    @Override
    public List<VersionFile> getKnowledgePackges(String string) {
        ArrayList<VersionFile> arrayList = new ArrayList<VersionFile>();
        PackageData packageData = new PackageData(string);
        try {
            String string2 = "___knowledge_package_data__" + packageData.getProject() + "/" + packageData.getPackageId();
            if (!this.getRootNode().hasNode(string2)) {
                return arrayList;
            }
            Node node = this.getRootNode().getNode(string2);
            NodeIterator nodeIterator = node.getNodes();
            while (nodeIterator.hasNext()) {
                Node node2 = nodeIterator.nextNode();
                VersionFile versionFile = new VersionFile();
                if (node2.hasProperty("_actived")) {
                    versionFile.setActived(node2.getProperty("_actived").getBoolean());
                }
                if (node2.hasProperty("_version_comment")) {
                    versionFile.setComment(node2.getProperty("_version_comment").getString());
                }
                if (node2.hasProperty("_version_comment")) {
                    versionFile.setCreateDate(node2.getProperty("_create_date").getDate().getTime());
                }
                if (node2.hasProperty("_create_user")) {
                    versionFile.setCreateUser(node2.getProperty("_create_user").getString());
                }
                if (node2.hasProperty("_timestamp")) {
                    versionFile.setTimestamp(node2.getProperty("_timestamp").getLong());
                }
                versionFile.setName(node2.getName());
                versionFile.setPath(node2.getPath());
                arrayList.add(0, versionFile);
            }
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        return arrayList;
    }

    @Override
    public byte[] getKnowledgePackgeBytes(String string, String string2) {
        byte[] byArray;
        PackageData packageData = new PackageData(string);
        InputStream inputStream = null;
        try {
            byte[] byArray2;
            String string3 = "___knowledge_package_data__" + packageData.getProject() + "/" + packageData.getPackageId() + "/" + string2;
            if (!this.getRootNode().hasNode(string3)) {
                throw new RuleException("Knowledge Package [" + string + ":" + string2 + "] not exist");
            }
            inputStream = this.readFile(string3);
            byArray = byArray2 = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (Exception exception) {
            try {
                throw new RuleException(exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return byArray;
    }

    @Override
    public KnowledgePackage getKnowledgePackge(String string, String string2) {
        KnowledgePackage knowledgePackage;
        PackageData packageData = new PackageData(string);
        InputStream inputStream = null;
        try {
            String string3 = "___knowledge_package_data__" + packageData.getProject() + "/" + packageData.getPackageId() + "/" + string2;
            if (!this.getRootNode().hasNode(string3)) {
                throw new RuleException("Knowledge Package [" + string + ":" + string2 + "] not exist");
            }
            inputStream = this.readFile(string3);
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            String string4 = Utils.uncompress((byte[])byArray);
            KnowledgePackage knowledgePackage2 = Utils.stringToKnowledgePackage((String)string4);
            KnowledgePackageImpl knowledgePackageImpl = (KnowledgePackageImpl)knowledgePackage2;
            knowledgePackageImpl.initForActiveVersion();
            knowledgePackageImpl.setPackageInfo(string);
            Node node = this.getRootNode().getNode(string3);
            if (node.hasProperty("_version_comment")) {
                knowledgePackageImpl.setVersionComment(node.getProperty("_version_comment").getString());
            }
            if (node.hasProperty("_create_date")) {
                knowledgePackageImpl.setVersionCreateDate(node.getProperty("_create_date").getDate().getTime());
            }
            if (node.hasProperty("_create_user")) {
                knowledgePackageImpl.setVersionCreateUser(node.getProperty("_create_user").getString());
            }
            if (string2 != null) {
                knowledgePackageImpl.setVersion(string2);
            }
            knowledgePackageImpl.setVariableCategories(this.getKnowledgePackgeLib(string, string2));
            knowledgePackage = knowledgePackage2;
        }
        catch (Exception exception) {
            try {
                throw new RuleException(exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return knowledgePackage;
    }

    @Override
    public List<VariableCategory> getKnowledgePackgeLib(String string, String string2) {
        InputStream inputStream;
        block4: {
            List list;
            PackageData packageData = new PackageData(string);
            inputStream = null;
            try {
                List list2;
                String string3 = "___knowledge_package_data__" + packageData.getProject() + "/" + packageData.getPackageId() + "/" + string2 + "/lib";
                if (!this.getRootNode().hasNode(string3)) break block4;
                inputStream = this.readFile(string3);
                byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
                String string4 = Utils.uncompress((byte[])byArray);
                list = list2 = Utils.stringToKnowledgePackageLib((String)string4);
            }
            catch (Exception exception) {
                try {
                    throw new RuleException(exception);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return list;
        }
        IOUtils.closeQuietly(inputStream);
        return null;
    }

    @Override
    public InputStream getKnowledgePackgeData(String string, String string2) {
        PackageData packageData = new PackageData(string);
        InputStream inputStream = null;
        try {
            String string3 = "___knowledge_package_data__" + packageData.getProject() + "/" + packageData.getPackageId() + "/" + string2;
            if (!this.getRootNode().hasNode(string3)) {
                throw new RuleException("Knowledge Package [" + string + ":" + string2 + "] not exist");
            }
            InputStream inputStream2 = this.readFile(string3);
            return inputStream2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    @Override
    public void projectRename(String string, String string2) {
        string = this.processPath(string);
        string2 = this.processPath(string2);
        this.a.cleanResourcePackages(string);
        try {
            this.session.refresh(false);
            String string3 = "___knowledge_package_data__" + string;
            Node node = this.getRootNode();
            if (!node.hasNode(string3)) {
                return;
            }
            String string4 = "___knowledge_package_data__" + string2;
            this.session.getWorkspace().move("/" + string3, "/" + string4);
            this.session.save();
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    @Override
    public void removeDeployKnowledgePackge(String string) {
        PackageData packageData = new PackageData(string);
        try {
            this.session.refresh(false);
            Node node = this.getRootNode();
            String string2 = "___knowledge_package_data__" + packageData.getProject() + "/" + packageData.getPackageId();
            if (!node.hasNode(string2)) {
                return;
            }
            Node node2 = this.getRootNode().getNode(string2);
            NodeIterator nodeIterator = node2.getNodes();
            while (nodeIterator.hasNext()) {
                Node node3 = nodeIterator.nextNode();
                node3.remove();
            }
            node2.remove();
            this.session.save();
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    @Override
    public Map<String, Object> loadKnowledgePackageFiles(String string, String string2) {
        PackageData packageData = new PackageData(string);
        try {
            String string3 = "___knowledge_package_data__" + packageData.getProject() + "/" + packageData.getPackageId() + "/" + string2;
            Map<String, Object> map = this.a(string3);
            return map;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    private Map<String, Object> a(String string) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.getRootNode().hasNode(string)) {
            Node node = this.getRootNode().getNode(string);
            PropertyIterator propertyIterator = node.getProperties();
            while (propertyIterator.hasNext()) {
                Property property = propertyIterator.nextProperty();
                String string2 = property.getName();
                if (!(string2 = URLDecoder.decode(string2, "utf-8")).startsWith("_package_file_prefix_")) continue;
                string2 = string2.substring("_package_file_prefix_".length(), string2.length());
                Binary binary = property.getBinary();
                InputStream inputStream = binary.getStream();
                String string3 = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
                Document document = DocumentHelper.parseText((String)string3);
                OutputFormat outputFormat = OutputFormat.createPrettyPrint();
                StringWriter stringWriter = new StringWriter();
                XMLWriter xMLWriter = new XMLWriter((Writer)stringWriter, outputFormat);
                xMLWriter.write(document);
                int n = string2.lastIndexOf(":");
                if (n > -1) {
                    string2 = string2.substring(0, n);
                }
                if (string2.endsWith(FileType.RuleFlow.toString())) {
                    String string4 = this.b(string2);
                    String string5 = string + "/" + string4;
                    Map<String, Object> map = this.a(string5);
                    if (map.size() > 0) {
                        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                        hashMap2.put("value", stringWriter.toString());
                        hashMap2.put("children", map);
                        hashMap.put(string2, hashMap2);
                    } else {
                        hashMap.put(string2, stringWriter.toString());
                    }
                } else {
                    hashMap.put(string2, stringWriter.toString());
                }
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        return hashMap;
    }

    @Override
    public void removeKnowledgePackge(String string, String string2) {
        PackageData packageData = new PackageData(string);
        try {
            this.session.refresh(false);
            String string3 = "___knowledge_package_data__" + packageData.getProject() + "/" + packageData.getPackageId() + "/" + string2;
            if (this.getRootNode().hasNode(string3)) {
                Node node = this.getRootNode().getNode(string3);
                node.remove();
                this.session.save();
            }
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    @Override
    public VersionFile getActivedKnowledgePackge(String string) {
        return this.getActivedKnowledgePackge(string, null);
    }

    @Override
    public VersionFile getActivedKnowledgePackge(String string, String string2) {
        PackageData packageData = new PackageData(string);
        try {
            String string3 = "___knowledge_package_data__" + packageData.getProject() + "/" + packageData.getPackageId();
            if (!this.getRootNode().hasNode(string3)) {
                return null;
            }
            Node node = this.getRootNode().getNode(string3);
            NodeIterator nodeIterator = node.getNodes();
            VersionFile versionFile = null;
            while (nodeIterator.hasNext()) {
                Property property;
                Node node2 = nodeIterator.nextNode();
                if ((string2 == null || !string2.contentEquals(node2.getName())) && (!node2.hasProperty("_actived") || !node2.getProperty("_actived").getBoolean())) continue;
                versionFile = new VersionFile();
                versionFile.setActived(true);
                if (node2.hasProperty("_version_comment")) {
                    versionFile.setComment(node2.getProperty("_version_comment").getString());
                }
                if (node2.hasProperty("_create_date")) {
                    versionFile.setCreateDate(node2.getProperty("_create_date").getDate().getTime());
                }
                if (node2.hasProperty("_create_user")) {
                    versionFile.setCreateUser(node2.getProperty("_create_user").getString());
                }
                versionFile.setTimestamp(node2.getProperty("_timestamp").getLong());
                if (node2.hasProperty("_kp_state") && (property = node2.getProperty("_kp_state")) != null) {
                    boolean bl = property.getBoolean();
                    versionFile.setState(bl);
                }
                versionFile.setName(node2.getName());
                versionFile.setPath(node2.getPath());
                break;
            }
            return versionFile;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    @Override
    public void activeKnowledgePackage(String string, String string2) {
        PackageData packageData = new PackageData(string);
        try {
            this.session.refresh(false);
            String string3 = "___knowledge_package_data__" + packageData.getProject() + "/" + packageData.getPackageId();
            Node node = this.getRootNode().getNode(string3);
            NodeIterator nodeIterator = node.getNodes();
            while (nodeIterator.hasNext()) {
                Node node2 = nodeIterator.nextNode();
                String string4 = node2.getName();
                if (string4.equals(string2)) {
                    node2.getProperty("_actived").setValue(true);
                    continue;
                }
                node2.getProperty("_actived").setValue(false);
            }
            this.session.save();
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    @Override
    public void saveKnowledgePackage(String string, KnowledgePackage knowledgePackage, String string2, String string3, boolean bl) {
        PackageData packageData = new PackageData(string);
        try {
            this.session.refresh(false);
            if (bl) {
                this.a(packageData);
            }
            Node[] nodeArray = this.b(packageData);
            Node node = nodeArray[0];
            Node node2 = nodeArray[1];
            KnowledgePackageImpl knowledgePackageImpl = (KnowledgePackageImpl)knowledgePackage;
            knowledgePackageImpl.setVersion(packageData.getVersion());
            String string4 = Utils.knowledgePackageToString((KnowledgePackage)knowledgePackage);
            String string5 = Utils.knowledgePackageLibToString((KnowledgePackage)knowledgePackage);
            byte[] byArray = Utils.compress((String)string4);
            byte[] byArray2 = Utils.compress((String)string5);
            BinaryImpl binaryImpl = new BinaryImpl(byArray2);
            node2.setProperty("_data", (Binary)binaryImpl);
            BinaryImpl binaryImpl2 = new BinaryImpl(byArray);
            node.setProperty("_data", (Binary)binaryImpl2);
            node.setProperty("_file", true);
            node.setProperty("_create_user", string3);
            node.setProperty("_actived", bl);
            node.setProperty("_kp_state", true);
            node.setProperty("_timestamp", knowledgePackage.getTimestamp());
            List<ResourceItem> list = this.c(string);
            this.a(node, list);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            DateValue dateValue = new DateValue(calendar);
            node.setProperty("_create_date", (Value)dateValue);
            node.setProperty("_version_comment", string2);
            this.session.save();
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    private void a(Node node, List<ResourceItem> list) throws Exception {
        for (ResourceItem resourceItem : list) {
            String string;
            String string2 = resourceItem.getPath();
            if (string2.startsWith("jcr:")) {
                string2 = string2.substring(4, string2.length());
            }
            if ((string = resourceItem.getVersion()) != null && string.equals("LATEST")) {
                string = null;
            }
            InputStream inputStream = this.readFile(string2, string);
            BinaryImpl binaryImpl = new BinaryImpl(inputStream);
            String string3 = resourceItem.getPath();
            if (resourceItem.getVersion() != null) {
                string3 = string3 + ":" + resourceItem.getVersion();
            }
            string3 = URLEncoder.encode(string3, "utf-8");
            node.setProperty("_package_file_prefix_" + string3, (Binary)binaryImpl);
            IOUtils.closeQuietly((InputStream)inputStream);
            if (!string2.endsWith(FileType.RuleFlow.toString())) continue;
            String string4 = this.b(string2);
            List<ResourceItem> list2 = this.a(string2, string);
            Node node2 = node.addNode(string4);
            this.a(node2, list2);
        }
    }

    private String b(String string) {
        int n = string.lastIndexOf("/");
        int n2 = string.indexOf(".");
        String string2 = string.substring(n + 1, n2);
        return string2;
    }

    private List<ResourceItem> a(String string, String string2) throws Exception {
        ArrayList<ResourceItem> arrayList = new ArrayList<ResourceItem>();
        InputStream inputStream = this.readFile(string, string2);
        String string3 = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
        inputStream.close();
        Document document = DocumentHelper.parseText((String)string3);
        Element element = document.getRootElement();
        for (Object e : element.elements()) {
            Element element2;
            if (e == null || !(e instanceof Element) || !(element2 = (Element)e).getName().equals("rule")) continue;
            String string4 = element2.attributeValue("file");
            String string5 = element2.attributeValue("version");
            ResourceItem resourceItem = new ResourceItem();
            resourceItem.setPath(string4);
            resourceItem.setVersion(string5);
            arrayList.add(resourceItem);
        }
        return arrayList;
    }

    private List<ResourceItem> c(String string) {
        String[] stringArray = string.split("/");
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        List<ResourcePackage> list = this.loadProjectResourcePackages(string2);
        List<ResourceItem> list2 = null;
        for (ResourcePackage resourcePackage : list) {
            if (!resourcePackage.getId().equals(string3)) continue;
            list2 = resourcePackage.getResourceItems();
            break;
        }
        if (list2 == null) {
            throw new RuleException("\u9879\u76ee\u3010" + string2 + "\u3011\u4e0b\u77e5\u8bc6\u5305\u3010" + string3 + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        return list2;
    }

    private void a(PackageData packageData) throws Exception {
        String string = "___knowledge_package_data__" + packageData.getProject() + "/" + packageData.getPackageId();
        this.session.refresh(false);
        if (!this.getRootNode().hasNode(string)) {
            return;
        }
        Node node = this.getRootNode().getNode(string);
        NodeIterator nodeIterator = node.getNodes();
        while (nodeIterator.hasNext()) {
            Node node2 = nodeIterator.nextNode();
            node2.setProperty("_actived", false);
        }
        this.session.save();
    }

    private Node[] b(PackageData packageData) throws Exception {
        String string;
        this.session.refresh(false);
        String string2 = "___knowledge_package_data__" + packageData.getProject();
        Node node = this.getRootNode();
        Node node2 = null;
        if (!node.hasNode(string2)) {
            node2 = node.addNode(string2);
            this.session.save();
        }
        if (node.hasNode(string = string2 + "/" + packageData.getPackageId())) {
            node2 = node.getNode(string);
        } else {
            node2 = node.addNode(string);
            this.session.save();
        }
        BigDecimal bigDecimal = new BigDecimal(this.a(node2));
        bigDecimal = bigDecimal.compareTo(new BigDecimal(0)) == 0 ? new BigDecimal(1.0) : bigDecimal.add(new BigDecimal(0.1));
        String string3 = bigDecimal.setScale(1, 4).toPlainString();
        packageData.setVersion(string3);
        string = string + "/" + string3;
        node2 = node.addNode(string);
        String string4 = string + "/lib";
        Node node3 = node.addNode(string4);
        this.session.save();
        return new Node[]{node2, node3};
    }

    private float a(Node node) throws Exception {
        float f = 0.0f;
        NodeIterator nodeIterator = node.getNodes();
        while (nodeIterator.hasNext()) {
            Node node2 = nodeIterator.nextNode();
            String string = node2.getName();
            float f2 = 0.0f;
            if (StringUtils.isNotBlank((String)string)) {
                f2 = Float.valueOf(string).floatValue();
            }
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    @Override
    public KnowledgePackageUpdateIntercepter getKnowledgePackageUpdateIntercepter() {
        return this.knowledgePackageUpdateIntercepter;
    }

    public void setResourcePackageCache(ResourcePackageCache resourcePackageCache) {
        this.a = resourcePackageCache;
    }
}

