/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository;

import com.bstek.urule.SpringBootHome;
import com.bstek.urule.exception.RuleException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.AccessManagerConfig;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.ClusterConfig;
import org.apache.jackrabbit.core.config.DataSourceConfig;
import org.apache.jackrabbit.core.config.LoginModuleConfig;
import org.apache.jackrabbit.core.config.PersistenceManagerConfig;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.RepositoryConfigurationParser;
import org.apache.jackrabbit.core.config.SecurityConfig;
import org.apache.jackrabbit.core.config.SecurityManagerConfig;
import org.apache.jackrabbit.core.config.VersioningConfig;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreFactory;
import org.apache.jackrabbit.core.data.FileDataStore;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemFactory;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.query.QueryHandlerFactory;
import org.apache.jackrabbit.core.state.DefaultISMLocking;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ISMLockingFactory;
import org.apache.jackrabbit.core.util.CooperativeFileLock;
import org.apache.jackrabbit.core.util.RepositoryLockMechanism;
import org.apache.jackrabbit.core.util.RepositoryLockMechanismFactory;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RepositoryBuilder
implements InitializingBean,
ApplicationContextAware {
    private String a;
    private Element b;
    private RepositoryImpl c;
    private String d;
    private ApplicationContext e;
    private String f;
    private boolean g = true;
    public static String databaseType;
    public static DataSource datasource;
    private Logger h = Logger.getLogger(RepositoryBuilder.class.getName());

    public RepositoryImpl getRepository() {
        return this.c;
    }

    private SecurityConfig a() {
        SecurityConfig securityConfig = new SecurityConfig("uruleRepoSecurity", this.g(), this.h(), this.i());
        return securityConfig;
    }

    private RepositoryLockMechanismFactory b() {
        return new RepositoryLockMechanismFactory(){

            public RepositoryLockMechanism getRepositoryLockMechanism() throws RepositoryException {
                return new CooperativeFileLock();
            }
        };
    }

    private FileSystemFactory a(final String string) {
        return new FileSystemFactory(){

            public FileSystem getFileSystem() throws RepositoryException {
                try {
                    LocalFileSystem localFileSystem = new LocalFileSystem();
                    localFileSystem.setPath("" + RepositoryBuilder.this.a + "/" + string);
                    localFileSystem.init();
                    return localFileSystem;
                }
                catch (FileSystemException fileSystemException) {
                    throw new RepositoryException("File system initialization failure.", (Throwable)fileSystemException);
                }
            }
        };
    }

    private DataStoreFactory c() {
        return new DataStoreFactory(){

            public DataStore getDataStore() throws RepositoryException {
                FileDataStore fileDataStore = new FileDataStore();
                fileDataStore.setPath("" + RepositoryBuilder.this.a + "/repository/datastore");
                fileDataStore.setMinRecordLength(100);
                return null;
            }
        };
    }

    private VersioningConfig d() {
        String string = "" + this.a + "/version";
        FileSystemFactory fileSystemFactory = this.a("version");
        PersistenceManagerConfig persistenceManagerConfig = this.f();
        ISMLockingFactory iSMLockingFactory = this.e();
        VersioningConfig versioningConfig = new VersioningConfig(string, fileSystemFactory, persistenceManagerConfig, iSMLockingFactory);
        return versioningConfig;
    }

    private ISMLockingFactory e() {
        return new ISMLockingFactory(){

            public ISMLocking getISMLocking() throws RepositoryException {
                return new DefaultISMLocking();
            }
        };
    }

    private PersistenceManagerConfig f() {
        Properties properties = new Properties();
        BeanConfig beanConfig = new BeanConfig("org.apache.jackrabbit.core.persistence.bundle.BundleFsPersistenceManager", properties);
        PersistenceManagerConfig persistenceManagerConfig = new PersistenceManagerConfig(beanConfig);
        return persistenceManagerConfig;
    }

    private SecurityManagerConfig g() {
        Properties properties = new Properties();
        BeanConfig beanConfig = new BeanConfig("org.apache.jackrabbit.core.security.simple.SimpleSecurityManager", properties);
        SecurityManagerConfig securityManagerConfig = new SecurityManagerConfig(beanConfig, "default", null);
        return securityManagerConfig;
    }

    private AccessManagerConfig h() {
        Properties properties = new Properties();
        BeanConfig beanConfig = new BeanConfig("org.apache.jackrabbit.core.security.simple.SimpleAccessManager", properties);
        AccessManagerConfig accessManagerConfig = new AccessManagerConfig(beanConfig);
        return accessManagerConfig;
    }

    private LoginModuleConfig i() {
        Properties properties = new Properties();
        properties.put("anonymousId", "anonymous");
        properties.put("adminId", "admin");
        BeanConfig beanConfig = new BeanConfig("org.apache.jackrabbit.core.security.simple.SimpleLoginModule", properties);
        LoginModuleConfig loginModuleConfig = new LoginModuleConfig(beanConfig);
        return loginModuleConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(String string) throws Exception {
        this.h.info("Build repository from user custom xml file...");
        try (InputStream inputStream = null;){
            Object object;
            inputStream = this.e.getResource(string).getInputStream();
            String string2 = System.getProperty("java.io.tmpdir");
            if (StringUtils.isNotBlank((String)string2) && string2.length() > 1) {
                string2 = string2.endsWith("/") || string2.endsWith("\\") ? string2 + "urule-temp-repo-home/" : string2 + "/urule-temp-repo-home/";
                object = new File(string2);
                this.a((File)object);
            } else {
                string2 = "";
            }
            object = RepositoryConfig.create((InputStream)inputStream, (String)string2);
            this.c = RepositoryImpl.create((RepositoryConfig)object);
        }
    }

    private void a(File file) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.a(file2);
            }
        }
        file.delete();
    }

    private void j() throws Exception {
        SecurityConfig securityConfig = this.a();
        FileSystemFactory fileSystemFactory = this.a("repository");
        String string = "" + this.a + "/workspaces";
        String string2 = null;
        String string3 = "default";
        int n = 0;
        VersioningConfig versioningConfig = this.d();
        QueryHandlerFactory queryHandlerFactory = null;
        ClusterConfig clusterConfig = null;
        DataStoreFactory dataStoreFactory = this.c();
        RepositoryLockMechanismFactory repositoryLockMechanismFactory = this.b();
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        ConnectionFactory connectionFactory = new ConnectionFactory();
        RepositoryConfigurationParser repositoryConfigurationParser = new RepositoryConfigurationParser(new Properties());
        this.k();
        RepositoryConfig repositoryConfig = new RepositoryConfig(this.a, securityConfig, fileSystemFactory, string, string2, string3, n, this.b, versioningConfig, queryHandlerFactory, clusterConfig, dataStoreFactory, repositoryLockMechanismFactory, dataSourceConfig, connectionFactory, repositoryConfigurationParser);
        repositoryConfig.init();
        this.c = RepositoryImpl.create((RepositoryConfig)repositoryConfig);
        File file = new File(this.a);
        System.out.println("Use \"" + file.getCanonicalPath() + "\" as urule repository home directory");
    }

    private void k() {
        InputStream inputStream = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            inputStream = this.e.getResource("classpath:com/bstek/urule/console/repository/workspace_template.xml").getInputStream();
            Document document = documentBuilder.parse(inputStream);
            this.b = document.getDocumentElement();
        }
        catch (Exception exception) {
            try {
                throw new RuleException(exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.e = applicationContext;
    }

    private void a(ApplicationContext applicationContext) {
        if (applicationContext instanceof WebApplicationContext) {
            WebApplicationContext webApplicationContext = (WebApplicationContext)applicationContext;
            File file = new File(this.a);
            if (!file.exists()) {
                String string;
                ServletContext servletContext = webApplicationContext.getServletContext();
                this.a = servletContext != null ? (StringUtils.isBlank((String)(string = servletContext.getRealPath(this.a))) || !new File(string).exists() ? this.l() : string) : this.l();
            }
            if (!(file = new File(this.a)).exists()) {
                throw new RuleException("Repository root dir " + this.a + " is not exist.");
            }
        } else {
            this.h.info("Current is not a standard web container,so can't resolve real path for repo home dir.");
        }
        System.out.println("Use \"" + this.a + "\" as urule repository home directory.");
    }

    private String l() {
        SpringBootHome springBootHome = new SpringBootHome();
        File file = springBootHome.findSpringbootJarHomeDir(this.getClass());
        String string = file.getAbsolutePath();
        this.a = this.a.startsWith("/") ? string + this.a : string + "/" + this.a;
        File file2 = new File(this.a);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        try {
            this.a = file2.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.a;
    }

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isNotBlank((String)this.f)) {
            datasource = (DataSource)this.e.getBean(this.f);
        }
        if (this.c != null) {
            this.c.shutdown();
        }
        if (StringUtils.isNotBlank((String)this.a)) {
            this.a(this.e);
        }
        if (StringUtils.isNotBlank((String)this.d)) {
            this.b(this.d);
        } else if (datasource != null) {
            if (databaseType == null) {
                throw new RuleException("You need config \"urule.repository.databasetype\" property when use spring datasource!");
            }
            this.m();
        } else {
            if (StringUtils.isBlank((String)this.a)) {
                throw new RuleException("You need config \"urule.repository.dir\" property for set repository home dir.");
            }
            this.j();
        }
    }

    private void m() throws Exception {
        System.out.println("Init repository from spring datasource [" + this.f + "] with database type [" + databaseType + "]...");
        String string = databaseType;
        if (!this.g) {
            string = string + "-without-cluster";
        }
        String string2 = "classpath:com/bstek/urule/console/repository/database/configs/" + string + ".xml";
        this.b(string2);
    }

    public void setRepoHomeDir(String string) {
        if (string.startsWith("${")) {
            return;
        }
        this.a = string;
    }

    public void setRepositoryXml(String string) {
        if (string.startsWith("${")) {
            return;
        }
        this.d = string;
    }

    public void setDatabaseType(String string) {
        if (string.startsWith("${")) {
            return;
        }
        databaseType = string;
    }

    public void setDatabaseCluster(boolean bl) {
        this.g = bl;
    }

    public void setRepositoryDatasourceName(String string) {
        if (string.startsWith("${")) {
            return;
        }
        this.f = string;
    }

    public void destroy() {
        System.out.println("Shutdown repository...");
        this.c.shutdown();
        System.out.println("Shutdown repository completed...");
    }
}

