/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository;

import com.bstek.urule.console.Principal;
import com.bstek.urule.console.exception.NodeLockException;
import com.bstek.urule.console.repository.BaseRepositoryService;
import com.bstek.urule.console.repository.ClientConfig;
import com.bstek.urule.console.repository.ClientProvider;
import com.bstek.urule.console.repository.ImportProjectProcessor;
import com.bstek.urule.console.repository.ProjectVariable;
import com.bstek.urule.console.repository.Repository;
import com.bstek.urule.console.repository.RepositoryService;
import com.bstek.urule.console.repository.model.FileType;
import com.bstek.urule.console.repository.model.LibType;
import com.bstek.urule.console.repository.model.RepositoryFile;
import com.bstek.urule.console.repository.model.Type;
import com.bstek.urule.console.repository.refactor.Item;
import com.bstek.urule.console.repository.refactor.RefactorService;
import com.bstek.urule.console.repository.refactor.RefactorServiceImpl;
import com.bstek.urule.exception.RuleException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Value;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.value.BinaryImpl;
import org.apache.jackrabbit.value.DateValue;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RepositoryServiceImpl
extends BaseRepositoryService
implements RepositoryService,
ApplicationContextAware {
    private ClientProvider a;
    protected RefactorService refactorService;
    private ImportProjectProcessor b;

    @Override
    public List<ClientConfig> loadClientConfigs(String string, boolean bl) throws Exception {
        String string2;
        ArrayList<ClientConfig> arrayList = new ArrayList<ClientConfig>();
        if (this.a != null) {
            List<ClientConfig> list = this.a.loadClients(string, bl);
            if (list == null) {
                return arrayList;
            }
            return list;
        }
        Node node = this.getRootNode();
        if (!node.hasNode(string2 = this.processPath(string) + "/" + "___client_config__file__")) {
            return arrayList;
        }
        Node node2 = node.getNode(string2);
        Property property = node2.getProperty("_data");
        Binary binary = property.getBinary();
        InputStream inputStream = binary.getStream();
        String string3 = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
        inputStream.close();
        Document document = DocumentHelper.parseText((String)string3);
        Element element = document.getRootElement();
        for (Object e : element.elements()) {
            Element element2;
            if (!(e instanceof Element) || !(element2 = (Element)e).getName().equals("item")) continue;
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.setName(element2.attributeValue("name"));
            clientConfig.setClient(element2.attributeValue("client"));
            String string4 = element2.attributeValue("enabled");
            if (string4 == null) {
                clientConfig.setEnabled(true);
            } else {
                clientConfig.setEnabled(Boolean.valueOf(string4));
            }
            clientConfig.setProject(string);
            if (bl) {
                arrayList.add(clientConfig);
                continue;
            }
            if (!clientConfig.isEnabled()) continue;
            arrayList.add(clientConfig);
        }
        return arrayList;
    }

    @Override
    public ClientProvider getClientProvider() {
        return this.a;
    }

    @Override
    public List<RepositoryFile> getDirectories(String string) throws Exception {
        Object object;
        Object object2;
        Node node = this.getRootNode();
        NodeIterator nodeIterator = node.getNodes();
        Object object3 = null;
        while (nodeIterator.hasNext()) {
            object2 = nodeIterator.nextNode();
            if (!object2.hasProperty("_file")) continue;
            object = object2.getName();
            if (string != null && !string.equals(object)) continue;
            object3 = object2;
            break;
        }
        if (object3 == null) {
            throw new RuleException("Project [" + string + "] not exist.");
        }
        object2 = new ArrayList();
        object = new RepositoryFile();
        ((RepositoryFile)object).setName("\u6839\u76ee\u5f55");
        String string2 = object3.getPath();
        ((RepositoryFile)object).setFullPath(string2);
        object2.add(object);
        NodeIterator nodeIterator2 = object3.getNodes();
        while (nodeIterator2.hasNext()) {
            Node node2 = nodeIterator2.nextNode();
            if (!node2.hasProperty("_dir")) continue;
            RepositoryFile repositoryFile = new RepositoryFile();
            repositoryFile.setName(node2.getPath().substring(string2.length()));
            repositoryFile.setFullPath(node2.getPath());
            object2.add(repositoryFile);
            this.a(node2, (List<RepositoryFile>)object2, string2);
        }
        return object2;
    }

    private void a(Node node, List<RepositoryFile> list, String string) throws Exception {
        NodeIterator nodeIterator = node.getNodes();
        while (nodeIterator.hasNext()) {
            Node node2 = nodeIterator.nextNode();
            if (!node2.hasProperty("_file") || !node2.hasProperty("_dir")) continue;
            RepositoryFile repositoryFile = new RepositoryFile();
            repositoryFile.setName(node2.getPath().substring(string.length()));
            repositoryFile.setFullPath(node2.getPath());
            this.a(node2, list, string);
            list.add(repositoryFile);
        }
    }

    @Override
    public Repository loadRepository(String string, Principal principal, boolean bl, FileType[] fileTypeArray, String string2) throws Exception {
        String string3 = null;
        if (principal != null) {
            string3 = principal.getCompanyId();
            this.a(principal);
        }
        if (string != null && string.startsWith("/")) {
            string = string.substring(1, string.length());
        }
        Repository repository = new Repository();
        ArrayList<String> arrayList = new ArrayList<String>();
        repository.setProjectNames(arrayList);
        RepositoryFile repositoryFile = new RepositoryFile();
        repositoryFile.setFullPath("/");
        repositoryFile.setName("\u9879\u76ee\u5217\u8868");
        repositoryFile.setType(Type.root);
        Node node = this.getRootNode();
        NodeIterator nodeIterator = node.getNodes();
        while (nodeIterator.hasNext()) {
            String string4;
            Node node2 = nodeIterator.nextNode();
            if (!node2.hasProperty("_file") || StringUtils.isNotEmpty((String)string3) && node2.hasProperty("_company_id") && !string3.equals(string4 = node2.getProperty("_company_id").getString()) || (string4 = node2.getName()).indexOf("___resource_authority_config__file__") > -1 || string4.indexOf("___temp_mount_project_node_for_import__") > -1 || StringUtils.isNotBlank((String)string) && !string.equals(string4)) continue;
            if (StringUtils.isBlank((String)string)) {
                arrayList.add(string4);
            }
            RepositoryFile repositoryFile2 = this.buildProjectFile(node2, fileTypeArray, bl, string2);
            repositoryFile.addChild(repositoryFile2, false);
        }
        if (StringUtils.isNotEmpty((String)string2)) {
            this.a(repositoryFile);
        }
        repository.setRootFile(repositoryFile);
        return repository;
    }

    private void a(RepositoryFile repositoryFile) {
        if (this.b(repositoryFile)) {
            return;
        }
        List<RepositoryFile> list = repositoryFile.getChildren();
        if (list == null || list.size() == 0) {
            return;
        }
        ArrayList<RepositoryFile> arrayList = new ArrayList<RepositoryFile>(list.size());
        arrayList.addAll(list);
        for (RepositoryFile repositoryFile2 : arrayList) {
            this.a(repositoryFile2);
        }
        this.b(repositoryFile);
    }

    private boolean b(RepositoryFile repositoryFile) {
        if (repositoryFile.getChildren() == null || repositoryFile.getChildren().size() == 0) {
            RepositoryFile repositoryFile2 = repositoryFile.getParentFile();
            if (repositoryFile.getType().equals((Object)Type.folder)) {
                repositoryFile2.getChildren().remove(repositoryFile);
                return true;
            }
        }
        return false;
    }

    @Override
    public List<ProjectVariable> loadProjectLibraries(String string, Principal principal) throws Exception {
        Repository repository = this.loadRepository(string, principal, false, new FileType[]{FileType.VariableLibrary, FileType.ParameterLibrary}, null);
        List<RepositoryFile> list = repository.getRootFile().getChildren();
        ArrayList<ProjectVariable> arrayList = new ArrayList<ProjectVariable>();
        this.a(list, arrayList);
        return arrayList;
    }

    private void a(List<RepositoryFile> list, List<ProjectVariable> list2) {
        if (list == null) {
            return;
        }
        for (RepositoryFile repositoryFile : list) {
            String string = repositoryFile.getFullPath();
            if (string.endsWith(FileType.VariableLibrary.toString()) || string.endsWith(FileType.ParameterLibrary.toString())) {
                ProjectVariable projectVariable = new ProjectVariable();
                projectVariable.setPath(string);
                list2.add(projectVariable);
            }
            this.a(repositoryFile.getChildren(), list2);
        }
    }

    protected RepositoryFile buildProjectFile(Node node, FileType[] fileTypeArray, boolean bl, String string) throws Exception {
        RepositoryFile repositoryFile = new RepositoryFile();
        repositoryFile.setType(Type.project);
        repositoryFile.setName(node.getName());
        repositoryFile.setFullPath("/" + node.getName());
        RepositoryFile repositoryFile2 = new RepositoryFile();
        repositoryFile2.setFullPath(repositoryFile.getFullPath());
        repositoryFile2.setName("\u8d44\u6e90");
        if (fileTypeArray == null || fileTypeArray.length == 0) {
            RepositoryFile repositoryFile3 = new RepositoryFile();
            repositoryFile3.setName("\u77e5\u8bc6\u5305");
            repositoryFile3.setType(Type.resourcePackage);
            repositoryFile3.setFullPath(repositoryFile.getFullPath());
            repositoryFile.addChild(repositoryFile3, false);
        }
        if (bl) {
            repositoryFile2.setType(Type.resource);
            this.b(node, repositoryFile2, fileTypeArray, string);
        } else {
            repositoryFile2.setType(Type.all);
            this.a(node, repositoryFile2, fileTypeArray, string);
        }
        repositoryFile.addChild(repositoryFile2, false);
        return repositoryFile;
    }

    private void a(Node node, RepositoryFile repositoryFile, FileType[] fileTypeArray, String string) throws Exception {
        FileType[] fileTypeArray2 = fileTypeArray;
        if (fileTypeArray == null || fileTypeArray.length == 0) {
            fileTypeArray2 = new FileType[]{FileType.VariableLibrary, FileType.ParameterLibrary, FileType.ConstantLibrary, FileType.ActionLibrary, FileType.Ruleset, FileType.RuleFlow, FileType.DecisionTable, FileType.Crosstab, FileType.DecisionTree, FileType.ScriptDecisionTable, FileType.UL, FileType.Scorecard, FileType.ComplexScorecard, FileType.ConditionTemplate, FileType.ActionTemplate};
        }
        repositoryFile.setLibType(LibType.all);
        this.a(node.getNodes(), repositoryFile, fileTypeArray2, Type.all, string);
    }

    private void b(Node node, RepositoryFile repositoryFile, FileType[] fileTypeArray, String string) throws Exception {
        RepositoryFile repositoryFile2 = this.a(repositoryFile, "\u5e93", LibType.res);
        repositoryFile2.setType(Type.lib);
        repositoryFile.addChild(repositoryFile2, false);
        FileType[] fileTypeArray2 = fileTypeArray;
        if (fileTypeArray == null || fileTypeArray.length == 0) {
            fileTypeArray2 = new FileType[]{FileType.VariableLibrary, FileType.ParameterLibrary, FileType.ConstantLibrary, FileType.ActionLibrary};
        }
        this.a(node.getNodes(), repositoryFile2, fileTypeArray2, Type.lib, string);
        RepositoryFile repositoryFile3 = this.a(repositoryFile, "\u51b3\u7b56\u96c6", LibType.ruleset);
        repositoryFile3.setFullPath(repositoryFile.getFullPath());
        repositoryFile3.setType(Type.ruleLib);
        RepositoryFile repositoryFile4 = this.a(repositoryFile, "\u51b3\u7b56\u8868", LibType.decisiontable);
        repositoryFile4.setFullPath(repositoryFile.getFullPath());
        repositoryFile4.setType(Type.decisionTableLib);
        RepositoryFile repositoryFile5 = this.a(repositoryFile, "\u51b3\u7b56\u6811", LibType.decisiontree);
        repositoryFile5.setFullPath(repositoryFile.getFullPath());
        repositoryFile5.setType(Type.decisionTreeLib);
        RepositoryFile repositoryFile6 = this.a(repositoryFile, "\u8bc4\u5206\u5361", LibType.scorecard);
        repositoryFile6.setFullPath(repositoryFile.getFullPath());
        repositoryFile6.setType(Type.scorecardLib);
        RepositoryFile repositoryFile7 = this.a(repositoryFile, "\u51b3\u7b56\u6d41", LibType.ruleflow);
        repositoryFile7.setFullPath(repositoryFile.getFullPath());
        repositoryFile7.setType(Type.flowLib);
        repositoryFile.addChild(repositoryFile3, false);
        repositoryFile.addChild(repositoryFile4, false);
        repositoryFile.addChild(repositoryFile5, false);
        repositoryFile.addChild(repositoryFile6, false);
        repositoryFile.addChild(repositoryFile7, false);
        FileType[] fileTypeArray3 = fileTypeArray;
        if (fileTypeArray == null || fileTypeArray.length == 0) {
            fileTypeArray3 = new FileType[]{FileType.Ruleset, FileType.UL, FileType.ConditionTemplate, FileType.ActionTemplate};
        }
        FileType[] fileTypeArray4 = fileTypeArray;
        if (fileTypeArray == null || fileTypeArray.length == 0) {
            fileTypeArray4 = new FileType[]{FileType.DecisionTable, FileType.ScriptDecisionTable, FileType.Crosstab};
        }
        FileType[] fileTypeArray5 = fileTypeArray;
        if (fileTypeArray == null || fileTypeArray.length == 0) {
            fileTypeArray5 = new FileType[]{FileType.DecisionTree};
        }
        FileType[] fileTypeArray6 = fileTypeArray;
        if (fileTypeArray == null || fileTypeArray.length == 0) {
            fileTypeArray6 = new FileType[]{FileType.RuleFlow};
        }
        FileType[] fileTypeArray7 = fileTypeArray;
        if (fileTypeArray == null || fileTypeArray.length == 0) {
            fileTypeArray7 = new FileType[]{FileType.Scorecard, FileType.ComplexScorecard};
        }
        this.a(node.getNodes(), repositoryFile3, fileTypeArray3, Type.ruleLib, string);
        this.a(node.getNodes(), repositoryFile4, fileTypeArray4, Type.decisionTableLib, string);
        this.a(node.getNodes(), repositoryFile5, fileTypeArray5, Type.decisionTreeLib, string);
        this.a(node.getNodes(), repositoryFile6, fileTypeArray7, Type.scorecardLib, string);
        this.a(node.getNodes(), repositoryFile7, fileTypeArray6, Type.flowLib, string);
    }

    private RepositoryFile a(RepositoryFile repositoryFile, String string, LibType libType) {
        RepositoryFile repositoryFile2 = new RepositoryFile();
        repositoryFile2.setFullPath(repositoryFile.getFullPath());
        repositoryFile2.setName(string);
        repositoryFile2.setLibType(libType);
        return repositoryFile2;
    }

    private void a(NodeIterator nodeIterator, RepositoryFile repositoryFile, FileType[] fileTypeArray, Type type, String string) throws Exception {
        LibType libType = repositoryFile.getLibType();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            if (!node.hasProperty("_file")) continue;
            RepositoryFile repositoryFile2 = new RepositoryFile();
            repositoryFile2.setLibType(libType);
            String string2 = node.getName();
            if (string2.toLowerCase().indexOf("___res__package__file__") > -1 || string2.toLowerCase().indexOf("___client_config__file__") > -1 || string2.toLowerCase().indexOf("___resource_authority_config__file__") > -1) continue;
            if (!node.hasProperty("_dir")) {
                Enum enum_ = null;
                boolean bl = false;
                for (FileType fileType : fileTypeArray) {
                    if (!string2.toLowerCase().endsWith(fileType.toString())) continue;
                    enum_ = fileType;
                    bl = true;
                    break;
                }
                if (!bl || libType.equals((Object)LibType.res) && !enum_.equals((Object)FileType.ActionLibrary) && !enum_.equals((Object)FileType.ParameterLibrary) && !enum_.equals((Object)FileType.ConstantLibrary) && !enum_.equals((Object)FileType.VariableLibrary) || libType.equals((Object)LibType.decisiontable) && !enum_.equals((Object)FileType.ScriptDecisionTable) && !enum_.equals((Object)FileType.DecisionTable) && !enum_.equals((Object)FileType.Crosstab) || libType.equals((Object)LibType.decisiontree) && !enum_.equals((Object)FileType.DecisionTree) || libType.equals((Object)LibType.ruleflow) && !enum_.equals((Object)FileType.RuleFlow) || libType.equals((Object)LibType.scorecard) && !enum_.equals((Object)FileType.Scorecard) && !enum_.equals((Object)FileType.ComplexScorecard) || libType.equals((Object)LibType.ruleset) && !enum_.equals((Object)FileType.Ruleset) && !enum_.equals((Object)FileType.UL) && !enum_.equals((Object)FileType.ConditionTemplate) && !enum_.equals((Object)FileType.ActionTemplate) || StringUtils.isNotBlank((String)string) && string2.toLowerCase().indexOf(string.toLowerCase()) == -1) continue;
                if (string2.toLowerCase().endsWith(FileType.ActionLibrary.toString())) {
                    repositoryFile2.setType(Type.action);
                } else if (string2.toLowerCase().endsWith(FileType.VariableLibrary.toString())) {
                    repositoryFile2.setType(Type.variable);
                } else if (string2.toLowerCase().endsWith(FileType.ConstantLibrary.toString())) {
                    repositoryFile2.setType(Type.constant);
                } else if (string2.toLowerCase().endsWith(FileType.Ruleset.toString())) {
                    repositoryFile2.setType(Type.rule);
                } else if (string2.toLowerCase().endsWith(FileType.DecisionTable.toString())) {
                    repositoryFile2.setType(Type.decisionTable);
                } else if (string2.toLowerCase().endsWith(FileType.Crosstab.toString())) {
                    repositoryFile2.setType(Type.crosstab);
                } else if (string2.toLowerCase().endsWith(FileType.UL.toString())) {
                    repositoryFile2.setType(Type.ul);
                } else if (string2.toLowerCase().endsWith(FileType.ParameterLibrary.toString())) {
                    repositoryFile2.setType(Type.parameter);
                } else if (string2.toLowerCase().endsWith(FileType.RuleFlow.toString())) {
                    repositoryFile2.setType(Type.flow);
                } else if (string2.toLowerCase().endsWith(FileType.ScriptDecisionTable.toString())) {
                    repositoryFile2.setType(Type.scriptDecisionTable);
                } else if (string2.toLowerCase().endsWith(FileType.DecisionTree.toString())) {
                    repositoryFile2.setType(Type.decisionTree);
                } else if (string2.toLowerCase().endsWith(FileType.Scorecard.toString())) {
                    repositoryFile2.setType(Type.scorecard);
                } else if (string2.toLowerCase().endsWith(FileType.ComplexScorecard.toString())) {
                    repositoryFile2.setType(Type.complexscorecard);
                } else if (string2.toLowerCase().endsWith(FileType.ConditionTemplate.toString())) {
                    repositoryFile2.setType(Type.conditionTemplate);
                } else if (string2.toLowerCase().endsWith(FileType.ActionTemplate.toString())) {
                    repositoryFile2.setType(Type.actionTemplate);
                }
                repositoryFile2.setFullPath(node.getPath());
                repositoryFile2.setName(string2);
                this.a(node, repositoryFile2);
                repositoryFile.addChild(repositoryFile2, false);
                this.a(node.getNodes(), repositoryFile2, fileTypeArray, type, string);
                continue;
            }
            repositoryFile2.setFullPath(node.getPath());
            repositoryFile2.setName(string2);
            repositoryFile2.setType(Type.folder);
            this.a(node, repositoryFile2);
            repositoryFile2.setFolderType(type);
            repositoryFile.addChild(repositoryFile2, true);
            this.a(node.getNodes(), repositoryFile2, fileTypeArray, type, string);
        }
    }

    private void a(Node node, RepositoryFile repositoryFile) throws Exception {
        if (!node.hasProperty("_lock_info")) {
            return;
        }
        Property property = node.getProperty("_lock_info");
        String string = property.getString();
        repositoryFile.setLock(true);
        repositoryFile.setLockInfo("\u88ab" + string + "\u9501\u5b9a");
    }

    @Override
    public void lockPath(String string, Principal principal) throws Exception {
        int n = (string = this.processPath(string)).indexOf(":");
        if (n != -1) {
            string = string.substring(0, n);
        }
        this.session.refresh(false);
        Node node = this.getRootNode();
        if (!node.hasNode(string)) {
            throw new RuleException("File [" + string + "] not exist.");
        }
        Node node2 = node.getNode(string);
        String string2 = this.getNodeLockInfo(node2);
        if (string2 != null) {
            throw new NodeLockException("\u3010" + string + "\u3011\u5df2\u88ab" + string2 + "\u9501\u5b9a\uff0c\u4e0d\u80fd\u8fdb\u884c\u518d\u6b21\u9501\u5b9a!");
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        this.a(node2, principal, arrayList, string);
        for (Node node3 : arrayList) {
            String string3 = this.getNodeLockInfo(node3);
            if (string3 == null) continue;
            this.unlockNode(node3);
        }
        arrayList.add(node2);
        for (Node node3 : arrayList) {
            this.lockNode(node3, principal);
        }
    }

    private void a(Node node, Principal principal, List<Node> list, String string) throws Exception {
        NodeIterator nodeIterator = node.getNodes();
        while (nodeIterator.hasNext()) {
            Node node2 = nodeIterator.nextNode();
            String string2 = this.getNodeLockInfo(node2);
            if (string2 == null) continue;
            if (!principal.getName().equals(string2)) {
                throw new NodeLockException("\u5f53\u524d\u76ee\u5f55\u4e0b\u6709\u5b50\u76ee\u5f55\u88ab\u5176\u5b83\u4eba\u9501\u5b9a\uff0c\u60a8\u4e0d\u80fd\u6267\u884c\u9501\u5b9a" + string + "\u76ee\u5f55");
            }
            list.add(node2);
            this.a(node2, principal, list, string);
        }
    }

    @Override
    public void unlockPath(String string, Principal principal) throws Exception {
        Node node;
        int n = (string = this.processPath(string)).indexOf(":");
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (!(node = this.getRootNode()).hasNode(string)) {
            throw new RuleException("File [" + string + "] not exist.");
        }
        Node node2 = node.getNode(string);
        String string2 = this.getNodeLockInfo(node2);
        if (string2 == null) {
            throw new NodeLockException("\u5f53\u524d\u6587\u4ef6\u672a\u9501\u5b9a\uff0c\u4e0d\u9700\u8981\u89e3\u9501!");
        }
        if (!string2.equals(principal.getName())) {
            throw new NodeLockException("\u5f53\u524d\u6587\u4ef6\u7531\u3010" + string2 + "\u3011\u9501\u5b9a\uff0c\u60a8\u65e0\u6743\u89e3\u9501!");
        }
        this.unlockNode(node2);
    }

    @Override
    public void deleteFile(String string, Principal principal) throws Exception {
        this.repositoryInteceptor.deleteFile(string);
        string = this.processPath(string);
        this.session.refresh(false);
        Node node = this.getRootNode();
        if (!node.hasNode(string)) {
            throw new RuleException("File [" + string + "] not exist.");
        }
        String[] stringArray = string.split("/");
        Node node2 = node;
        for (String string2 : stringArray) {
            String[] stringArray2;
            if (StringUtils.isEmpty((String)string2)) continue;
            for (String string3 : stringArray2 = string2.split("\\.")) {
                if (StringUtils.isEmpty((String)string3) || !node2.hasNode(string3)) continue;
                node2 = node2.getNode(string3);
                this.lockCheck(node2, principal);
                if (node2.isCheckedOut()) continue;
                this.versionManager.checkout(node2.getPath());
            }
        }
        node2 = node.getNode(string);
        this.lockCheck(node2, principal);
        if (!node2.isCheckedOut()) {
            this.versionManager.checkout(node2.getPath());
        }
        node2.remove();
        this.session.save();
    }

    @Override
    public String getProject(String string) {
        int n;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((n = string.indexOf("/")) == -1) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    @Override
    public boolean fileExistCheck(String string) throws Exception {
        Node node = this.getRootNode();
        if ((string = this.processPath(string)).contains(" ") || string.equals("")) {
            return true;
        }
        return node.hasNode(string);
    }

    @Override
    public RepositoryFile createProject(String string, Principal principal, boolean bl) throws Exception {
        this.repositoryInteceptor.createProject(string);
        this.session.refresh(false);
        Node node = this.getRootNode();
        if (node.hasNode(string)) {
            throw new RuleException("Project [" + string + "] already exist.");
        }
        Node node2 = node.addNode(string);
        node2.addMixin("mix:versionable");
        node2.setProperty("_file", true);
        node2.setProperty("_create_user", principal.getName());
        node2.setProperty("_company_id", principal.getCompanyId());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        DateValue dateValue = new DateValue(calendar);
        node2.setProperty("_create_date", (Value)dateValue);
        this.session.save();
        this.a(string, principal);
        this.b(string, principal);
        RepositoryFile repositoryFile = this.buildProjectFile(node2, null, bl, null);
        return repositoryFile;
    }

    @Override
    public void createFile(String string, String string2, Principal principal) throws Exception {
        this.a(string, string2, principal, true);
    }

    @Override
    public void fileRename(String string, String string2) throws Exception {
        this.repositoryInteceptor.renameFile(string, string2);
        string = this.processPath(string);
        string2 = this.processPath(string2);
        this.session.refresh(false);
        Node node = this.getRootNode();
        if (!node.hasNode(string)) {
            throw new RuleException("File [" + string + "] not exist.");
        }
        this.refactorService.refactorFile("/" + string, "/" + string2);
        this.session.getWorkspace().move("/" + string, "/" + string2);
        this.session.save();
    }

    @Override
    public void exportXml(String string, OutputStream outputStream) throws Exception {
        this.session.exportSystemView(string, outputStream, false, false);
    }

    @Override
    public void exportXml(OutputStream outputStream) throws Exception {
        this.session.exportSystemView("/", outputStream, false, false);
    }

    @Override
    public void importXml(InputStream inputStream, boolean bl) throws Exception {
        this.session.refresh(false);
        String string = this.getRootNode().getPath();
        if (bl) {
            this.session.importXML(string, inputStream, 2);
        } else {
            Repository repository = this.loadRepository(null, null, false, null, null);
            this.b.doImport(inputStream, repository);
        }
        this.session.save();
    }

    private void a(String string, Principal principal) throws Exception {
        String string2 = this.processPath(string) + "/" + "___res__package__file__";
        Node node = this.getRootNode();
        if (!node.hasNode(string2)) {
            this.createFile(string2, "<?xml version=\"1.0\" encoding=\"utf-8\"?><res-packages></res-packages>", principal);
        }
    }

    private void b(String string, Principal principal) throws Exception {
        String string2;
        Node node = this.getRootNode();
        if (!node.hasNode(string2 = this.processPath(string) + "/" + "___client_config__file__")) {
            this.createFile(string2, "<?xml version=\"1.0\" encoding=\"utf-8\"?><client-config></client-config>", principal);
        }
    }

    private void a(Principal principal) throws Exception {
        String string = principal.getCompanyId();
        String string2 = "___resource_authority_config__file__" + (string == null ? "" : string);
        Node node = this.getRootNode();
        if (!node.hasNode(string2)) {
            this.a(string2, "<?xml version=\"1.0\" encoding=\"utf-8\"?><user-permission></user-permission>", principal, false);
        }
    }

    private void a(String string, String string2, Principal principal, boolean bl) throws Exception {
        String string3 = principal.getName();
        this.repositoryInteceptor.createFile(string, string2);
        this.session.refresh(false);
        Node node = this.getRootNode();
        string = this.processPath(string);
        if (node.hasNode(string)) {
            throw new RuleException("File [" + string + "] already exist.");
        }
        Node node2 = node.addNode(string);
        node2.addMixin("mix:versionable");
        node2.addMixin("mix:lockable");
        BinaryImpl binaryImpl = new BinaryImpl(string2.getBytes("UTF-8"));
        node2.setProperty("_data", (Binary)binaryImpl);
        if (bl) {
            node2.setProperty("_file", true);
        }
        node2.setProperty("_create_user", string3);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        DateValue dateValue = new DateValue(calendar);
        node2.setProperty("_create_date", (Value)dateValue);
        this.session.save();
    }

    @Override
    public void refactorContent(String string, Item item) throws Exception {
        this.refactorService.refactorItem(string, item);
    }

    @Override
    public boolean fileExist(String string) throws Exception {
        Node node = this.getRootNode();
        return node.hasNode(string);
    }

    @Override
    public RefactorService getRefactorService() {
        return this.refactorService;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        this.refactorService = new RefactorServiceImpl(this, applicationContext);
        this.b = new ImportProjectProcessor(this);
        Collection collection = applicationContext.getBeansOfType(ClientProvider.class).values();
        if (collection.size() > 0) {
            this.a = (ClientProvider)collection.iterator().next();
        }
    }
}

