/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository;

import com.bstek.urule.console.Principal;
import com.bstek.urule.console.repository.BaseRepositoryService;
import com.bstek.urule.console.repository.TemplateRepositoryService;
import com.bstek.urule.console.repository.model.RepositoryFile;
import com.bstek.urule.console.repository.model.Type;
import com.bstek.urule.exception.RuleException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Value;
import org.apache.jackrabbit.value.BinaryImpl;
import org.apache.jackrabbit.value.DateValue;

public class TemplateRepositoryServiceImpl
extends BaseRepositoryService
implements TemplateRepositoryService {
    @Override
    public void removeTemplateCategory(String string, String string2) throws Exception {
        String string3 = string + "/" + "__rules_templates__" + "/" + string2;
        string3 = this.processPath(string3);
        this.session.refresh(false);
        Node node = this.getRootNode();
        if (!node.hasNode(string3)) {
            throw new RuleException("File [" + string3 + "] not exist.");
        }
        node.getNode(string3).remove();
        this.session.save();
    }

    @Override
    public void removeTemplateFile(String string) throws Exception {
        string = this.processPath(string);
        this.session.refresh(false);
        Node node = this.getRootNode();
        if (!node.hasNode(string)) {
            throw new RuleException("File [" + string + "] not exist.");
        }
        node.getNode(string).remove();
        this.session.save();
    }

    @Override
    public String createTemplateCategory(Principal principal, String string, String string2) throws Exception {
        String string3 = principal.getName();
        this.session.refresh(false);
        Node node = this.getRootNode();
        String string4 = string + "/" + "__rules_templates__" + "/" + string2;
        string4 = this.processPath(string4);
        if (node.hasNode(string4)) {
            throw new RuleException("File [" + string4 + "] already exist.");
        }
        Node node2 = node.addNode(string4);
        node2.setProperty("_create_user", string3);
        node2.setProperty("_template_category", true);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        DateValue dateValue = new DateValue(calendar);
        node2.setProperty("_create_date", (Value)dateValue);
        this.session.save();
        return string4;
    }

    @Override
    public String saveTemplateFile(String string, String string2) throws Exception {
        string = this.processPath(string);
        this.session.refresh(false);
        Node node = this.getRootNode();
        if (!node.hasNode(string)) {
            throw new RuleException("File [" + string + "] not exist.");
        }
        Node node2 = node.getNode(string);
        BinaryImpl binaryImpl = new BinaryImpl(string2.getBytes("utf-8"));
        node2.setProperty("_data", (Binary)binaryImpl);
        node2.setProperty("_file", true);
        this.session.save();
        return string;
    }

    @Override
    public String createTemplateFile(Principal principal, String string, String string2, String string3) throws Exception {
        String string4 = principal.getName();
        this.session.refresh(false);
        Node node = this.getRootNode();
        string = this.processPath(string);
        if (node.hasNode(string)) {
            throw new RuleException("File [" + string + "] already exist.");
        }
        Node node2 = node.addNode(string);
        BinaryImpl binaryImpl = new BinaryImpl(string3.getBytes("UTF-8"));
        node2.setProperty("_data", (Binary)binaryImpl);
        node2.setProperty("_file", true);
        node2.setProperty("__rules_template_comment__", string2);
        node2.setProperty("_create_user", string4);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        DateValue dateValue = new DateValue(calendar);
        node2.setProperty("_create_date", (Value)dateValue);
        this.session.save();
        return string;
    }

    @Override
    public List<RepositoryFile> loadTemplates(String string) throws Exception {
        String string2 = string + "/" + "__rules_templates__";
        string2 = this.processPath(string2);
        Node node = this.getRootNode();
        Node node2 = null;
        node2 = !node.hasNode(string2) ? node.addNode(string2) : node.getNode(string2);
        ArrayList<RepositoryFile> arrayList = new ArrayList<RepositoryFile>();
        NodeIterator nodeIterator = node2.getNodes();
        while (nodeIterator.hasNext()) {
            Node node3 = nodeIterator.nextNode();
            if (!node3.hasProperty("_template_category")) continue;
            RepositoryFile repositoryFile = new RepositoryFile();
            repositoryFile.setName(node3.getName());
            repositoryFile.setFullPath(node3.getPath());
            repositoryFile.setChildren(this.a(node3));
            arrayList.add(repositoryFile);
        }
        return arrayList;
    }

    private List<RepositoryFile> a(Node node) throws Exception {
        ArrayList<RepositoryFile> arrayList = new ArrayList<RepositoryFile>();
        NodeIterator nodeIterator = node.getNodes();
        while (nodeIterator.hasNext()) {
            Node node2 = nodeIterator.nextNode();
            if (!node2.hasProperty("_file")) continue;
            RepositoryFile repositoryFile = new RepositoryFile();
            repositoryFile.setType(Type.rule);
            repositoryFile.setFullPath(node2.getPath());
            repositoryFile.setName(node2.getName());
            if (node2.hasProperty("__rules_template_comment__")) {
                repositoryFile.setComment(node2.getProperty("__rules_template_comment__").getString());
            }
            arrayList.add(repositoryFile);
        }
        return arrayList;
    }
}

