/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository.authority;

import com.bstek.urule.Utils;
import com.bstek.urule.console.Principal;
import com.bstek.urule.console.repository.BaseRepositoryService;
import com.bstek.urule.console.repository.OperateType;
import com.bstek.urule.console.repository.authority.Authority;
import com.bstek.urule.console.repository.authority.AuthorityRepositoryService;
import com.bstek.urule.console.repository.authority.AuthorityService;
import com.bstek.urule.console.repository.authority.AuthorityUnit;
import com.bstek.urule.exception.RuleException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AuthorityRepositoryServiceImpl
extends BaseRepositoryService
implements AuthorityRepositoryService,
ApplicationContextAware {
    private ApplicationContext a;
    private AuthorityService b;

    @Override
    public void saveAuthority(Principal principal, String string, Authority authority, OperateType operateType) throws Exception {
        Object object;
        String string2 = principal.getCompanyId();
        String string3 = authority.getPath();
        List<AuthorityUnit> list = this.loadAuthorityUnits(string2);
        List<Authority> list2 = null;
        for (AuthorityUnit object2 : list) {
            if (!string.equals(object2.getPrincipalName())) continue;
            list2 = object2.getAuthorities();
            break;
        }
        if (list2 == null) {
            if (operateType.equals((Object)OperateType.add)) {
                object = new AuthorityUnit();
                ((AuthorityUnit)object).setPrincipalName(string);
                list2 = new ArrayList<Authority>();
                ((AuthorityUnit)object).setAuthorities(list2);
                list.add((AuthorityUnit)object);
            } else {
                return;
            }
        }
        object = null;
        if (!operateType.equals((Object)OperateType.add)) {
            for (Authority authority2 : list2) {
                String string4 = authority2.getPath().toLowerCase();
                if (!string4.equals(string3.toLowerCase())) continue;
                object = authority2;
                break;
            }
            if (object == null) {
                throw new RuleException("\u8d44\u6e90\u6587\u4ef6\u3010" + string3 + "\u3011\u4e0d\u5b58\u5728\uff01");
            }
        }
        if (operateType.equals((Object)OperateType.delete)) {
            int n = list2.indexOf(object);
            list2.remove(n);
        } else if (operateType.equals((Object)OperateType.update)) {
            ((Authority)object).setRead(authority.isRead());
            ((Authority)object).setWrite(authority.isWrite());
            ((Authority)object).setSave(authority.isSave());
            ((Authority)object).setSaveas(authority.isSaveas());
        } else {
            for (Authority authority3 : list2) {
                if (!authority3.getPath().equals(string3)) continue;
                throw new RuleException("\u3010" + string + "\u3011\u5bf9\u8d44\u6e90\u3010" + string3 + "\u3011\u7684\u6743\u9650\u914d\u7f6e\u4fe1\u606f\u5df2\u5b58\u5728\uff01");
            }
            Authority authority4 = new Authority();
            authority4.setPath(string3);
            authority4.setRead(authority.isRead());
            authority4.setWrite(authority.isWrite());
            authority4.setSave(authority.isSave());
            authority4.setSaveas(authority.isSaveas());
            list2.add(authority4);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuilder.append("<authorities>");
        for (AuthorityUnit authorityUnit : list) {
            stringBuilder.append("<unit principal=\"" + authorityUnit.getPrincipalName() + "\">");
            for (Authority authority5 : authorityUnit.getAuthorities()) {
                stringBuilder.append("<auth path=\"" + authority5.getPath() + "\" read=\"" + authority5.isRead() + "\" write=\"" + authority5.isWrite() + "\" save=\"" + authority5.isSave() + "\" saveas=\"" + authority5.isSaveas() + "\"/>");
            }
            stringBuilder.append("</unit>");
        }
        stringBuilder.append("</authorities>");
        long l = this.saveAuthoritiesFile(stringBuilder.toString(), principal);
        if (this.b == null) {
            this.b = (AuthorityService)this.a.getBean("urule.authorityService");
        }
        this.b.refreshAuthority(string2);
        this.b.getAuthorityCache().resetTag(l);
    }

    @Override
    public long saveAuthoritiesFile(String string, Principal principal) throws Exception {
        String string2 = principal.getCompanyId();
        String string3 = "___resource_authority_config__file__" + (string2 == null ? "" : string2);
        this.saveFile(string3, string, false, null, principal);
        return this.resetAuthorityTag(string2);
    }

    @Override
    public List<AuthorityUnit> loadAuthorityUnits(String string) throws Exception {
        ArrayList<AuthorityUnit> arrayList = new ArrayList<AuthorityUnit>();
        String string2 = "___resource_authority_config__file__" + (string == null ? "" : string);
        Node node = this.getRootNode();
        Node node2 = node.getNode(string2);
        Property property = node2.getProperty("_data");
        Binary binary = property.getBinary();
        InputStream inputStream = binary.getStream();
        String string3 = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
        inputStream.close();
        Document document = DocumentHelper.parseText((String)string3);
        Element element = document.getRootElement();
        for (Object e : element.elements()) {
            Element element2;
            if (!(e instanceof Element) || !(element2 = (Element)e).getName().equals("unit")) continue;
            AuthorityUnit authorityUnit = new AuthorityUnit();
            authorityUnit.setPrincipalName(element2.attributeValue("principal"));
            authorityUnit.setAuthorities(this.a(element2));
            arrayList.add(authorityUnit);
        }
        return arrayList;
    }

    private List<Authority> a(Element element) {
        ArrayList<Authority> arrayList = new ArrayList<Authority>();
        for (Object e : element.elements()) {
            String string;
            String string2;
            String string3;
            Element element2;
            if (!(e instanceof Element) || !(element2 = (Element)e).getName().equals("auth")) continue;
            Authority authority = new Authority();
            authority.setPath(element2.attributeValue("path"));
            String string4 = element2.attributeValue("read");
            if (StringUtils.isNotBlank((String)string4)) {
                authority.setRead(Boolean.valueOf(string4));
            }
            if (StringUtils.isNotBlank((String)(string3 = element2.attributeValue("write")))) {
                authority.setWrite(Boolean.valueOf(string3));
            }
            if (StringUtils.isNotBlank((String)(string2 = element2.attributeValue("save")))) {
                authority.setSave(Boolean.valueOf(string2));
            }
            if (StringUtils.isNotBlank((String)(string = element2.attributeValue("saveas")))) {
                authority.setSaveas(Boolean.valueOf(string));
            }
            arrayList.add(authority);
        }
        return arrayList;
    }

    @Override
    public long resetAuthorityTag(String string) throws Exception {
        String string2 = "___resource_authority_config__file__" + (string == null ? "" : string);
        string2 = Utils.decodeURL((String)string2);
        this.session.refresh(false);
        Node node = this.getRootNode();
        if (!node.hasNode(string2)) {
            throw new RuleException("File [" + string2 + "] not exist.");
        }
        Node node2 = node.getNode(string2);
        long l = new Date().getTime();
        node2.setProperty("___resource_authority_tag__", l);
        this.session.save();
        return l;
    }

    @Override
    public long check(String string, long l) throws Exception {
        String string2 = "___resource_authority_config__file__" + (string == null ? "" : string);
        string2 = Utils.decodeURL((String)string2);
        Node node = this.getRootNode();
        if (!node.hasNode(string2)) {
            return l;
        }
        Node node2 = node.getNode(string2);
        if (!node2.hasProperty("___resource_authority_tag__")) {
            return l;
        }
        long l2 = node2.getProperty("___resource_authority_tag__").getLong();
        if (l2 == l) {
            return 0L;
        }
        return l2;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        this.a = applicationContext;
    }
}

