/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository.cluster;

import com.bstek.urule.console.Principal;
import com.bstek.urule.console.repository.BaseRepositoryService;
import com.bstek.urule.console.repository.cluster.ClusterRepositoryService;
import com.bstek.urule.console.repository.cluster.ServerInfo;
import com.bstek.urule.exception.RuleException;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;

public class ClusterRepositoryServiceImpl
extends BaseRepositoryService
implements ClusterRepositoryService {
    private static final String a = "__cluster_server_data_";
    private static final String b = "/urule/reloadknowledge";

    @Override
    public void reloadServersKnowledgePackage(Principal principal, String string) {
        try {
            List<ServerInfo> list = this.loadServers(principal);
            for (ServerInfo serverInfo : list) {
                String string2 = serverInfo.getUrl() + b + "?packageId=" + URLEncoder.encode(string, "utf-8");
                URL uRL = new URL(string2);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setRequestProperty("Charset", "UTF-8");
                httpURLConnection.setRequestProperty("Accept-Charset", "utf-8");
                httpURLConnection.setRequestProperty("Content-Type", "text/json");
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setDoInput(true);
                httpURLConnection.connect();
                OutputStream outputStream = httpURLConnection.getOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
                dataOutputStream.flush();
                dataOutputStream.close();
                InputStream inputStream = httpURLConnection.getInputStream();
                inputStream.close();
                outputStream.close();
                httpURLConnection.disconnect();
            }
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    @Override
    public List<ServerInfo> loadServers(Principal principal) {
        ArrayList<ServerInfo> arrayList = new ArrayList<ServerInfo>();
        String string = this.a(principal);
        try {
            Node node = this.getRootNode();
            if (!node.hasNode(string)) {
                return arrayList;
            }
            Node node2 = node.getNode(string);
            PropertyIterator propertyIterator = node2.getProperties();
            while (propertyIterator.hasNext()) {
                Property property = propertyIterator.nextProperty();
                String string2 = property.getName();
                if (string2.startsWith("jcr:")) continue;
                String string3 = property.getString();
                arrayList.add(new ServerInfo(string2, string3));
            }
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        return arrayList;
    }

    @Override
    public void removeServer(ServerInfo serverInfo, Principal principal) {
        String string = this.a(principal);
        try {
            this.session.refresh(false);
            Node node = this.getRootNode();
            if (!node.hasNode(string)) {
                return;
            }
            Node node2 = node.getNode(string);
            if (node2.hasProperty(serverInfo.getName())) {
                Property property = node2.getProperty(serverInfo.getName());
                property.remove();
                this.session.save();
            }
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    @Override
    public void saveServer(ServerInfo serverInfo, Principal principal) {
        String string = this.a(principal);
        try {
            this.session.refresh(false);
            Node node = this.getRootNode();
            Node node2 = null;
            node2 = !node.hasNode(string) ? node.addNode(string) : node.getNode(string);
            if (node2.hasProperty(serverInfo.getName())) {
                Property property = node2.getProperty(serverInfo.getName());
                property.setValue(serverInfo.getUrl());
            } else {
                node2.setProperty(serverInfo.getName(), serverInfo.getUrl());
            }
            this.session.save();
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    private String a(Principal principal) {
        String string = principal.getCompanyId();
        return a + (string == null ? "" : string);
    }
}

