/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository.database;

import com.bstek.urule.console.repository.RepositoryBuilder;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.db.DbFileSystem;

public abstract class BaseDbFileSystem
extends DbFileSystem {
    public void init() throws FileSystemException {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        try {
            this.setSchema(this.databaseType());
            this.conHelper = this.createConnectionHelper(RepositoryBuilder.datasource);
            this.schemaObjectPrefix = this.conHelper.prepareDbIdentifier(this.schemaObjectPrefix);
            if (this.isSchemaCheckEnabled()) {
                this.createCheckSchemaOperation().run();
            }
            this.buildSQLStatements();
            this.verifyRootExists();
            this.initialized = true;
        }
        catch (Exception exception) {
            String string = "failed to initialize file system";
            throw new FileSystemException(string, (Throwable)exception);
        }
    }

    public abstract String databaseType();
}

