/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository.database;

import com.bstek.urule.console.repository.RepositoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.db.DbDataStore;

public class DatabaseDataStore
extends DbDataStore {
    public synchronized void init(String string) throws DataStoreException {
        try {
            this.initDatabaseType();
            this.conHelper = this.createConnectionHelper(RepositoryBuilder.datasource);
            if (this.isSchemaCheckEnabled()) {
                this.createCheckSchemaOperation().run();
            }
        }
        catch (Exception exception) {
            throw this.convert("Can not init data store, driver=" + this.driver + " url=" + this.url + " user=" + this.user + " schemaObjectPrefix=" + this.schemaObjectPrefix + " tableSQL=" + this.tableSQL + " createTableSQL=" + this.createTableSQL, exception);
        }
    }

    protected void initDatabaseType() throws DataStoreException {
        this.databaseType = RepositoryBuilder.databaseType;
        InputStream inputStream = DbDataStore.class.getResourceAsStream(this.databaseType + ".properties");
        if (inputStream == null) {
            String string = "Configuration error: The resource '" + this.databaseType + ".properties' could not be found; Please verify the databaseType property";
            throw new DataStoreException(string);
        }
        Properties properties = new Properties();
        try {
            try {
                properties.load(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            String string = "Configuration error: Could not read properties '" + this.databaseType + ".properties'";
            throw new DataStoreException(string, (Throwable)iOException);
        }
        if (this.driver == null) {
            this.driver = this.getProperty(properties, "driver", this.driver);
        }
        this.tableSQL = this.getProperty(properties, "table", this.tableSQL);
        this.createTableSQL = this.getProperty(properties, "createTable", this.createTableSQL);
        this.insertTempSQL = this.getProperty(properties, "insertTemp", this.insertTempSQL);
        this.updateDataSQL = this.getProperty(properties, "updateData", this.updateDataSQL);
        this.updateLastModifiedSQL = this.getProperty(properties, "updateLastModified", this.updateLastModifiedSQL);
        this.updateSQL = this.getProperty(properties, "update", this.updateSQL);
        this.deleteSQL = this.getProperty(properties, "delete", this.deleteSQL);
        this.deleteOlderSQL = this.getProperty(properties, "deleteOlder", this.deleteOlderSQL);
        this.selectMetaSQL = this.getProperty(properties, "selectMeta", this.selectMetaSQL);
        this.selectAllSQL = this.getProperty(properties, "selectAll", this.selectAllSQL);
        this.selectDataSQL = this.getProperty(properties, "selectData", this.selectDataSQL);
        this.storeStream = this.getProperty(properties, "storeStream", this.storeStream);
        if (!("-1".equals(this.storeStream) || "tempFile".equals(this.storeStream) || "max".equals(this.storeStream))) {
            String string = "Unsupported Stream store mechanism: " + this.storeStream + " supported are: " + "-1" + ", " + "tempFile" + ", " + "max";
            throw new DataStoreException(string);
        }
    }
}

