/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository.database;

import com.bstek.urule.console.repository.RepositoryBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.bundle.AbstractBundlePersistenceManager;
import org.apache.jackrabbit.core.persistence.pool.BundleDbPersistenceManager;
import org.apache.jackrabbit.core.persistence.pool.DbNameIndex;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.BundleBinding;
import org.apache.jackrabbit.core.persistence.util.ErrorHandling;
import org.apache.jackrabbit.core.persistence.util.FileSystemBLOBStore;
import org.apache.jackrabbit.core.persistence.util.NodeInfo;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.persistence.util.Serializer;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.util.StringIndex;
import org.apache.jackrabbit.core.util.db.CheckSchemaOperation;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.DatabaseAware;
import org.apache.jackrabbit.core.util.db.DbUtility;
import org.apache.jackrabbit.core.util.db.StreamWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbPersistenceManager
extends AbstractBundlePersistenceManager
implements DatabaseAware {
    private static Logger b = LoggerFactory.getLogger(BundleDbPersistenceManager.class);
    public static final int SM_BINARY_KEYS = 1;
    public static final int SM_LONGLONG_KEYS = 2;
    protected boolean initialized;
    protected String driver;
    protected String url;
    protected String user;
    protected String password;
    protected String databaseType;
    protected String dataSourceName;
    protected ConnectionHelper conHelper;
    protected String schemaObjectPrefix;
    protected boolean consistencyCheck;
    protected boolean consistencyFix;
    protected static final int INITIAL_BUFFER_SIZE = 1024;
    protected boolean externalBLOBs;
    protected boolean blockOnConnectionLoss;
    protected String bundleInsertSQL;
    protected String bundleUpdateSQL;
    protected String bundleSelectSQL;
    protected String bundleDeleteSQL;
    protected String bundleSelectAllIdsFromSQL;
    protected String bundleSelectAllIdsSQL;
    protected String bundleSelectAllBundlesFromSQL;
    protected String bundleSelectAllBundlesSQL;
    protected String nodeReferenceInsertSQL;
    protected String nodeReferenceUpdateSQL;
    protected String nodeReferenceSelectSQL;
    protected String nodeReferenceDeleteSQL;
    protected CloseableBLOBStore blobStore;
    private StringIndex c;
    private int d = 4096;
    protected ErrorHandling errorHandling = new ErrorHandling();
    protected BundleBinding binding;
    private String e = super.toString();
    private boolean f = true;

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public String getSchemaObjectPrefix() {
        return this.schemaObjectPrefix;
    }

    public void setSchemaObjectPrefix(String string) {
        this.schemaObjectPrefix = string.toUpperCase();
    }

    public String getSchema() {
        return this.databaseType;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setSchema(String string) {
        this.databaseType = string;
    }

    public void setDatabaseType(String string) {
        this.databaseType = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public boolean isExternalBLOBs() {
        return this.externalBLOBs;
    }

    public void setExternalBLOBs(boolean bl) {
        this.externalBLOBs = bl;
    }

    public String getConsistencyCheck() {
        return Boolean.toString(this.consistencyCheck);
    }

    public void setConsistencyCheck(String string) {
        this.consistencyCheck = Boolean.valueOf(string);
    }

    public String getConsistencyFix() {
        return Boolean.toString(this.consistencyFix);
    }

    public void setConsistencyFix(String string) {
        this.consistencyFix = Boolean.valueOf(string);
    }

    public String getMinBlobSize() {
        return String.valueOf(this.d);
    }

    public void setMinBlobSize(String string) {
        this.d = Integer.decode(string);
    }

    public void setErrorHandling(String string) {
        this.errorHandling = new ErrorHandling(string);
    }

    public String getErrorHandling() {
        return this.errorHandling.toString();
    }

    public void setBlockOnConnectionLoss(String string) {
        this.blockOnConnectionLoss = Boolean.valueOf(string);
    }

    public String getBlockOnConnectionLoss() {
        return Boolean.toString(this.blockOnConnectionLoss);
    }

    public boolean useDbBlobStore() {
        return !this.externalBLOBs;
    }

    public boolean useLocalFsBlobStore() {
        return this.externalBLOBs;
    }

    public final boolean isSchemaCheckEnabled() {
        return this.f;
    }

    public final void setSchemaCheckEnabled(boolean bl) {
        this.f = bl;
    }

    public synchronized void store(ChangeLog changeLog) throws ItemStateException {
        int n = 0;
        ItemStateException itemStateException = null;
        boolean bl = false;
        while (!bl && (this.blockOnConnectionLoss || n <= 1)) {
            block8: {
                try {
                    this.conHelper.startBatch();
                    super.store(changeLog);
                    this.conHelper.endBatch(true);
                    return;
                }
                catch (SQLException sQLException) {
                    itemStateException = new ItemStateException(sQLException.getMessage(), (Throwable)sQLException);
                }
                catch (ItemStateException itemStateException2) {
                    itemStateException = itemStateException2;
                    try {
                        this.conHelper.endBatch(false);
                    }
                    catch (SQLException sQLException) {
                        DbUtility.logException((String)"rollback failed", (SQLException)sQLException);
                    }
                    if (a || !this.a(itemStateException2.getCause())) break block8;
                    throw new AssertionError();
                }
            }
            b.error("Failed to persist ChangeLog (stacktrace on DEBUG log level), blockOnConnectionLoss = " + this.blockOnConnectionLoss + ": " + (Object)((Object)itemStateException));
            b.debug("Failed to persist ChangeLog", (Throwable)itemStateException);
            if (!this.blockOnConnectionLoss && ++n > 1) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                bl = true;
                b.error("Interrupted: canceling retry of ChangeLog storage");
            }
        }
        throw itemStateException;
    }

    private boolean a(Throwable throwable) {
        if (throwable instanceof SQLException) {
            String string = ((SQLException)throwable).getSQLState();
            return string != null && string.startsWith("23");
        }
        return false;
    }

    public void init(PMContext pMContext) throws Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        super.init(pMContext);
        this.conHelper = this.createConnectionHelper(this.a());
        this.e = pMContext.getHomeDir().getName();
        this.schemaObjectPrefix = this.conHelper.prepareDbIdentifier(this.schemaObjectPrefix);
        if (this.isSchemaCheckEnabled()) {
            this.createCheckSchemaOperation().run();
        }
        this.blobStore = this.createBlobStore();
        this.buildSQLStatements();
        this.binding = new BundleBinding(this.errorHandling, (BLOBStore)this.blobStore, this.getNsIndex(), this.getNameIndex(), pMContext.getDataStore());
        this.binding.setMinBlobSize((long)this.d);
        this.initialized = true;
        if (this.consistencyCheck) {
            this.checkConsistency(null, true, this.consistencyFix);
        }
    }

    private DataSource a() throws Exception {
        this.setDatabaseType(RepositoryBuilder.databaseType);
        return RepositoryBuilder.datasource;
    }

    protected ConnectionHelper createConnectionHelper(DataSource dataSource) throws Exception {
        return new ConnectionHelper(dataSource, this.blockOnConnectionLoss);
    }

    protected CheckSchemaOperation createCheckSchemaOperation() {
        InputStream inputStream = AbstractBundlePersistenceManager.class.getResourceAsStream(this.databaseType + ".ddl");
        return new CheckSchemaOperation(this.conHelper, inputStream, this.schemaObjectPrefix + "BUNDLE").addVariableReplacement("${schemaObjectPrefix}", this.schemaObjectPrefix);
    }

    protected BLOBStore getBlobStore() {
        return this.blobStore;
    }

    protected CloseableBLOBStore createBlobStore() throws Exception {
        if (this.useLocalFsBlobStore()) {
            return this.createLocalFSBlobStore(this.context);
        }
        return this.createDBBlobStore(this.context);
    }

    public StringIndex getNameIndex() {
        try {
            if (this.c == null) {
                FileSystemResource fileSystemResource = new FileSystemResource(this.context.getFileSystem(), "/names.properties");
                this.c = fileSystemResource.exists() ? super.getNameIndex() : this.createDbNameIndex();
            }
            return this.c;
        }
        catch (Exception exception) {
            IllegalStateException illegalStateException = new IllegalStateException("Unable to create nsIndex");
            illegalStateException.initCause(exception);
            throw illegalStateException;
        }
    }

    protected DbNameIndex createDbNameIndex() throws SQLException {
        return new DbNameIndex(this.conHelper, this.schemaObjectPrefix);
    }

    public int getStorageModel() {
        return 1;
    }

    protected CloseableBLOBStore createLocalFSBlobStore(PMContext pMContext) throws Exception {
        LocalFileSystem localFileSystem = new LocalFileSystem();
        localFileSystem.setRoot(new File(pMContext.getHomeDir(), "blobs"));
        localFileSystem.init();
        return new FSBlobStore((FileSystem)localFileSystem);
    }

    protected CloseableBLOBStore createDBBlobStore(PMContext pMContext) throws Exception {
        return new DbBlobStore();
    }

    public synchronized void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            if (this.c instanceof DbNameIndex) {
                ((DbNameIndex)this.c).close();
            }
            this.blobStore.close();
            this.blobStore = null;
            super.close();
        }
        finally {
            this.initialized = false;
        }
    }

    protected Object[] getKey(NodeId nodeId) {
        if (this.getStorageModel() == 1) {
            return new Object[]{nodeId.getRawBytes()};
        }
        return new Object[]{nodeId.getMostSignificantBits(), nodeId.getLeastSignificantBits()};
    }

    protected Object[] createParams(NodeId nodeId, Object object, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.getStorageModel() == 1) {
            arrayList.add(nodeId.getRawBytes());
        } else {
            arrayList.add(nodeId.getMostSignificantBits());
            arrayList.add(nodeId.getLeastSignificantBits());
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (bl) {
            arrayList2.add(object);
            arrayList2.addAll(arrayList);
        } else {
            arrayList2.addAll(arrayList);
            arrayList2.add(object);
        }
        return arrayList2.toArray();
    }

    public synchronized List<NodeId> getAllNodeIds(NodeId nodeId, int n) throws ItemStateException, RepositoryException {
        NodeId nodeId2;
        ResultSet resultSet = null;
        try {
            String string = this.bundleSelectAllIdsSQL;
            NodeId nodeId3 = null;
            Object[] objectArray = new Object[]{};
            if (nodeId != null) {
                string = this.bundleSelectAllIdsFromSQL;
                nodeId3 = nodeId;
                objectArray = this.getKey(nodeId);
            }
            if (this.getStorageModel() == 2 && n > 0) {
                n += 10;
            }
            resultSet = this.conHelper.exec(string, objectArray, false, n);
            NodeId nodeId4 = new ArrayList();
            while ((n == 0 || nodeId4.size() < n) && resultSet.next()) {
                if (this.getStorageModel() == 1) {
                    nodeId2 = new NodeId(resultSet.getBytes(1));
                } else {
                    long l = resultSet.getLong(1);
                    long l2 = resultSet.getLong(2);
                    nodeId2 = new NodeId(l, l2);
                    if (nodeId3 != null && nodeId2.compareTo(nodeId3) <= 0) continue;
                }
                nodeId4.add(nodeId2);
            }
            nodeId2 = nodeId4;
        }
        catch (SQLException sQLException) {
            try {
                String string = "getAllNodeIds failed.";
                b.error(string, (Throwable)sQLException);
                throw new ItemStateException(string, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                DbUtility.close(resultSet);
                throw throwable;
            }
        }
        DbUtility.close((ResultSet)resultSet);
        return nodeId2;
    }

    public synchronized Map<NodeId, NodeInfo> getAllNodeInfos(NodeId nodeId, int n) throws ItemStateException {
        NodeId nodeId2;
        ResultSet resultSet = null;
        try {
            String string = this.bundleSelectAllBundlesSQL;
            NodeId nodeId3 = null;
            Object[] objectArray = new Object[]{};
            if (nodeId != null) {
                string = this.bundleSelectAllBundlesFromSQL;
                nodeId3 = nodeId;
                objectArray = this.getKey(nodeId);
            }
            if (this.getStorageModel() == 2 && n > 0) {
                n += 10;
            }
            resultSet = this.conHelper.exec(string, objectArray, false, n);
            NodeId nodeId4 = new LinkedHashMap(n);
            while ((n == 0 || nodeId4.size() < n) && resultSet.next()) {
                if (this.getStorageModel() == 1) {
                    nodeId2 = new NodeId(resultSet.getBytes(1));
                } else {
                    long l = resultSet.getLong(1);
                    long l2 = resultSet.getLong(2);
                    nodeId2 = new NodeId(l, l2);
                }
                if (this.getStorageModel() == 2 && nodeId3 != null && nodeId2.compareTo(nodeId3) <= 0) continue;
                NodePropBundle nodePropBundle = this.a(nodeId2, resultSet, this.getStorageModel() == 2 ? 3 : 2);
                NodeInfo nodeInfo = new NodeInfo(nodePropBundle);
                nodeId4.put(nodeInfo.getId(), nodeInfo);
            }
            nodeId2 = nodeId4;
        }
        catch (SQLException sQLException) {
            try {
                String string = "getAllNodeIds failed.";
                b.error(string, (Throwable)sQLException);
                throw new ItemStateException(string, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                DbUtility.close(resultSet);
                throw throwable;
            }
        }
        DbUtility.close((ResultSet)resultSet);
        return nodeId2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NodePropBundle loadBundle(NodeId nodeId) throws ItemStateException {
        try (ResultSet resultSet = this.conHelper.exec(this.bundleSelectSQL, this.getKey(nodeId), false, 0);){
            if (resultSet != null && resultSet.next()) {
                NodePropBundle nodePropBundle2 = this.a(nodeId, resultSet, 1);
                return nodePropBundle2;
            }
            NodePropBundle nodePropBundle = null;
            return nodePropBundle;
        }
        catch (SQLException sQLException) {
            String string = "failed to read bundle (stacktrace on DEBUG log level): " + nodeId + ": " + sQLException;
            b.error(string);
            b.debug("failed to read bundle: " + nodeId, (Throwable)sQLException);
            throw new ItemStateException(string, (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodePropBundle a(NodeId nodeId, ResultSet resultSet, int n) throws SQLException {
        NodePropBundle nodePropBundle;
        InputStream inputStream = resultSet.getMetaData().getColumnType(n) == 2004 ? resultSet.getBlob(n).getBinaryStream() : resultSet.getBinaryStream(n);
        try {
            nodePropBundle = this.binding.readBundle(inputStream, nodeId);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                SQLException sQLException = new SQLException("Failed to parse bundle " + nodeId);
                sQLException.initCause(iOException);
                throw sQLException;
            }
        }
        inputStream.close();
        return nodePropBundle;
    }

    protected synchronized void storeBundle(NodePropBundle nodePropBundle) throws ItemStateException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            this.binding.writeBundle((OutputStream)byteArrayOutputStream, nodePropBundle);
            String string = nodePropBundle.isNew() ? this.bundleInsertSQL : this.bundleUpdateSQL;
            Object[] objectArray = this.createParams(nodePropBundle.getId(), byteArrayOutputStream.toByteArray(), true);
            this.conHelper.update(string, objectArray);
        }
        catch (Exception exception) {
            String string = this.a(exception) ? "FATAL error while writing the bundle: " + nodePropBundle.getId() : "failed to write bundle: " + nodePropBundle.getId();
            b.error(string, (Throwable)exception);
            throw new ItemStateException(string, (Throwable)exception);
        }
    }

    protected synchronized void destroyBundle(NodePropBundle nodePropBundle) throws ItemStateException {
        try {
            this.conHelper.update(this.bundleDeleteSQL, this.getKey(nodePropBundle.getId()));
        }
        catch (Exception exception) {
            if (exception instanceof NoSuchItemStateException) {
                throw (NoSuchItemStateException)exception;
            }
            String string = "failed to delete bundle: " + nodePropBundle.getId();
            b.error(string, (Throwable)exception);
            throw new ItemStateException(string, (Throwable)exception);
        }
    }

    public synchronized NodeReferences loadReferencesTo(NodeId nodeId) throws NoSuchItemStateException, ItemStateException {
        NodeReferences nodeReferences;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        ResultSet resultSet = null;
        InputStream inputStream = null;
        try {
            resultSet = this.conHelper.exec(this.nodeReferenceSelectSQL, this.getKey(nodeId), false, 0);
            if (!resultSet.next()) {
                throw new NoSuchItemStateException(nodeId.toString());
            }
            inputStream = resultSet.getBinaryStream(1);
            NodeReferences nodeReferences2 = new NodeReferences(nodeId);
            Serializer.deserialize((NodeReferences)nodeReferences2, (InputStream)inputStream);
            nodeReferences = nodeReferences2;
        }
        catch (Exception exception) {
            try {
                if (exception instanceof NoSuchItemStateException) {
                    throw (NoSuchItemStateException)exception;
                }
                String string = "failed to read references: " + nodeId;
                b.error(string, (Throwable)exception);
                throw new ItemStateException(string, (Throwable)exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                DbUtility.close(resultSet);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        DbUtility.close((ResultSet)resultSet);
        return nodeReferences;
    }

    public synchronized void store(NodeReferences nodeReferences) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        boolean bl = this.existsReferencesTo(nodeReferences.getTargetId());
        String string = bl ? this.nodeReferenceUpdateSQL : this.nodeReferenceInsertSQL;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            Serializer.serialize((NodeReferences)nodeReferences, (OutputStream)byteArrayOutputStream);
            Object[] objectArray = this.createParams(nodeReferences.getTargetId(), byteArrayOutputStream.toByteArray(), true);
            this.conHelper.exec(string, objectArray);
        }
        catch (Exception exception) {
            String string2 = "failed to write " + nodeReferences;
            b.error(string2, (Throwable)exception);
            throw new ItemStateException(string2, (Throwable)exception);
        }
    }

    public synchronized void destroy(NodeReferences nodeReferences) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            this.conHelper.exec(this.nodeReferenceDeleteSQL, this.getKey(nodeReferences.getTargetId()));
        }
        catch (Exception exception) {
            if (exception instanceof NoSuchItemStateException) {
                throw (NoSuchItemStateException)exception;
            }
            String string = "failed to delete " + nodeReferences;
            b.error(string, (Throwable)exception);
            throw new ItemStateException(string, (Throwable)exception);
        }
    }

    public synchronized boolean existsReferencesTo(NodeId nodeId) throws ItemStateException {
        boolean bl;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        ResultSet resultSet = null;
        try {
            resultSet = this.conHelper.exec(this.nodeReferenceSelectSQL, this.getKey(nodeId), false, 0);
            bl = resultSet.next();
        }
        catch (Exception exception) {
            try {
                String string = "failed to check existence of node references: " + nodeId;
                b.error(string, (Throwable)exception);
                throw new ItemStateException(string, (Throwable)exception);
            }
            catch (Throwable throwable) {
                DbUtility.close(resultSet);
                throw throwable;
            }
        }
        DbUtility.close((ResultSet)resultSet);
        return bl;
    }

    public String toString() {
        return this.e;
    }

    protected void buildSQLStatements() {
        if (this.getStorageModel() == 1) {
            this.bundleInsertSQL = "insert into " + this.schemaObjectPrefix + "BUNDLE (BUNDLE_DATA, NODE_ID) values (?, ?)";
            this.bundleUpdateSQL = "update " + this.schemaObjectPrefix + "BUNDLE set BUNDLE_DATA = ? where NODE_ID = ?";
            this.bundleSelectSQL = "select BUNDLE_DATA from " + this.schemaObjectPrefix + "BUNDLE where NODE_ID = ?";
            this.bundleDeleteSQL = "delete from " + this.schemaObjectPrefix + "BUNDLE where NODE_ID = ?";
            this.nodeReferenceInsertSQL = "insert into " + this.schemaObjectPrefix + "REFS (REFS_DATA, NODE_ID) values (?, ?)";
            this.nodeReferenceUpdateSQL = "update " + this.schemaObjectPrefix + "REFS set REFS_DATA = ? where NODE_ID = ?";
            this.nodeReferenceSelectSQL = "select REFS_DATA from " + this.schemaObjectPrefix + "REFS where NODE_ID = ?";
            this.nodeReferenceDeleteSQL = "delete from " + this.schemaObjectPrefix + "REFS where NODE_ID = ?";
            this.bundleSelectAllIdsSQL = "select NODE_ID from " + this.schemaObjectPrefix + "BUNDLE ORDER BY NODE_ID";
            this.bundleSelectAllIdsFromSQL = "select NODE_ID from " + this.schemaObjectPrefix + "BUNDLE WHERE NODE_ID > ? ORDER BY NODE_ID";
            this.bundleSelectAllBundlesSQL = "select NODE_ID, BUNDLE_DATA from " + this.schemaObjectPrefix + "BUNDLE ORDER BY NODE_ID";
            this.bundleSelectAllBundlesFromSQL = "select NODE_ID, BUNDLE_DATA from " + this.schemaObjectPrefix + "BUNDLE WHERE NODE_ID > ? ORDER BY NODE_ID";
        } else {
            this.bundleInsertSQL = "insert into " + this.schemaObjectPrefix + "BUNDLE (BUNDLE_DATA, NODE_ID_HI, NODE_ID_LO) values (?, ?, ?)";
            this.bundleUpdateSQL = "update " + this.schemaObjectPrefix + "BUNDLE set BUNDLE_DATA = ? where NODE_ID_HI = ? and NODE_ID_LO = ?";
            this.bundleSelectSQL = "select BUNDLE_DATA from " + this.schemaObjectPrefix + "BUNDLE where NODE_ID_HI = ? and NODE_ID_LO = ?";
            this.bundleDeleteSQL = "delete from " + this.schemaObjectPrefix + "BUNDLE where NODE_ID_HI = ? and NODE_ID_LO = ?";
            this.nodeReferenceInsertSQL = "insert into " + this.schemaObjectPrefix + "REFS (REFS_DATA, NODE_ID_HI, NODE_ID_LO) values (?, ?, ?)";
            this.nodeReferenceUpdateSQL = "update " + this.schemaObjectPrefix + "REFS set REFS_DATA = ? where NODE_ID_HI = ? and NODE_ID_LO = ?";
            this.nodeReferenceSelectSQL = "select REFS_DATA from " + this.schemaObjectPrefix + "REFS where NODE_ID_HI = ? and NODE_ID_LO = ?";
            this.nodeReferenceDeleteSQL = "delete from " + this.schemaObjectPrefix + "REFS where NODE_ID_HI = ? and NODE_ID_LO = ?";
            this.bundleSelectAllIdsSQL = "select NODE_ID_HI, NODE_ID_LO from " + this.schemaObjectPrefix + "BUNDLE ORDER BY NODE_ID_HI, NODE_ID_LO";
            this.bundleSelectAllIdsFromSQL = "select NODE_ID_HI, NODE_ID_LO from " + this.schemaObjectPrefix + "BUNDLE WHERE (NODE_ID_HI >= ?) AND (? IS NOT NULL) ORDER BY NODE_ID_HI, NODE_ID_LO";
            this.bundleSelectAllBundlesSQL = "select NODE_ID_HI, NODE_ID_LO, BUNDLE_DATA from " + this.schemaObjectPrefix + "BUNDLE ORDER BY NODE_ID_HI, NODE_ID_LO";
            this.bundleSelectAllBundlesFromSQL = "select NODE_ID_HI, NODE_ID_LO, BUNDLE_DATA from " + this.schemaObjectPrefix + "BUNDLE WHERE (NODE_ID_HI >= ?) AND (? IS NOT NULL) ORDER BY NODE_ID_HI, NODE_ID_LO";
        }
    }

    protected class DbBlobStore
    implements CloseableBLOBStore {
        protected String blobInsertSQL;
        protected String blobUpdateSQL;
        protected String blobSelectSQL;
        protected String blobSelectExistSQL;
        protected String blobDeleteSQL;

        public DbBlobStore() throws SQLException {
            this.blobInsertSQL = "insert into " + DbPersistenceManager.this.schemaObjectPrefix + "BINVAL (BINVAL_DATA, BINVAL_ID) values (?, ?)";
            this.blobUpdateSQL = "update " + DbPersistenceManager.this.schemaObjectPrefix + "BINVAL set BINVAL_DATA = ? where BINVAL_ID = ?";
            this.blobSelectSQL = "select BINVAL_DATA from " + DbPersistenceManager.this.schemaObjectPrefix + "BINVAL where BINVAL_ID = ?";
            this.blobSelectExistSQL = "select 1 from " + DbPersistenceManager.this.schemaObjectPrefix + "BINVAL where BINVAL_ID = ?";
            this.blobDeleteSQL = "delete from " + DbPersistenceManager.this.schemaObjectPrefix + "BINVAL where BINVAL_ID = ?";
        }

        public String createId(PropertyId propertyId, int n) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(propertyId.getParentId().toString());
            stringBuilder.append('.');
            stringBuilder.append(DbPersistenceManager.this.getNsIndex().stringToIndex(propertyId.getName().getNamespaceURI()));
            stringBuilder.append('.');
            stringBuilder.append(DbPersistenceManager.this.getNameIndex().stringToIndex(propertyId.getName().getLocalName()));
            stringBuilder.append('.');
            stringBuilder.append(n);
            return stringBuilder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream get(String string) throws Exception {
            FilterInputStream filterInputStream;
            block7: {
                InputStream inputStream;
                boolean bl;
                ResultSet resultSet;
                block5: {
                    ByteArrayInputStream byteArrayInputStream;
                    block6: {
                        resultSet = null;
                        bl = true;
                        try {
                            resultSet = DbPersistenceManager.this.conHelper.exec(this.blobSelectSQL, new Object[]{string}, false, 0);
                            if (!resultSet.next()) {
                                throw new Exception("no such BLOB: " + string);
                            }
                            inputStream = resultSet.getBinaryStream(1);
                            if (inputStream != null) break block5;
                            byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                            if (!bl) break block6;
                        }
                        catch (Throwable throwable) {
                            if (bl) {
                                DbUtility.close(resultSet);
                            }
                            throw throwable;
                        }
                        DbUtility.close((ResultSet)resultSet);
                    }
                    return byteArrayInputStream;
                }
                bl = false;
                final ResultSet resultSet2 = resultSet;
                filterInputStream = new FilterInputStream(inputStream){

                    @Override
                    public void close() throws IOException {
                        try {
                            this.in.close();
                        }
                        finally {
                            DbUtility.close((ResultSet)resultSet2);
                        }
                    }
                };
                if (!bl) break block7;
                DbUtility.close((ResultSet)resultSet);
            }
            return filterInputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void put(String string, InputStream inputStream, long l) throws Exception {
            boolean bl;
            ResultSet resultSet = null;
            try {
                resultSet = DbPersistenceManager.this.conHelper.exec(this.blobSelectExistSQL, new Object[]{string}, false, 0);
                bl = resultSet.next();
            }
            catch (Throwable throwable) {
                DbUtility.close(resultSet);
                throw throwable;
            }
            DbUtility.close((ResultSet)resultSet);
            String string2 = bl ? this.blobUpdateSQL : this.blobInsertSQL;
            Object[] objectArray = new Object[]{new StreamWrapper(inputStream, l), string};
            DbPersistenceManager.this.conHelper.exec(string2, objectArray);
        }

        public synchronized boolean remove(String string) throws Exception {
            return DbPersistenceManager.this.conHelper.update(this.blobDeleteSQL, new Object[]{string}) == 1;
        }

        @Override
        public void close() {
        }
    }

    protected class FSBlobStore
    extends FileSystemBLOBStore
    implements CloseableBLOBStore {
        private FileSystem b;

        public FSBlobStore(FileSystem fileSystem) {
            super(fileSystem);
            this.b = fileSystem;
        }

        public String createId(PropertyId propertyId, int n) {
            return DbPersistenceManager.this.buildBlobFilePath(null, propertyId, n).toString();
        }

        @Override
        public void close() {
            try {
                this.b.close();
                this.b = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static interface CloseableBLOBStore
    extends BLOBStore {
        public void close();
    }
}

