/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository.database.journal;

import com.bstek.urule.console.repository.RepositoryBuilder;
import com.bstek.urule.console.repository.database.journal.DatabaseRecordIterator;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.journal.AbstractJournal;
import org.apache.jackrabbit.core.journal.AppendRecord;
import org.apache.jackrabbit.core.journal.FileRevision;
import org.apache.jackrabbit.core.journal.InstanceRevision;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.core.util.db.CheckSchemaOperation;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.DatabaseAware;
import org.apache.jackrabbit.core.util.db.DbUtility;
import org.apache.jackrabbit.core.util.db.StreamWrapper;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseJournal
extends AbstractJournal
implements DatabaseAware {
    private static final String e = "JOURNAL";
    private static final String f = "LOCAL_REVISIONS";
    static Logger a = LoggerFactory.getLogger(DatabaseJournal.class);
    private String g;
    private String h;
    private String i;
    private String j;
    private String k;
    private String l;
    ConnectionHelper b;
    private int m;
    private long n;
    private boolean o = false;
    int c = 86400;
    Calendar d = Calendar.getInstance();
    private Thread p;
    private boolean q;
    private DatabaseRevision r;
    protected String selectRevisionsStmtSQL;
    protected String updateGlobalStmtSQL;
    protected String selectGlobalStmtSQL;
    protected String insertRevisionStmtSQL;
    protected String selectMinLocalRevisionStmtSQL;
    protected String cleanRevisionStmtSQL;
    protected String getLocalRevisionStmtSQL;
    protected String insertLocalRevisionStmtSQL;
    protected String updateLocalRevisionStmtSQL;
    protected String schemaObjectPrefix;

    public DatabaseJournal() {
        if (this.d.get(11) >= 3) {
            this.d.add(5, 1);
        }
        this.d.set(11, 3);
        this.d.set(12, 0);
        this.d.set(13, 0);
        this.d.set(14, 0);
        this.q = true;
        this.i = "default";
        this.schemaObjectPrefix = "";
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
    }

    public void init(String string, NamespaceResolver namespaceResolver) throws JournalException {
        super.init(string, namespaceResolver);
        this.init();
        try {
            this.b = this.createConnectionHelper(this.a());
            this.schemaObjectPrefix = this.b.prepareDbIdentifier(this.schemaObjectPrefix);
            if (this.isSchemaCheckEnabled()) {
                this.createCheckSchemaOperation().run();
            }
            if (this.isSchemaCheckEnabled()) {
                this.c();
            }
            this.buildSQLStatements();
            this.initInstanceRevisionAndJanitor();
        }
        catch (Exception exception) {
            String string2 = "Unable to create connection.";
            throw new JournalException(string2, (Throwable)exception);
        }
        a.info("DatabaseJournal initialized.");
    }

    private DataSource a() throws Exception {
        return RepositoryBuilder.datasource;
    }

    protected ConnectionHelper createConnectionHelper(DataSource dataSource) throws Exception {
        return new ConnectionHelper(dataSource, false);
    }

    protected CheckSchemaOperation createCheckSchemaOperation() {
        InputStream inputStream = org.apache.jackrabbit.core.journal.DatabaseJournal.class.getResourceAsStream(this.i + ".ddl");
        return new CheckSchemaOperation(this.b, inputStream, this.schemaObjectPrefix + e).addVariableReplacement("${schemaObjectPrefix}", this.schemaObjectPrefix);
    }

    protected void init() throws JournalException {
        this.i = RepositoryBuilder.databaseType;
    }

    protected void initInstanceRevisionAndJanitor() throws Exception {
        this.r = new DatabaseRevision();
        long l = 0L;
        if (this.getRevision() != null) {
            FileRevision fileRevision = new FileRevision(new File(this.getRevision()), true);
            l = fileRevision.get();
            fileRevision.close();
        }
        long l2 = this.r.init(l);
        a.info("Initialized local revision to " + l2);
        if (this.o) {
            this.p = new Thread((Runnable)new RevisionTableJanitor(), "Jackrabbit-ClusterRevisionJanitor");
            this.p.setDaemon(true);
            this.p.start();
            a.info("Cluster revision janitor thread started; first run scheduled at " + this.d.getTime());
        } else {
            a.info("Cluster revision janitor thread not started");
        }
    }

    public InstanceRevision getInstanceRevision() throws JournalException {
        return this.r;
    }

    public RecordIterator getRecords(long l) throws JournalException {
        try {
            return new DatabaseRecordIterator(this.b.exec(this.selectRevisionsStmtSQL, new Object[]{new Long(l)}, false, 0), this.getResolver(), this.getNamePathResolver());
        }
        catch (SQLException sQLException) {
            throw new JournalException("Unable to return record iterator.", (Throwable)sQLException);
        }
    }

    public RecordIterator getRecords() throws JournalException {
        try {
            return new DatabaseRecordIterator(this.b.exec(this.selectRevisionsStmtSQL, new Object[]{new Long(Long.MIN_VALUE)}, false, 0), this.getResolver(), this.getNamePathResolver());
        }
        catch (SQLException sQLException) {
            throw new JournalException("Unable to return record iterator.", (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSync(long l, boolean bl) throws JournalException {
        if (!bl) {
            this.doSync(l);
        } else {
            try {
                this.b();
                try {
                    this.doSync(l);
                }
                finally {
                    this.a(true);
                }
            }
            catch (SQLException sQLException) {
                throw new JournalException("Couldn't sync the cluster node", (Throwable)sQLException);
            }
        }
    }

    protected void doLock() throws JournalException {
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            this.b();
        }
        catch (SQLException sQLException) {
            throw new JournalException("Unable to set autocommit to false.", (Throwable)sQLException);
        }
        try {
            this.b.exec(this.updateGlobalStmtSQL, new Object[0]);
            resultSet = this.b.exec(this.selectGlobalStmtSQL, null, false, 0);
            if (!resultSet.next()) {
                throw new JournalException("No revision available.");
            }
            this.n = resultSet.getLong(1);
            bl = true;
        }
        catch (SQLException sQLException) {
            try {
                throw new JournalException("Unable to lock global revision table.", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                DbUtility.close(resultSet);
                if (!bl) {
                    this.doUnlock(false);
                }
                throw throwable;
            }
        }
        DbUtility.close((ResultSet)resultSet);
        if (!bl) {
            this.doUnlock(false);
        }
    }

    protected void doUnlock(boolean bl) {
        this.a(bl);
    }

    private void b() throws SQLException {
        if (this.m++ == 0) {
            this.b.startBatch();
        }
    }

    private void a(boolean bl) {
        if (--this.m == 0) {
            try {
                this.b.endBatch(bl);
            }
            catch (SQLException sQLException) {
                a.error("failed to end batch", (Throwable)sQLException);
            }
        }
    }

    protected void appending(AppendRecord appendRecord) {
        appendRecord.setRevision(this.n);
    }

    protected void append(AppendRecord appendRecord, InputStream inputStream, int n) throws JournalException {
        try {
            this.b.exec(this.insertRevisionStmtSQL, new Object[]{appendRecord.getRevision(), this.getId(), appendRecord.getProducerId(), new StreamWrapper(inputStream, (long)n)});
        }
        catch (SQLException sQLException) {
            String string = "Unable to append revision " + this.n + ".";
            throw new JournalException(string, (Throwable)sQLException);
        }
    }

    public void close() {
        if (this.p != null) {
            this.p.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void c() throws Exception {
        ByteArrayInputStream byteArrayInputStream = null;
        InputStream inputStream = org.apache.jackrabbit.core.journal.DatabaseJournal.class.getResourceAsStream(this.i + ".ddl");
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            while (string != null) {
                if (!string.startsWith("#") && string.length() > 0 && string.indexOf(f) != -1) {
                    byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                    break;
                }
                string = bufferedReader.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            IOUtils.closeQuietly((InputStream)inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
        IOUtils.closeQuietly((InputStream)inputStream);
        new CheckSchemaOperation(this.b, (InputStream)byteArrayInputStream, this.schemaObjectPrefix + f).addVariableReplacement("${schemaObjectPrefix}", this.schemaObjectPrefix).run();
    }

    protected void buildSQLStatements() {
        this.selectRevisionsStmtSQL = "select REVISION_ID, JOURNAL_ID, PRODUCER_ID, REVISION_DATA from " + this.schemaObjectPrefix + "JOURNAL where REVISION_ID > ? order by REVISION_ID";
        this.updateGlobalStmtSQL = "update " + this.schemaObjectPrefix + "GLOBAL_REVISION set REVISION_ID = REVISION_ID + 1";
        this.selectGlobalStmtSQL = "select REVISION_ID from " + this.schemaObjectPrefix + "GLOBAL_REVISION";
        this.insertRevisionStmtSQL = "insert into " + this.schemaObjectPrefix + "JOURNAL (REVISION_ID, JOURNAL_ID, PRODUCER_ID, REVISION_DATA) values (?,?,?,?)";
        this.selectMinLocalRevisionStmtSQL = "select MIN(REVISION_ID) from " + this.schemaObjectPrefix + f;
        this.cleanRevisionStmtSQL = "delete from " + this.schemaObjectPrefix + "JOURNAL where REVISION_ID < ?";
        this.getLocalRevisionStmtSQL = "select REVISION_ID from " + this.schemaObjectPrefix + "LOCAL_REVISIONS where JOURNAL_ID = ?";
        this.insertLocalRevisionStmtSQL = "insert into " + this.schemaObjectPrefix + "LOCAL_REVISIONS (REVISION_ID, JOURNAL_ID) values (?,?)";
        this.updateLocalRevisionStmtSQL = "update " + this.schemaObjectPrefix + "LOCAL_REVISIONS set REVISION_ID = ? where JOURNAL_ID = ?";
    }

    public String getDriver() {
        return this.g;
    }

    public String getUrl() {
        return this.h;
    }

    public String getDatabaseType() {
        return this.i;
    }

    public String getSchema() {
        return this.i;
    }

    public String getSchemaObjectPrefix() {
        return this.schemaObjectPrefix;
    }

    public String getUser() {
        return this.j;
    }

    public String getPassword() {
        return this.k;
    }

    public boolean getJanitorEnabled() {
        return this.o;
    }

    public int getJanitorSleep() {
        return this.c;
    }

    public int getJanitorFirstRunHourOfDay() {
        return this.d.get(11);
    }

    public void setDriver(String string) {
        this.g = string;
    }

    public void setUrl(String string) {
        this.h = string;
    }

    public void setDatabaseType(String string) {
        this.i = string;
    }

    public void setSchema(String string) {
        this.i = string;
    }

    public void setSchemaObjectPrefix(String string) {
        this.schemaObjectPrefix = string.toUpperCase();
    }

    public void setUser(String string) {
        this.j = string;
    }

    public void setPassword(String string) {
        this.k = string;
    }

    public void setJanitorEnabled(boolean bl) {
        this.o = bl;
    }

    public void setJanitorSleep(int n) {
        this.c = n;
    }

    public void setJanitorFirstRunHourOfDay(int n) {
        this.d = Calendar.getInstance();
        if (this.d.get(11) >= n) {
            this.d.add(5, 1);
        }
        this.d.set(11, n);
        this.d.set(12, 0);
        this.d.set(13, 0);
        this.d.set(14, 0);
    }

    public String getDataSourceName() {
        return this.l;
    }

    public void setDataSourceName(String string) {
        this.l = string;
    }

    public final boolean isSchemaCheckEnabled() {
        return this.q;
    }

    public final void setSchemaCheckEnabled(boolean bl) {
        this.q = bl;
    }

    public class RevisionTableJanitor
    implements Runnable {
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    a.info("Next clean-up run scheduled at " + DatabaseJournal.this.d.getTime());
                    long l = DatabaseJournal.this.d.getTimeInMillis() - System.currentTimeMillis();
                    if (l > 0L) {
                        Thread.sleep(l);
                    }
                    this.cleanUpOldRevisions();
                    DatabaseJournal.this.d.add(13, DatabaseJournal.this.c);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            a.info("Interrupted: stopping clean-up task.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cleanUpOldRevisions() {
            ResultSet resultSet = null;
            try {
                long l = 0L;
                resultSet = DatabaseJournal.this.b.exec(DatabaseJournal.this.selectMinLocalRevisionStmtSQL, null, false, 0);
                boolean bl = resultSet.next();
                if (bl) {
                    l = resultSet.getLong(1);
                }
                if (bl) {
                    DatabaseJournal.this.b.exec(DatabaseJournal.this.cleanRevisionStmtSQL, new Object[]{l});
                    a.info("Cleaned old revisions up to revision " + l + ".");
                }
                DbUtility.close((ResultSet)resultSet);
            }
            catch (Exception exception) {
                a.warn("Failed to clean up old revisions.", (Throwable)exception);
            }
            finally {
                DbUtility.close(resultSet);
            }
        }
    }

    public class DatabaseRevision
    implements InstanceRevision {
        private long b;
        private boolean c = false;

        protected synchronized long init(long l) throws JournalException {
            long l2;
            ResultSet resultSet = null;
            try {
                resultSet = DatabaseJournal.this.b.exec(DatabaseJournal.this.getLocalRevisionStmtSQL, new Object[]{DatabaseJournal.this.getId()}, false, 0);
                boolean bl = resultSet.next();
                if (bl) {
                    l = resultSet.getLong(1);
                }
                if (!bl) {
                    DatabaseJournal.this.b.exec(DatabaseJournal.this.insertLocalRevisionStmtSQL, new Object[]{l, DatabaseJournal.this.getId()});
                }
                this.b = l;
                this.c = true;
                l2 = l;
            }
            catch (SQLException sQLException) {
                try {
                    a.warn("Failed to initialize local revision.", (Throwable)sQLException);
                    throw new JournalException("Failed to initialize local revision", (Throwable)sQLException);
                }
                catch (Throwable throwable) {
                    DbUtility.close(resultSet);
                    throw throwable;
                }
            }
            DbUtility.close((ResultSet)resultSet);
            return l2;
        }

        public synchronized long get() {
            if (!this.c) {
                throw new IllegalStateException("instance has not yet been initialized");
            }
            return this.b;
        }

        public synchronized void set(long l) throws JournalException {
            if (!this.c) {
                throw new IllegalStateException("instance has not yet been initialized");
            }
            try {
                DatabaseJournal.this.b.exec(DatabaseJournal.this.updateLocalRevisionStmtSQL, new Object[]{l, DatabaseJournal.this.getId()});
                this.b = l;
            }
            catch (SQLException sQLException) {
                a.warn("Failed to update local revision.", (Throwable)sQLException);
                throw new JournalException("Failed to update local revision.", (Throwable)sQLException);
            }
        }

        public void close() {
        }
    }
}

