/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository.database.journal;

import com.bstek.urule.console.repository.database.journal.DatabaseJournal;
import javax.sql.DataSource;
import org.apache.jackrabbit.core.util.db.CheckSchemaOperation;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.OracleConnectionHelper;

public class OracleDatabaseJournal
extends DatabaseJournal {
    protected static final String DEFAULT_TABLESPACE_CLAUSE = "";
    protected static final String TABLESPACE_VARIABLE = "${tablespace}";
    protected static final String INDEX_TABLESPACE_VARIABLE = "${indexTablespace}";
    protected String tablespace;
    protected String indexTablespace;

    public OracleDatabaseJournal() {
        this.setDatabaseType("oracle");
        this.setDriver("oracle.jdbc.OracleDriver");
        this.setSchemaObjectPrefix(DEFAULT_TABLESPACE_CLAUSE);
        this.tablespace = DEFAULT_TABLESPACE_CLAUSE;
        this.indexTablespace = DEFAULT_TABLESPACE_CLAUSE;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String string) {
        this.tablespace = this.a(string);
    }

    public String getIndexTablespace() {
        return this.indexTablespace;
    }

    public void setIndexTablespace(String string) {
        this.indexTablespace = this.a(string);
    }

    private String a(String string) {
        if (string == null || string.trim().length() == 0) {
            return DEFAULT_TABLESPACE_CLAUSE;
        }
        return "tablespace " + string.trim();
    }

    @Override
    protected ConnectionHelper createConnectionHelper(DataSource dataSource) throws Exception {
        OracleConnectionHelper oracleConnectionHelper = new OracleConnectionHelper(dataSource, false);
        oracleConnectionHelper.init();
        return oracleConnectionHelper;
    }

    @Override
    protected CheckSchemaOperation createCheckSchemaOperation() {
        if (DEFAULT_TABLESPACE_CLAUSE.equals(this.indexTablespace) && !DEFAULT_TABLESPACE_CLAUSE.equals(this.tablespace)) {
            this.indexTablespace = this.tablespace;
        }
        return super.createCheckSchemaOperation().addVariableReplacement(TABLESPACE_VARIABLE, this.tablespace).addVariableReplacement(INDEX_TABLESPACE_VARIABLE, this.indexTablespace);
    }
}

