/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository.database.manager;

import com.bstek.urule.console.repository.database.DbPersistenceManager;
import javax.sql.DataSource;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.DerbyConnectionHelper;

public class DerbyPersistenceManager
extends DbPersistenceManager {
    public static final String DERBY_EMBEDDED_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private int b = 16;
    private int c = 512;
    private int d = 1024;
    private int e = 20;
    private int f = 16384;

    public String getDerbyStorageInitialPages() {
        return String.valueOf(this.b);
    }

    public void setDerbyStorageInitialPages(String string) {
        this.b = Integer.decode(string);
    }

    public String getDerbyStorageMinimumRecordSize() {
        return String.valueOf(this.c);
    }

    public void setDerbyStorageMinimumRecordSize(String string) {
        this.c = Integer.decode(string);
    }

    public String getDerbyStoragePageCacheSize() {
        return String.valueOf(this.d);
    }

    public void setDerbyStoragePageCacheSize(String string) {
        this.d = Integer.decode(string);
    }

    public String getDerbyStoragePageReservedSpace() {
        return String.valueOf(this.e);
    }

    public void setDerbyStoragePageReservedSpace(String string) {
        this.e = Integer.decode(string);
    }

    public String getDerbyStoragePageSize() {
        return String.valueOf(this.f);
    }

    public void setDerbyStoragePageSize(String string) {
        this.f = Integer.decode(string);
    }

    @Override
    public void init(PMContext pMContext) throws Exception {
        if (this.getDriver() == null) {
            this.setDriver(DERBY_EMBEDDED_DRIVER);
        }
        if (this.getDatabaseType() == null) {
            this.setDatabaseType("derby");
        }
        if (this.getUrl() == null) {
            this.setUrl("jdbc:derby:" + pMContext.getHomeDir().getPath() + "/db/itemState;create=true");
        }
        if (this.getSchemaObjectPrefix() == null) {
            this.setSchemaObjectPrefix("");
        }
        super.init(pMContext);
        if (DERBY_EMBEDDED_DRIVER.equals(this.getDriver())) {
            this.conHelper.exec("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY ('derby.storage.initialPages', '" + this.b + "')", new Object[0]);
            this.conHelper.exec("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY ('derby.storage.minimumRecordSize', '" + this.c + "')", new Object[0]);
            this.conHelper.exec("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY ('derby.storage.pageCacheSize', '" + this.d + "')", new Object[0]);
            this.conHelper.exec("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY ('derby.storage.pageReservedSpace', '" + this.e + "')", new Object[0]);
            this.conHelper.exec("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY ('derby.storage.pageSize', '" + this.f + "')", new Object[0]);
        }
    }

    @Override
    protected ConnectionHelper createConnectionHelper(DataSource dataSource) {
        return new DerbyConnectionHelper(dataSource, this.blockOnConnectionLoss);
    }

    @Override
    public int getStorageModel() {
        return 2;
    }

    @Override
    public void close() throws Exception {
        super.close();
        ((DerbyConnectionHelper)this.conHelper).shutDown(this.getDriver());
    }
}

