/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository.database.system;

import com.bstek.urule.console.repository.database.BaseDbFileSystem;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.DerbyConnectionHelper;

public class DerbyFileSystem
extends BaseDbFileSystem {
    protected boolean shutdownOnClose;

    @Override
    public String databaseType() {
        return "derby";
    }

    public DerbyFileSystem() {
        this.schema = "derby";
        this.driver = "org.apache.derby.jdbc.EmbeddedDriver";
        this.shutdownOnClose = true;
        this.initialized = false;
    }

    public boolean getShutdownOnClose() {
        return this.shutdownOnClose;
    }

    public void setShutdownOnClose(boolean bl) {
        this.shutdownOnClose = bl;
    }

    protected ConnectionHelper createConnectionHelper(DataSource dataSource) throws Exception {
        return new DerbyConnectionHelper(dataSource, false);
    }

    public void close() throws FileSystemException {
        super.close();
        if (this.shutdownOnClose) {
            try {
                ((DerbyConnectionHelper)this.conHelper).shutDown(this.driver);
            }
            catch (SQLException sQLException) {
                throw new FileSystemException("failed to shutdown Derby", (Throwable)sQLException);
            }
        }
    }
}

