/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository.dynamic;

import com.bstek.urule.console.repository.BaseRepositoryService;
import com.bstek.urule.console.repository.dynamic.DynamicFile;
import com.bstek.urule.console.repository.dynamic.DynamicJar;
import com.bstek.urule.console.repository.dynamic.DynamicJarRepositoryService;
import com.bstek.urule.exception.RuleException;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Value;
import org.apache.jackrabbit.value.BinaryImpl;
import org.apache.jackrabbit.value.DateValue;
import org.apache.poi.util.IOUtils;

public class DynamicJarRepositoryServiceImpl
extends BaseRepositoryService
implements DynamicJarRepositoryService {
    public static final String BEAN_ID = "urule.dynamicJarRepositoryService";

    @Override
    public List<DynamicFile> loadFiles() throws Exception {
        ArrayList<DynamicFile> arrayList = new ArrayList<DynamicFile>();
        Node node = this.a();
        NodeIterator nodeIterator = node.getNodes();
        while (nodeIterator.hasNext()) {
            Node node2 = nodeIterator.nextNode();
            DynamicFile dynamicFile = this.a(node2);
            arrayList.add(0, dynamicFile);
        }
        return arrayList;
    }

    @Override
    public void removeFile(String string) throws Exception {
        string = this.processPath(string);
        this.session.refresh(false);
        Node node = this.getRootNode();
        if (!node.hasNode(string)) {
            return;
        }
        node.getNode(string).remove();
        this.session.save();
    }

    @Override
    public DynamicFile getFile(String string) throws Exception {
        string = this.processPath(string);
        Node node = this.getRootNode();
        if (!node.hasNode(string)) {
            return null;
        }
        Node node2 = node.getNode(string);
        DynamicFile dynamicFile = this.a(node2);
        return dynamicFile;
    }

    @Override
    public void removeJar(String string, String string2) throws Exception {
        string = this.processPath(string);
        this.session.refresh(false);
        Node node = this.getRootNode();
        if (!node.hasNode(string)) {
            return;
        }
        Node node2 = node.getNode(string);
        PropertyIterator propertyIterator = node2.getProperties();
        while (propertyIterator.hasNext()) {
            String string3;
            Property property = propertyIterator.nextProperty();
            String string4 = property.getName();
            if (!string4.startsWith("_dynamic_jar_prefix_") || !(string3 = this.a(string4)).equals(string2)) continue;
            property.remove();
            this.session.save();
            break;
        }
    }

    @Override
    public void saveFile(DynamicFile dynamicFile) throws Exception {
        Node node = null;
        this.session.refresh(false);
        Node node2 = this.a();
        node = node2.hasNode(dynamicFile.getName()) ? node2.getNode(dynamicFile.getName()) : node2.addNode(dynamicFile.getName());
        node.setProperty("_create_user", dynamicFile.getCreateUser());
        node.setProperty("_version_comment", dynamicFile.getComment());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        DateValue dateValue = new DateValue(calendar);
        node.setProperty("_create_date", (Value)dateValue);
        this.session.save();
    }

    @Override
    public void addJar(String string, String string2, InputStream inputStream) throws Exception {
        this.session.refresh(false);
        Node node = this.getRootNode();
        string = this.processPath(string);
        if (!node.hasNode(string)) {
            throw new RuleException("Path [" + string + "] not exist.");
        }
        Node node2 = node.getNode(string);
        BinaryImpl binaryImpl = new BinaryImpl(IOUtils.toByteArray((InputStream)inputStream));
        node2.setProperty("_dynamic_jar_prefix_" + string2, (Binary)binaryImpl);
        this.session.save();
    }

    @Override
    public InputStream loadJar(String string, String string2) throws Exception {
        string = this.processPath(string);
        Node node = this.getRootNode();
        if (!node.hasNode(string)) {
            throw new RuleException("Path [" + string + "] not exist.");
        }
        InputStream inputStream = null;
        Node node2 = node.getNode(string);
        PropertyIterator propertyIterator = node2.getProperties();
        while (propertyIterator.hasNext()) {
            String string3;
            Property property = propertyIterator.nextProperty();
            String string4 = property.getName();
            if (!string4.startsWith("_dynamic_jar_prefix_") || !string2.equals(string3 = this.a(string4))) continue;
            inputStream = property.getBinary().getStream();
            break;
        }
        return inputStream;
    }

    @Override
    public void generateJars(String string, String string2) throws Exception {
        string = this.processPath(string);
        Node node = this.getRootNode();
        if (!node.hasNode(string)) {
            throw new RuleException("Path [" + string + "] not exist.");
        }
        Node node2 = node.getNode(string);
        PropertyIterator propertyIterator = node2.getProperties();
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.nextProperty();
            String string3 = property.getName();
            if (!string3.startsWith("_dynamic_jar_prefix_")) continue;
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdirs();
            }
            String string4 = this.a(string3);
            String string5 = string2 + "/" + string4;
            InputStream inputStream = property.getBinary().getStream();
            File file2 = new File(string5);
            if (!file2.exists()) {
                file2.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            IOUtils.closeQuietly((Closeable)fileOutputStream);
            IOUtils.closeQuietly((Closeable)inputStream);
        }
    }

    private DynamicFile a(Node node) throws Exception {
        DynamicFile dynamicFile = new DynamicFile();
        dynamicFile.setName(node.getName());
        Property property = node.getProperty("_create_user");
        dynamicFile.setCreateUser(property.getString());
        property = node.getProperty("_create_date");
        dynamicFile.setCreateDate(property.getDate().getTime());
        property = node.getProperty("_version_comment");
        dynamicFile.setComment(property.getString());
        dynamicFile.setPath(node.getPath());
        dynamicFile.setJars(this.b(node));
        return dynamicFile;
    }

    private List<DynamicJar> b(Node node) throws Exception {
        PropertyIterator propertyIterator = node.getProperties();
        ArrayList<DynamicJar> arrayList = new ArrayList<DynamicJar>();
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.nextProperty();
            String string = property.getName();
            if (!string.startsWith("_dynamic_jar_prefix_")) continue;
            String string2 = this.a(string);
            arrayList.add(new DynamicJar(string2));
        }
        return arrayList;
    }

    private String a(String string) {
        return string.substring("_dynamic_jar_prefix_".length(), string.length());
    }

    private Node a() throws Exception {
        this.session.refresh(false);
        Node node = this.getRootNode();
        String string = "___dynamic__jars__node__";
        Node node2 = null;
        if (node.hasNode(string)) {
            node2 = node.getNode(string);
        } else {
            node2 = node.addNode(string);
            this.session.save();
        }
        return node2;
    }
}

