/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository.model;

import com.bstek.urule.console.repository.model.LibType;
import com.bstek.urule.console.repository.model.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.codehaus.jackson.annotate.JsonIgnore;

public class RepositoryFile {
    private String id = UUID.randomUUID().toString();
    private String name;
    private String comment;
    private String fullPath;
    private Type type;
    private Type folderType;
    private boolean lock;
    private String lockInfo;
    @JsonIgnore
    private LibType libType;
    @JsonIgnore
    private RepositoryFile parentFile;
    private List<RepositoryFile> children;

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public RepositoryFile getParentFile() {
        return this.parentFile;
    }

    public void setParentFile(RepositoryFile repositoryFile) {
        this.parentFile = repositoryFile;
    }

    public LibType getLibType() {
        return this.libType;
    }

    public void setLibType(LibType libType) {
        this.libType = libType;
    }

    public List<RepositoryFile> getChildren() {
        return this.children;
    }

    public void addChild(RepositoryFile repositoryFile, boolean bl) {
        if (this.children == null) {
            this.children = new ArrayList<RepositoryFile>();
        }
        repositoryFile.setParentFile(this);
        if (bl) {
            this.children.add(0, repositoryFile);
        } else {
            this.children.add(repositoryFile);
        }
    }

    public void setChildren(List<RepositoryFile> list) {
        this.children = list;
    }

    public String getFullPath() {
        if (this.fullPath == null) {
            this.fullPath = this.parentFile != null ? this.parentFile.getFullPath() : "";
            if (this.fullPath.equals("/")) {
                this.fullPath = "";
            }
            this.fullPath = this.fullPath + "/" + this.name;
        }
        return this.fullPath;
    }

    public void setFullPath(String string) {
        this.fullPath = string;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getFolderType() {
        return this.folderType;
    }

    public void setFolderType(Type type) {
        this.folderType = type;
    }

    public boolean isLock() {
        return this.lock;
    }

    public void setLock(boolean bl) {
        this.lock = bl;
    }

    public String getLockInfo() {
        return this.lockInfo;
    }

    public void setLockInfo(String string) {
        this.lockInfo = string;
    }
}

