/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository.reference;

import com.bstek.urule.console.repository.BaseRepositoryService;
import com.bstek.urule.console.repository.model.FileType;
import com.bstek.urule.console.repository.reference.ActionSearchItem;
import com.bstek.urule.console.repository.reference.ConstantSearchItem;
import com.bstek.urule.console.repository.reference.ParameterSearchItem;
import com.bstek.urule.console.repository.reference.RefFile;
import com.bstek.urule.console.repository.reference.ReferenceService;
import com.bstek.urule.console.repository.reference.SearchItem;
import com.bstek.urule.console.repository.reference.VariableSearchItem;
import com.bstek.urule.exception.RuleException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;

public class ReferenceServiceImpl
extends BaseRepositoryService
implements ReferenceService {
    @Override
    public List<RefFile> loadReferenceFiles(String string, SearchItem searchItem) throws Exception {
        List<String> list = this.a(string, searchItem, true);
        List<String> list2 = this.a(string, list.get(0));
        list = this.a(string, searchItem, false);
        for (String string2 : list) {
            List<String> list3 = this.a(string, string2);
            list2.addAll(list3);
        }
        return this.a(list2);
    }

    @Override
    public List<RefFile> loadReferenceFiles(String string) throws Exception {
        List<String> list = this.a(string, null);
        return this.a(list);
    }

    private List<RefFile> a(List<String> list) {
        ArrayList<RefFile> arrayList = new ArrayList<RefFile>();
        for (String string : list) {
            RefFile refFile = new RefFile();
            arrayList.add(refFile);
            refFile.setPath(string);
            if (string.endsWith(FileType.Ruleset.toString())) {
                refFile.setEditor("/ruleseteditor");
                refFile.setType("\u51b3\u7b56\u96c6");
            } else if (string.endsWith(FileType.ConditionTemplate.toString())) {
                refFile.setEditor("/conditiontemplate");
                refFile.setType("\u6761\u4ef6\u6a21\u7248");
            } else if (string.endsWith(FileType.ActionTemplate.toString())) {
                refFile.setEditor("/actiontemplate");
                refFile.setType("\u52a8\u4f5c\u6a21\u7248");
            } else if (string.endsWith(FileType.UL.toString())) {
                refFile.setEditor("/uleditor");
                refFile.setType("\u811a\u672c\u51b3\u7b56\u96c6");
            } else if (string.endsWith(FileType.DecisionTable.toString())) {
                refFile.setEditor("/decisiontableeditor");
                refFile.setType("\u51b3\u7b56\u8868");
            } else if (string.endsWith(FileType.ScriptDecisionTable.toString())) {
                refFile.setEditor("/scriptdecisiontableeditor");
                refFile.setType("\u811a\u672c\u51b3\u7b56\u8868");
            } else if (string.endsWith(FileType.Crosstab.toString())) {
                refFile.setEditor("/crosstabeditor");
                refFile.setType("\u4ea4\u53c9\u51b3\u7b56\u8868");
            } else if (string.endsWith(FileType.DecisionTree.toString())) {
                refFile.setEditor("/decisiontreeeditor");
                refFile.setType("\u51b3\u7b56\u6811");
            } else if (string.endsWith(FileType.RuleFlow.toString())) {
                refFile.setEditor("/ruleflowdesigner");
                refFile.setType("\u51b3\u7b56\u6d41");
            } else if (string.endsWith(FileType.Scorecard.toString())) {
                refFile.setEditor("/scorecardeditor");
                refFile.setType("\u8bc4\u5206\u5361");
            } else if (string.endsWith(FileType.ComplexScorecard.toString())) {
                refFile.setEditor("/complexscorecardeditor");
                refFile.setType("\u590d\u6742\u8bc4\u5206\u5361");
            }
            int n = string.lastIndexOf("/");
            String string2 = string;
            if (n > -1) {
                string2 = string.substring(n + 1, string.length());
            }
            refFile.setName(string2);
        }
        return arrayList;
    }

    private List<String> a(String string, String string2) throws Exception {
        Node node = this.getRootNode();
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = this.a(node, string);
        for (String string3 : list) {
            InputStream inputStream = this.readFile(string3, null);
            String string4 = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            inputStream.close();
            boolean bl = string4.contains(string);
            boolean bl2 = true;
            if (string2 != null) {
                bl2 = string4.contains(string2);
            }
            if (!bl || !bl2) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    private List<String> a(Node node, String string) throws Exception {
        String string2 = this.getProject(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        Node node2 = node.getNode(string2);
        this.a(arrayList, node2);
        return arrayList;
    }

    public String getProject(String string) {
        int n;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((n = string.indexOf("/")) == -1) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    private void a(List<String> list, Node node) throws RepositoryException {
        NodeIterator nodeIterator = node.getNodes();
        while (nodeIterator.hasNext()) {
            Node node2 = nodeIterator.nextNode();
            String string = node2.getPath();
            if (string.endsWith(FileType.Ruleset.toString())) {
                list.add(string);
            } else if (string.endsWith(FileType.UL.toString())) {
                list.add(string);
            } else if (string.endsWith(FileType.DecisionTable.toString())) {
                list.add(string);
            } else if (string.endsWith(FileType.ScriptDecisionTable.toString())) {
                list.add(string);
            } else if (string.endsWith(FileType.Crosstab.toString())) {
                list.add(string);
            } else if (string.endsWith(FileType.DecisionTree.toString())) {
                list.add(string);
            } else if (string.endsWith(FileType.RuleFlow.toString())) {
                list.add(string);
            } else if (string.endsWith(FileType.Scorecard.toString())) {
                list.add(string);
            } else if (string.endsWith(FileType.ComplexScorecard.toString())) {
                list.add(string);
            } else if (string.endsWith(FileType.ConditionTemplate.toString())) {
                list.add(string);
            } else if (string.endsWith(FileType.ActionTemplate.toString())) {
                list.add(string);
            }
            this.a(list, node2);
        }
    }

    private List<String> a(String string, SearchItem searchItem, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        if (string.endsWith(FileType.ActionLibrary.toString())) {
            ActionSearchItem actionSearchItem = (ActionSearchItem)searchItem;
            if (bl) {
                stringBuilder.append(actionSearchItem.getBeanLabel());
                stringBuilder.append(".");
                stringBuilder.append(actionSearchItem.getMethodLabel());
                arrayList.add(stringBuilder.toString());
            } else {
                stringBuilder.append("bean=\"" + actionSearchItem.getBeanName() + "\"");
                stringBuilder.append(" bean-label=\"" + actionSearchItem.getBeanLabel() + "\"");
                stringBuilder.append(" method-label=\"" + actionSearchItem.getMethodLabel() + "\"");
                stringBuilder.append(" method-name=\"" + actionSearchItem.getMethodName() + "\"");
                arrayList.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
                stringBuilder.append("bean-name=\"" + actionSearchItem.getBeanName() + "\"");
                stringBuilder.append(" bean-label=\"" + actionSearchItem.getBeanLabel() + "\"");
                stringBuilder.append(" method-name=\"" + actionSearchItem.getMethodName() + "\"");
                stringBuilder.append(" method-label=\"" + actionSearchItem.getMethodLabel() + "\"");
                arrayList.add(stringBuilder.toString());
            }
            return arrayList;
        }
        if (string.endsWith(FileType.ConstantLibrary.toString())) {
            ConstantSearchItem constantSearchItem = (ConstantSearchItem)searchItem;
            if (bl) {
                stringBuilder.append(constantSearchItem.getConstCategoryLabel());
                stringBuilder.append(".");
                stringBuilder.append(constantSearchItem.getConstLabel());
            } else {
                stringBuilder.append("const-category=\"" + constantSearchItem.getConstCategoryLabel() + "\"");
                stringBuilder.append(" const=\"" + constantSearchItem.getConstName() + "\"");
            }
            arrayList.add(stringBuilder.toString());
            return arrayList;
        }
        if (string.endsWith(FileType.ParameterLibrary.toString())) {
            ParameterSearchItem parameterSearchItem = (ParameterSearchItem)searchItem;
            if (bl) {
                stringBuilder.append("\u53c2\u6570.");
                stringBuilder.append(parameterSearchItem.getVarLabel());
            } else {
                stringBuilder.append("var-category=\"\u53c2\u6570\"");
                stringBuilder.append(" var=\"" + parameterSearchItem.getVarName() + "\"");
            }
            arrayList.add(stringBuilder.toString());
            return arrayList;
        }
        if (string.endsWith(FileType.VariableLibrary.toString())) {
            VariableSearchItem variableSearchItem = (VariableSearchItem)searchItem;
            if (bl) {
                stringBuilder.append(variableSearchItem.getVarCategory());
                stringBuilder.append(".");
                stringBuilder.append(variableSearchItem.getVarLabel());
            } else {
                stringBuilder.append("var-category=\"" + variableSearchItem.getVarCategory() + "\"");
                stringBuilder.append(" var=\"" + variableSearchItem.getVarName() + "\"");
            }
            arrayList.add(stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append("var-category=\"" + variableSearchItem.getVarCategory() + "\"");
            stringBuilder.append(" var-label=\"" + variableSearchItem.getVarLabel() + "\"");
            stringBuilder.append(" var=\"" + variableSearchItem.getVarName() + "\"");
            arrayList.add(stringBuilder.toString());
            return arrayList;
        }
        throw new RuleException("Unknow file : " + string);
    }
}

