/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository.scenario;

import com.bstek.urule.console.repository.BaseRepositoryService;
import com.bstek.urule.console.repository.scenario.DataField;
import com.bstek.urule.console.repository.scenario.ScenarioRepositoryService;
import com.bstek.urule.console.repository.scenario.SimulateData;
import com.bstek.urule.console.repository.scenario.TestScenario;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rule.Op;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.value.BinaryImpl;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ScenarioRepositoryServiceImpl
extends BaseRepositoryService
implements ScenarioRepositoryService {
    @Override
    public void deleteTestScenarios(String string, String string2) throws Exception {
        this.session.refresh(false);
        Node node = this.getRootNode();
        String string3 = string + "/" + "___test__scenario__file__" + string2;
        string3 = this.processPath(string3);
        if (!node.hasNode(string3)) {
            return;
        }
        List<TestScenario> list = this.loadTestScenarios(string, string2);
        for (TestScenario testScenario : list) {
            String string4 = testScenario.getExcelId();
            this.deleteTestScenarioExcel(string4, string);
        }
        node.getNode(string3).remove();
        this.session.save();
    }

    @Override
    public void saveTestScenarios(String string, String string2, String string3) throws Exception {
        this.session.refresh(false);
        Node node = this.getRootNode();
        String string4 = string + "/" + "___test__scenario__file__" + string2;
        string4 = this.processPath(string4);
        Node node2 = null;
        node2 = node.hasNode(string4) ? node.getNode(string4) : node.addNode(string4);
        BinaryImpl binaryImpl = new BinaryImpl(string3.getBytes("utf-8"));
        node2.setProperty("_data", (Binary)binaryImpl);
        this.session.save();
    }

    @Override
    public void saveTestScenarioExcel(String string, String string2, InputStream inputStream) throws Exception {
        this.session.refresh(false);
        Node node = this.getRootNode();
        String string3 = string2 + "/" + "___test__scenario__excel__file__" + "_" + string;
        string3 = this.processPath(string3);
        if (node.hasNode(string3)) {
            throw new RuleException("File [" + string3 + "] already exist.");
        }
        Node node2 = node.addNode(string3);
        BinaryImpl binaryImpl = new BinaryImpl(inputStream);
        node2.setProperty("_data", (Binary)binaryImpl);
        this.session.save();
    }

    @Override
    public InputStream loadTestScenarioExcel(String string, String string2) throws Exception {
        Node node = this.getRootNode();
        String string3 = string2 + "/" + "___test__scenario__excel__file__" + "_" + string;
        if (!node.hasNode(string3 = this.processPath(string3))) {
            throw new RuleException("File [" + string3 + "] not exist.");
        }
        Node node2 = node.getNode(string3);
        return node2.getProperty("_data").getBinary().getStream();
    }

    @Override
    public boolean deleteTestScenarioExcel(String string, String string2) throws Exception {
        Node node = this.getRootNode();
        String string3 = string2 + "/" + "___test__scenario__excel__file__" + "_" + string;
        string3 = this.processPath(string3);
        this.session.refresh(false);
        if (node.hasNode(string3)) {
            Node node2 = node.getNode(string3);
            if (!node2.isCheckedOut()) {
                this.versionManager.checkout(node2.getPath());
            }
            node2.remove();
            this.session.save();
            return true;
        }
        return false;
    }

    @Override
    public List<TestScenario> loadTestScenarios(String string, String string2) throws Exception {
        ArrayList<TestScenario> arrayList = new ArrayList<TestScenario>();
        Node node = this.getRootNode();
        String string3 = string + "/" + "___test__scenario__file__" + string2;
        if (!node.hasNode(string3 = this.processPath(string3))) {
            return arrayList;
        }
        Node node2 = node.getNode(string3);
        Property property = node2.getProperty("_data");
        Binary binary = property.getBinary();
        InputStream inputStream = binary.getStream();
        String string4 = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
        inputStream.close();
        Document document = DocumentHelper.parseText((String)string4);
        Element element = document.getRootElement();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (Object e : element.elements()) {
            Element element2;
            if (!(e instanceof Element) || !(element2 = (Element)e).getName().equals("scenario")) continue;
            TestScenario testScenario = new TestScenario();
            testScenario.setName(element2.attributeValue("name"));
            testScenario.setDesc(element2.attributeValue("desc"));
            testScenario.setExcelId(element2.attributeValue("excel-id"));
            testScenario.setCreateDate(simpleDateFormat.parse(element2.attributeValue("create-date")));
            testScenario.setCreateUser(element2.attributeValue("create-user"));
            testScenario.setShowInputData(Boolean.valueOf(element2.attributeValue("show-input-data")));
            testScenario.setShowOutputData(Boolean.valueOf(element2.attributeValue("show-output-data")));
            testScenario.setShowLog(Boolean.valueOf(element2.attributeValue("show-log")));
            testScenario.setShowFiredFlowNodeList(Boolean.valueOf(element2.attributeValue("show-fired-flow-node-list")));
            testScenario.setShowFiredFlowNodeSize(Boolean.valueOf(element2.attributeValue("show-fired-flow-node-size")));
            testScenario.setShowMatchedRuleList(Boolean.valueOf(element2.attributeValue("show-matched-rule-list")));
            testScenario.setShowMatchedRuleSize(Boolean.valueOf(element2.attributeValue("show-matched-rule-size")));
            testScenario.setShowNotMatchRuleSize(Boolean.valueOf(element2.attributeValue("show-not-match-rule-size")));
            testScenario.setShowNotMatchRuleList(Boolean.valueOf(element2.attributeValue("show-not-match-rule-list")));
            arrayList.add(testScenario);
            ArrayList<SimulateData> arrayList2 = new ArrayList<SimulateData>();
            ArrayList<SimulateData> arrayList3 = new ArrayList<SimulateData>();
            testScenario.setInputData(arrayList2);
            testScenario.setOutputData(arrayList3);
            for (Object e2 : element2.elements()) {
                if (!(e2 instanceof Element)) continue;
                Element element3 = (Element)e2;
                if (element3.getName().equals("input")) {
                    arrayList2.add(this.a(element3));
                }
                if (!element3.getName().equals("output")) continue;
                arrayList3.add(this.a(element3));
            }
        }
        return arrayList;
    }

    private SimulateData a(Element element) {
        SimulateData simulateData = new SimulateData();
        simulateData.setName(element.attributeValue("name"));
        ArrayList<DataField> arrayList = new ArrayList<DataField>();
        simulateData.setFields(arrayList);
        for (Object e : element.elements()) {
            Element element2;
            if (!(e instanceof Element) || !(element2 = (Element)e).getName().equals("field")) continue;
            DataField dataField = new DataField();
            dataField.setName(element2.attributeValue("name"));
            dataField.setLabel(element2.attributeValue("label"));
            dataField.setDatatype(Datatype.valueOf((String)element2.attributeValue("datatype")));
            String string = element2.attributeValue("op");
            if (StringUtils.isNotBlank((String)string)) {
                dataField.setOp(Op.valueOf((String)string));
            }
            arrayList.add(dataField);
        }
        return simulateData;
    }
}

