/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet;

import com.bstek.urule.console.servlet.rest.MultiData;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.GeneralEntity;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.variable.Variable;
import com.bstek.urule.model.library.variable.VariableCategory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonBuilder {
    private Logger a = Logger.getGlobal();
    private static JsonBuilder b = new JsonBuilder();

    public static JsonBuilder getInstance() {
        return b;
    }

    public Object buildComplexObject(Object object, List<VariableCategory> list) throws Exception {
        if (object instanceof String) {
            String string = object.toString().trim();
            ObjectMapper objectMapper = new ObjectMapper();
            if (string.startsWith("{") && string.endsWith("}")) {
                Map map = (Map)objectMapper.readValue(string, HashMap.class);
                Object v = map.get("data");
                if (v != null && v instanceof List) {
                    List list2 = (List)v;
                    return this.a(list2, list);
                }
                return this.a(list, (Map<String, Object>)map);
            }
            if (string.startsWith("[") && string.endsWith("]")) {
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                List list3 = (List)objectMapper.readValue(string, ArrayList.class);
                for (Map map : list3) {
                    arrayList.add(this.a(list, (Map<String, Object>)map));
                }
                return arrayList;
            }
            if (!this.a(string)) {
                return string;
            }
            try {
                Base64 base64 = new Base64();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(base64.decode(string.getBytes("utf-8")));
                GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
                byte[] byArray = new byte[1024];
                int n = -1;
                while ((n = gZIPInputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayInputStream.close();
                gZIPInputStream.close();
                String string2 = byteArrayOutputStream.toString();
                return this.buildComplexObject(string2, list);
            }
            catch (Exception exception) {
                this.a.warning(exception.getMessage());
                this.a.warning("Fail to decode data :" + string + "");
                return string;
            }
        }
        if (object instanceof List) {
            ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
            List list4 = (List)object;
            for (Map map : list4) {
                arrayList.add(this.a(list, (Map<String, Object>)map));
            }
            return arrayList;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return this.a(list, (Map<String, Object>)map);
        }
        return object;
    }

    private MultiData a(List<Object> list, List<VariableCategory> list2) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : list) {
            Object object2;
            if (object instanceof List) {
                object2 = new ArrayList();
                arrayList.add(object2);
                List list3 = (List)object;
                for (Object e : list3) {
                    if (!(e instanceof Map)) {
                        this.a.warning("[" + e + "] is not a map data!");
                        continue;
                    }
                    Map map = (Map)e;
                    object2.add(this.a(list2, (Map<String, Object>)map));
                }
                continue;
            }
            object2 = (Map)object;
            arrayList.add(this.a(list2, (Map<String, Object>)object2));
        }
        return new MultiData(arrayList);
    }

    private boolean a(String string) {
        String string2 = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        return string.matches(string2);
    }

    private Map<String, Object> a(List<VariableCategory> list, Map<String, Object> map) throws Exception {
        String string = (String)map.get("name");
        if (StringUtils.isBlank((String)string)) {
            throw new RuleException("\u590d\u6742\u5bf9\u8c61\u503c\u3010" + map + "\u3011\u9700\u8981\u4e00\u4e2a\u540d\u4e3a\"name\"\u7684\u5c5e\u6027\u503c\u6765\u6807\u660e\u5f53\u524d\u5bf9\u8c61\u7c7b\u578b");
        }
        VariableCategory variableCategory = this.findVariableCategory(list, string);
        GeneralEntity generalEntity = null;
        generalEntity = string.equals("\u53c2\u6570") ? new HashMap() : new GeneralEntity(variableCategory.getClazz());
        Object object = map.get("fields");
        if (object == null) {
            throw new RuleException("\u590d\u6742\u5bf9\u8c61\u503c\u3010" + map + "\u3011\u9700\u8981\u4e00\u4e2a\u540d\u4e3a\"fields\"\u7684\u5c5e\u6027\u503c\u6765\u6807\u660e\u5f53\u524d\u5bf9\u8c61\u6709\u54ea\u4e9b\u5c5e\u6027.");
        }
        if (object instanceof List) {
            List list2 = (List)object;
            for (Map map2 : list2) {
                String string2 = (String)map2.get("name");
                if (StringUtils.isBlank((String)string2)) {
                    throw new RuleException("\u5b50\u5bf9\u8c61\u9700\u8981\u6709\u4e00\u4e2a\u540d\u4e3a\"" + string2 + "\"\u7684\u5c5e\u6027\u6765\u6807\u660e\u5bf9\u8c61\u7684\u5177\u4f53\u5c5e\u6027\u540d");
                }
                Object v = map2.get("value");
                if (v == null) continue;
                Variable variable = this.findVariable(variableCategory, string2);
                Datatype datatype = variable.getType();
                if (datatype.equals((Object)Datatype.Object) || datatype.equals((Object)Datatype.List)) {
                    generalEntity.put(variable.getName(), this.buildComplexObject(v, list));
                    continue;
                }
                generalEntity.put(variable.getName(), datatype.convert(v));
            }
        } else if (object instanceof Map) {
            Map map3 = (Map)object;
            for (String string3 : map3.keySet()) {
                Object v = map3.get(string3);
                if (v == null) continue;
                Variable variable = this.findVariable(variableCategory, string3);
                Datatype datatype = variable.getType();
                SubObject subObject = this.a(variable.getName(), (Map<String, Object>)generalEntity);
                Map<String, Object> map4 = subObject.getMap();
                if (datatype.equals((Object)Datatype.Object) || datatype.equals((Object)Datatype.List)) {
                    map4.put(subObject.getName(), this.buildComplexObject(v, list));
                    continue;
                }
                map4.put(subObject.getName(), datatype.convert(v));
            }
        } else {
            throw new RuleException("\u590d\u6742\u5bf9\u8c61\u503c\u3010" + map + "\u3011\u7684\"fields\"\u7684\u5c5e\u6027\u503c\u5fc5\u987b\u662f\u4e00\u4e2a\u5bf9\u8c61\u7c7b\u578b\u6216\u96c6\u5408\u7c7b\u578b.");
        }
        return generalEntity;
    }

    private SubObject a(String string, Map<String, Object> map) {
        Map map2 = map;
        String[] stringArray = string.split("\\.");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            String string2 = stringArray[i];
            if (map.containsKey(string2)) {
                map2 = (Map)map.get(string2);
                continue;
            }
            map2.put(string2, new HashMap());
            map2 = (Map)map.get(string2);
        }
        string = stringArray[stringArray.length - 1];
        return new SubObject(string, map2);
    }

    public VariableCategory findVariableCategory(List<VariableCategory> list, String string) {
        for (VariableCategory variableCategory : list) {
            if (!string.equals(variableCategory.getName()) && !string.equals(variableCategory.getClazz())) continue;
            return variableCategory;
        }
        throw new RuleException("\u53d8\u91cf\u5bf9\u8c61\u3010" + string + "\u3011\u672a\u5b9a\u4e49!");
    }

    public Variable findVariable(VariableCategory variableCategory, String string) {
        for (Variable variable : variableCategory.getVariables()) {
            if (!variable.getLabel().equals(string) && !variable.getName().equals(string)) continue;
            return variable;
        }
        throw new RuleException("\u53d8\u91cf\u5bf9\u8c61\u3010" + variableCategory.getName() + "\u3011\u4e2d\u672a\u5b9a\u4e49\u540d\u4e3a\u3010" + string + "\u3011\u5b57\u6bb5\uff01");
    }

    class SubObject {
        private String b;
        private Map<String, Object> c;

        public SubObject(String string, Map<String, Object> map) {
            this.b = string;
            this.c = map;
        }

        public Map<String, Object> getMap() {
            return this.c;
        }

        public String getName() {
            return this.b;
        }
    }
}

