/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet;

import com.bstek.urule.Utils;
import com.bstek.urule.console.Principal;
import com.bstek.urule.console.exception.NoPermissionException;
import com.bstek.urule.console.repository.Repository;
import com.bstek.urule.console.repository.authority.Authority;
import com.bstek.urule.console.repository.authority.AuthorityService;
import com.bstek.urule.console.repository.model.RepositoryFile;
import com.bstek.urule.console.servlet.WriteJsonServletHandler;
import com.bstek.urule.exception.RuleException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.log.NullLogChute;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class RenderPageServletHandler
extends WriteJsonServletHandler
implements ApplicationContextAware {
    protected VelocityEngine ve;
    protected ApplicationContext applicationContext;
    protected AuthorityService authorityService;
    private Logger a = Logger.getGlobal();

    protected boolean validateUserPwd(HttpServletRequest httpServletRequest, String string, String string2) {
        String string3 = httpServletRequest.getParameter("_u");
        String string4 = httpServletRequest.getParameter("_p");
        if (string3 == null || string4 == null) {
            this.a.warning("User and password can not be null.");
            return false;
        }
        try {
            string3 = URLDecoder.decode(string3, "utf-8");
            string4 = URLDecoder.decode(string4, "utf-8");
            if (!string3.equals(string) || !string4.equals(string2)) {
                this.a.warning("User or password is invalid.");
                return false;
            }
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuleException((Exception)unsupportedEncodingException);
        }
    }

    protected String buildErrorMsg(Exception exception) {
        Throwable throwable = this.a(exception);
        if (throwable instanceof NullPointerException) {
            return "\u7a7a\u6307\u9488\u9519\u8bef\uff01";
        }
        String string = throwable.getMessage();
        string = string == null ? "\u670d\u52a1\u7aef\u9519\u8bef!" : string;
        return string;
    }

    private Throwable a(Throwable throwable) {
        if (throwable.getCause() != null) {
            return this.a(throwable.getCause());
        }
        return throwable;
    }

    protected String buildProjectNameFromFile(String string) {
        String string2 = null;
        if (StringUtils.isNotBlank((String)string) && (string = Utils.decodeURL((String)string)).startsWith("/")) {
            string = string.substring(1, string.length());
            int n = string.indexOf("/");
            string2 = string.substring(0, n);
        }
        return string2;
    }

    protected Repository buildRepositoryAuthority(Principal principal, Repository repository) {
        Repository repository2 = new Repository();
        ArrayList<String> arrayList = new ArrayList<String>();
        repository2.setProjectNames(arrayList);
        for (String object2 : repository.getProjectNames()) {
            String string = "/" + object2;
            Authority authority = this.authorityService.getAuthority(true, principal, string);
            if (authority != null && !authority.isRead()) continue;
            arrayList.add(object2);
        }
        RepositoryFile repositoryFile = repository.getRootFile();
        RepositoryFile repositoryFile2 = this.a(principal, repositoryFile, repositoryFile);
        repository2.setRootFile(repositoryFile2);
        return repository2;
    }

    private RepositoryFile a(Principal principal, RepositoryFile repositoryFile, RepositoryFile repositoryFile2) {
        Object object;
        String string = repositoryFile.getFullPath();
        if (!string.contentEquals("/") && (object = this.authorityService.getAuthority(true, principal, string)) != null && !((Authority)object).isRead()) {
            return null;
        }
        object = new RepositoryFile();
        ((RepositoryFile)object).setFolderType(repositoryFile.getFolderType());
        ((RepositoryFile)object).setFullPath(string);
        ((RepositoryFile)object).setId(repositoryFile.getId());
        ((RepositoryFile)object).setLibType(repositoryFile.getLibType());
        ((RepositoryFile)object).setLock(repositoryFile.isLock());
        ((RepositoryFile)object).setLockInfo(repositoryFile.getLockInfo());
        ((RepositoryFile)object).setName(repositoryFile.getName());
        ((RepositoryFile)object).setParentFile(repositoryFile2);
        ((RepositoryFile)object).setType(repositoryFile.getType());
        List<RepositoryFile> list = repositoryFile.getChildren();
        if (list != null) {
            ArrayList<RepositoryFile> arrayList = new ArrayList<RepositoryFile>();
            ((RepositoryFile)object).setChildren(arrayList);
            for (RepositoryFile repositoryFile3 : list) {
                RepositoryFile repositoryFile4 = this.a(principal, repositoryFile3, (RepositoryFile)object);
                if (repositoryFile4 == null) continue;
                arrayList.add(repositoryFile4);
            }
        }
        return object;
    }

    protected void checkFullPermission(Principal principal, String string, boolean bl) {
        Authority authority = this.authorityService.getAuthority(bl, principal, string);
        if (authority != null && !authority.hasFullPermission()) {
            throw new NoPermissionException();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.authorityService = (AuthorityService)applicationContext.getBeansOfType(AuthorityService.class).values().iterator().next();
        this.ve = new VelocityEngine();
        this.ve.setProperty("resource.loader", (Object)"class");
        this.ve.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        this.ve.setProperty("runtime.log.logsystem", (Object)new NullLogChute());
        this.ve.init();
    }
}

