/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.authority;

import com.bstek.urule.Utils;
import com.bstek.urule.console.EnvironmentUtils;
import com.bstek.urule.console.Principal;
import com.bstek.urule.console.exception.NoPermissionException;
import com.bstek.urule.console.repository.authority.AuthorityRepositoryService;
import com.bstek.urule.console.repository.authority.AuthorityService;
import com.bstek.urule.console.repository.authority.AuthorityUnit;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.console.servlet.RequestContext;
import com.bstek.urule.exception.RuleException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class AuthorityConfigServletHandler
extends RenderPageServletHandler {
    private AuthorityRepositoryService a;
    private AuthorityService b;
    private String c;

    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Principal principal = EnvironmentUtils.getEnvironmentProvider().getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            throw new NoPermissionException();
        }
        String string = this.retriveMethod(httpServletRequest);
        if (string != null) {
            this.invokeMethod(string, httpServletRequest, httpServletResponse);
        } else {
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/permission-config-editor.html", "utf-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
            printWriter.close();
        }
    }

    public void loadPrincipals(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        List<Principal> list = EnvironmentUtils.getEnvironmentProvider().getPrincipals();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("principals", list);
        hashMap.put("authorityType", this.c);
        this.writeObjectToJson(httpServletResponse, hashMap);
    }

    public void loadResourceSecurityConfigs(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse)).getCompanyId();
        try {
            List<Principal> list = EnvironmentUtils.getEnvironmentProvider().getPrincipals();
            List<AuthorityUnit> list2 = this.a.loadAuthorityUnits(string);
            ArrayList<AuthorityUnit> arrayList = new ArrayList<AuthorityUnit>();
            for (AuthorityUnit authorityUnit : list2) {
                String string2 = authorityUnit.getPrincipalName();
                boolean bl = false;
                for (Principal principal : list) {
                    if (!principal.getCompanyId().equals(string) || !string2.equals(principal.getName()) || !principal.isAdmin()) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(authorityUnit);
            }
            this.writeObjectToJson(httpServletResponse, arrayList);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    public void saveResourceSecurityConfigs(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        String string = principal.getCompanyId();
        String string2 = httpServletRequest.getParameter("xml");
        string2 = Utils.decodeURL((String)string2);
        try {
            long l = this.a.saveAuthoritiesFile(string2, principal);
            this.b.refreshAuthority(string);
            this.b.getAuthorityCache().resetTag(l);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    public void setAuthorityRepositoryService(AuthorityRepositoryService authorityRepositoryService) {
        this.a = authorityRepositoryService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.b = authorityService;
    }

    public void setAuthorityType(String string) {
        this.c = string;
    }

    @Override
    public String url() {
        return "/authority";
    }
}

