/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.complexscorecard;

import com.bstek.urule.console.repository.ProjectVariable;
import com.bstek.urule.console.repository.model.FileType;
import com.bstek.urule.console.servlet.complexscorecard.CellData;
import com.bstek.urule.console.servlet.complexscorecard.RowData;
import com.bstek.urule.console.servlet.complexscorecard.ScoreTableData;
import com.bstek.urule.console.servlet.complexscorecard.TableHeader;
import com.bstek.urule.dsl.DSLRuleSetBuilder;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.library.variable.Variable;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.model.rule.SimpleValue;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.VariableCategoryValue;
import com.bstek.urule.model.rule.VariableValue;
import com.bstek.urule.model.rule.lhs.Criteria;
import com.bstek.urule.model.rule.lhs.Criterion;
import com.bstek.urule.model.rule.lhs.Junction;
import com.bstek.urule.model.rule.lhs.Or;
import com.bstek.urule.model.scorecard.ComplexScorecardDefinition;
import com.bstek.urule.parse.deserializer.ComplexScorecardDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;

public class ComplexScoreTableBuilder {
    private ScoreTableData a;
    private DSLRuleSetBuilder b;
    private List<ProjectVariable> c;
    private ComplexScorecardDeserializer d;
    private List<String> e = new ArrayList<String>();

    public ComplexScoreTableBuilder(ScoreTableData scoreTableData, DSLRuleSetBuilder dSLRuleSetBuilder, List<ProjectVariable> list, ComplexScorecardDeserializer complexScorecardDeserializer) {
        this.a = scoreTableData;
        this.b = dSLRuleSetBuilder;
        this.c = list;
        this.d = complexScorecardDeserializer;
    }

    public ComplexScorecardDefinition buildTable() {
        try {
            String string = this.a();
            Document document = DocumentHelper.parseText((String)string);
            return this.d.deserialize(document.getRootElement());
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    private String a() throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuilder.append("<complex-scorecard scoring-type=\"sum\" assign-target-type=\"none\">");
        List<TableHeader> list = this.a.getHeaders();
        for (int i = 0; i < list.size(); ++i) {
            TableHeader tableHeader = list.get(i);
            String object2 = tableHeader.getName();
            if (tableHeader.isScore()) {
                stringBuilder.append("<col num=\"" + i + "\" width=\"120\" type=\"Score\"/>");
                continue;
            }
            stringBuilder.append("<col num=\"" + i + "\" width=\"120\" type=\"Criteria\" var-category=\"" + object2 + "\"/>");
        }
        List<RowData> list2 = this.a.getRows();
        for (n = 0; n < list2.size(); ++n) {
            stringBuilder.append("<row num=\"" + n + "\" height=\"40\"/>");
        }
        for (n = 0; n < list2.size(); ++n) {
            RowData rowData = list2.get(n);
            List<CellData> list3 = rowData.getCells();
            for (CellData cellData : list3) {
                Variable variable;
                TableHeader tableHeader = cellData.getHeader();
                String string = cellData.getContent();
                int n2 = cellData.getSpan();
                if (n2 == 0) {
                    n2 = 1;
                }
                stringBuilder.append("<cell row=\"" + cellData.getRow() + "\" col=\"" + cellData.getCol() + "\" rowspan=\"" + n2 + "\"");
                if (tableHeader.isScore()) {
                    stringBuilder.append(">");
                } else {
                    variable = this.a(tableHeader.getName(), cellData.getProperty());
                    stringBuilder.append(" var-label=\"" + variable.getLabel() + "\" var=\"" + variable.getName() + "\" datatype=\"" + variable.getDataType() + "\">");
                }
                if (StringUtils.isNotBlank((String)string)) {
                    if (tableHeader.isScore()) {
                        string = StringEscapeUtils.escapeXml((String)string);
                        stringBuilder.append("<value content=\"" + string + "\" type=\"Input\"/>");
                    } else {
                        variable = this.b.buildCriterion(string);
                        stringBuilder.append(this.a((Criterion)variable));
                    }
                }
                stringBuilder.append("</cell>");
            }
        }
        for (String string : this.e) {
            if (string.endsWith(FileType.VariableLibrary.toString())) {
                stringBuilder.append("<import-variable-library path=\"" + string + "\"/>");
                continue;
            }
            stringBuilder.append("<import-parameter-library path=\"" + string + "\"/>");
        }
        stringBuilder.append("</complex-scorecard>");
        return stringBuilder.toString();
    }

    private Variable a(String string, String string2) {
        for (ProjectVariable projectVariable : this.c) {
            List<VariableCategory> list = projectVariable.getVariableCategories();
            for (VariableCategory variableCategory : list) {
                List list2;
                if (!variableCategory.getName().equals(string)) continue;
                String string3 = "jcr:" + projectVariable.getPath();
                if (!this.e.contains(string3)) {
                    this.e.add(string3);
                }
                if ((list2 = variableCategory.getVariables()) == null) continue;
                for (Variable variable : list2) {
                    if (!variable.getLabel().equals(string2) && !variable.getName().equals(string2)) continue;
                    return variable;
                }
            }
        }
        throw new RuleException("\u53d8\u91cf[" + string + "." + string2 + "]\u5728\u5f53\u524d\u9879\u76ee\u4e2d\u672a\u5b9a\u4e49!");
    }

    private String a(Criterion criterion) {
        StringBuilder stringBuilder = new StringBuilder();
        if (criterion instanceof Junction) {
            Junction junction = (Junction)criterion;
            List list = junction.getCriterions();
            String string = "and";
            if (junction instanceof Or) {
                string = "or";
            }
            stringBuilder.append("<joint type=\"" + string + "\">");
            if (list != null) {
                for (Criterion criterion2 : list) {
                    if (!(criterion2 instanceof Criteria)) continue;
                    Criteria criteria = (Criteria)criterion2;
                    stringBuilder.append("<condition op=\"" + criteria.getOp().name() + "\">");
                    Value value = criteria.getValue();
                    String string2 = this.a(value);
                    if (string2 != null) {
                        stringBuilder.append(string2);
                    }
                    stringBuilder.append("</condition>");
                }
            }
        } else {
            stringBuilder.append("<joint type=\"and\">");
            Criteria criteria = (Criteria)criterion;
            stringBuilder.append("<condition op=\"" + criteria.getOp().name() + "\">");
            Value value = criteria.getValue();
            stringBuilder.append(this.a(value));
            stringBuilder.append("</condition>");
        }
        stringBuilder.append("</joint>");
        return stringBuilder.toString();
    }

    private String a(Value value) {
        String string;
        SimpleValue simpleValue;
        if (value == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (value instanceof SimpleValue) {
            simpleValue = (SimpleValue)value;
            string = StringEscapeUtils.escapeXml((String)simpleValue.getContent());
            stringBuilder.append("<value content=\"" + string + "\" type=\"Input\">");
        } else if (value instanceof VariableCategoryValue) {
            simpleValue = (VariableCategoryValue)value;
            string = simpleValue.getVariableCategory();
            String string2 = StringEscapeUtils.escapeXml((String)string);
            stringBuilder.append("<value content=\"" + string2 + "\" type=\"Input\">");
        } else if (value instanceof VariableValue) {
            simpleValue = (VariableValue)value;
            string = simpleValue.getVariableCategory() + "." + simpleValue.getVariableLabel();
            string = StringEscapeUtils.escapeXml((String)string);
            stringBuilder.append("<value content=\"" + string + "\" type=\"Input\">");
        } else {
            stringBuilder.append("<value content=\"\" type=\"Input\">");
        }
        simpleValue = value.getArithmetic();
        if (simpleValue == null) {
            stringBuilder.append("</value>");
            return stringBuilder.toString();
        }
        string = simpleValue.getType();
        stringBuilder.append("<complex-arith type=\"" + string.name() + "\">");
        stringBuilder.append(this.a(simpleValue.getValue()));
        stringBuilder.append("</complex-arith>");
        stringBuilder.append("</value>");
        return stringBuilder.toString();
    }
}

