/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.crosstab;

import com.bstek.urule.PropertyConfigurer;
import com.bstek.urule.Splash;
import com.bstek.urule.Utils;
import com.bstek.urule.console.EnvironmentUtils;
import com.bstek.urule.console.Principal;
import com.bstek.urule.console.repository.ProjectVariable;
import com.bstek.urule.console.repository.RepositoryService;
import com.bstek.urule.console.repository.model.FileType;
import com.bstek.urule.console.servlet.CellContent;
import com.bstek.urule.console.servlet.DesignerConfigure;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.console.servlet.RequestContext;
import com.bstek.urule.console.servlet.SessionStore;
import com.bstek.urule.console.servlet.common.CommonServletHandler;
import com.bstek.urule.console.servlet.crosstab.CrossColumn;
import com.bstek.urule.console.servlet.crosstab.CrossData;
import com.bstek.urule.console.servlet.crosstab.CrossHeader;
import com.bstek.urule.console.servlet.crosstab.CrossRow;
import com.bstek.urule.console.servlet.crosstab.CrossTableXmlBuilder;
import com.bstek.urule.console.servlet.crosstab.Span;
import com.bstek.urule.console.servlet.crosstab.Type;
import com.bstek.urule.dsl.DSLRuleSetBuilder;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.library.variable.CategoryType;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.parse.deserializer.CrosstableDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class CrosstabEditorServletHandler
extends RenderPageServletHandler {
    private RepositoryService a;
    private CommonServletHandler b;
    private CrosstableDeserializer c;
    private DSLRuleSetBuilder d;

    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.retriveMethod(httpServletRequest);
        if (string != null) {
            this.invokeMethod(string, httpServletRequest, httpServletResponse);
        } else {
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
            velocityContext.put("version", (Object)Splash.getVersion());
            velocityContext.put("constantLink", (Object)DesignerConfigure.constantLink);
            velocityContext.put("variableLink", (Object)DesignerConfigure.variableLink);
            velocityContext.put("_date_", (Object)_DATE);
            velocityContext.put("_lis_", (Object)Splash.getFetchVersion());
            String string2 = httpServletRequest.getParameter("file");
            String string3 = this.buildProjectNameFromFile(string2);
            if (string3 != null) {
                velocityContext.put("project", (Object)string3);
            }
            velocityContext.put("showFileExtensionName", (Object)PropertyConfigurer.getProperty((String)"urule.show.fileExtensionName"));
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/crosstab-editor.html", "utf-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
            printWriter.close();
        }
    }

    public void importExcel(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            ProjectVariable projectVariable;
            Object object;
            Object object2;
            Object object3;
            String string = httpServletRequest.getParameter("project");
            string = Utils.decodeURL((String)string);
            DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
            ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
            List list = servletFileUpload.parseRequest(httpServletRequest);
            Iterator iterator = list.iterator();
            CrossData crossData = null;
            while (iterator.hasNext()) {
                object3 = (FileItem)iterator.next();
                object2 = object3.getFieldName();
                if (!((String)object2).equals("excel_file")) continue;
                object = object3.getInputStream();
                crossData = this.a((InputStream)object);
                ((InputStream)object).close();
                break;
            }
            if (crossData == null) {
                throw new RuleException("\u8bf7\u4e0a\u4f20\u4e00\u4e2aExcel\u6587\u4ef6\uff01");
            }
            object3 = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
            object2 = this.a.loadProjectLibraries(string, (Principal)object3);
            object = object2.iterator();
            while (object.hasNext()) {
                projectVariable = (ProjectVariable)object.next();
                String string2 = projectVariable.getPath();
                Object object4 = this.b.buildData(string2).get(0);
                if (string2.endsWith(FileType.ParameterLibrary.toString())) {
                    List list2 = (List)object4;
                    ArrayList<VariableCategory> arrayList = new ArrayList<VariableCategory>();
                    VariableCategory variableCategory = new VariableCategory();
                    variableCategory.setClazz(HashMap.class.getName());
                    variableCategory.setName("\u53c2\u6570");
                    variableCategory.setType(CategoryType.Clazz);
                    variableCategory.setVariables(list2);
                    arrayList.add(variableCategory);
                    projectVariable.setVariableCategories(arrayList);
                    continue;
                }
                projectVariable.setVariableCategories((List)object4);
            }
            object = new CrossTableXmlBuilder(crossData, this.c, (List<ProjectVariable>)object2, this.d);
            projectVariable = ((CrossTableXmlBuilder)object).doBuild();
            SessionStore.setAttribute("_import_data_", projectVariable);
            hashMap.put("fail", false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = this.buildErrorMsg(exception);
            hashMap.put("fail", true);
            hashMap.put("msg", string);
        }
        this.writeObjectToJson(httpServletResponse, hashMap);
    }

    private CrossData a(InputStream inputStream) throws Exception {
        Object object;
        XSSFCell xSSFCell;
        String string;
        CrossRow crossRow;
        XSSFRow xSSFRow;
        int n;
        XSSFWorkbook xSSFWorkbook = new XSSFWorkbook(inputStream);
        if (xSSFWorkbook.getNumberOfSheets() == 0) {
            xSSFWorkbook.close();
            throw new RuleException("\u5bfc\u5165Excel\u4e0d\u5408\u6cd5\uff01");
        }
        ArrayList<CrossRow> arrayList = new ArrayList<CrossRow>();
        ArrayList<CrossColumn> arrayList2 = new ArrayList<CrossColumn>();
        XSSFSheet xSSFSheet = xSSFWorkbook.getSheetAt(0);
        CrossHeader crossHeader = this.a(xSSFSheet);
        XSSFRow xSSFRow2 = xSSFSheet.getRow(0);
        int n2 = xSSFRow2.getLastCellNum();
        XSSFRow xSSFRow3 = xSSFSheet.getRow(crossHeader.getRowSpan());
        for (n = 0; n < n2; ++n) {
            CrossColumn crossColumn = new CrossColumn();
            crossColumn.setNumber(n + 1);
            if (n < crossHeader.getColSpan()) {
                crossColumn.setType(Type.left);
                xSSFRow = xSSFRow3.getCell(n);
                crossRow = xSSFRow.getCellComment();
                if (crossRow != null) {
                    string = crossRow.getString().toString().toLowerCase().trim();
                    crossColumn.setContent(string);
                }
            } else {
                crossColumn.setType(Type.top);
            }
            arrayList2.add(crossColumn);
        }
        n = xSSFSheet.getLastRowNum();
        for (int i = 0; i <= n; ++i) {
            xSSFRow = xSSFSheet.getRow(i);
            crossRow = new CrossRow();
            crossRow.setNumber(i + 1);
            if (i < crossHeader.getRowSpan()) {
                crossRow.setType(Type.top);
                string = xSSFRow.getCell(crossHeader.getColSpan());
                xSSFCell = string.getCellComment();
                if (xSSFCell != null) {
                    object = xSSFCell.getString().toString().toLowerCase().trim();
                    crossRow.setContent((String)object);
                }
            } else {
                crossRow.setType(Type.left);
            }
            arrayList.add(crossRow);
        }
        ArrayList<CellContent> arrayList3 = new ArrayList<CellContent>();
        for (int i = 0; i <= n; ++i) {
            crossRow = xSSFSheet.getRow(i);
            for (int j = 0; j < n2; ++j) {
                if (i == 0 && j == 0 || (xSSFCell = crossRow.getCell(j)) == null || (object = this.a(i, j, xSSFSheet)) == null) continue;
                String string2 = this.a(xSSFCell);
                CellContent cellContent = new CellContent();
                cellContent.setCol(j + 1);
                cellContent.setRow(i + 1);
                cellContent.setContent(string2);
                if (i < crossHeader.getRowSpan()) {
                    cellContent.setType("condition");
                    cellContent.setSpan(((Span)object).getCol());
                }
                if (j < crossHeader.getColSpan()) {
                    cellContent.setType("condition");
                    cellContent.setSpan(((Span)object).getRow());
                }
                arrayList3.add(cellContent);
            }
        }
        xSSFWorkbook.close();
        CrossData crossData = new CrossData();
        crossData.setCells(arrayList3);
        crossData.setColumns(arrayList2);
        crossData.setRows(arrayList);
        crossData.setHeader(crossHeader);
        return crossData;
    }

    private CrossHeader a(XSSFSheet xSSFSheet) {
        Span span = this.a(0, 0, xSSFSheet);
        if (span == null) {
            throw new RuleException("\u5bfc\u5165\u7684Excel\u4e0d\u5408\u6cd5!");
        }
        CrossHeader crossHeader = new CrossHeader();
        crossHeader.setRowSpan(span.getRow());
        crossHeader.setColSpan(span.getCol());
        XSSFRow xSSFRow = xSSFSheet.getRow(0);
        XSSFCell xSSFCell = xSSFRow.getCell(0);
        crossHeader.setContent(this.a(xSSFCell));
        return crossHeader;
    }

    private Span a(int n, int n2, XSSFSheet xSSFSheet) {
        List list = xSSFSheet.getMergedRegions();
        for (CellRangeAddress cellRangeAddress : list) {
            if (cellRangeAddress.getFirstColumn() == n2 && cellRangeAddress.getFirstRow() == n) {
                int n3 = cellRangeAddress.getLastRow() - cellRangeAddress.getFirstRow();
                if (n3 > 0) {
                    ++n3;
                }
                Span span = new Span();
                span.setRow(n3);
                int n4 = cellRangeAddress.getLastColumn() - cellRangeAddress.getFirstColumn();
                if (n4 > 0) {
                    ++n4;
                }
                span.setCol(n4);
                return span;
            }
            if (n2 < cellRangeAddress.getFirstColumn() || n2 > cellRangeAddress.getLastColumn() || n < cellRangeAddress.getFirstRow() || n > cellRangeAddress.getLastRow()) continue;
            return null;
        }
        Span span = new Span();
        span.setRow(1);
        span.setCol(1);
        return span;
    }

    private String a(XSSFCell xSSFCell) {
        String string = null;
        CellType cellType = xSSFCell.getCellTypeEnum();
        switch (cellType) {
            case STRING: {
                string = xSSFCell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                string = String.valueOf(xSSFCell.getBooleanCellValue());
                break;
            }
            case NUMERIC: {
                xSSFCell.setCellType(CellType.STRING);
                string = xSSFCell.getStringCellValue();
                break;
            }
        }
        return string;
    }

    public void setCommonServletHandler(CommonServletHandler commonServletHandler) {
        this.b = commonServletHandler;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.a = repositoryService;
    }

    public void setCrosstableDeserializer(CrosstableDeserializer crosstableDeserializer) {
        this.c = crosstableDeserializer;
    }

    public void setDslRuleSetBuilder(DSLRuleSetBuilder dSLRuleSetBuilder) {
        this.d = dSLRuleSetBuilder;
    }

    @Override
    public String url() {
        return "/crosstabeditor";
    }
}

