/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.decisiontree;

import com.bstek.urule.PropertyConfigurer;
import com.bstek.urule.Splash;
import com.bstek.urule.console.servlet.DesignerConfigure;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.console.servlet.SessionStore;
import com.bstek.urule.model.decisiontree.VariableTreeNode;
import com.bstek.urule.parse.decisiontree.ActionTreeNodeParser;
import com.bstek.urule.parse.decisiontree.ConditionTreeNodeParser;
import com.bstek.urule.parse.decisiontree.VariableTreeNodeParser;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DecisionTreeEditorServletHandler
extends RenderPageServletHandler {
    public static final String EDITOR_STYLE = "_decision_editor_style";
    public static final String DIAGRAM_EDITOR = "diagram";
    public static final String TREE_EDITOR = "tree";
    public static final String DECISION_TREE_DATA = "_decision_tree_data";
    private VariableTreeNodeParser a;
    private ConditionTreeNodeParser b;
    private ActionTreeNodeParser c;

    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.retriveMethod(httpServletRequest);
        if (string != null) {
            this.invokeMethod(string, httpServletRequest, httpServletResponse);
        } else {
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
            velocityContext.put("version", (Object)Splash.getVersion());
            velocityContext.put("constantLink", (Object)DesignerConfigure.constantLink);
            velocityContext.put("variableLink", (Object)DesignerConfigure.variableLink);
            velocityContext.put("_date_", (Object)_DATE);
            velocityContext.put("_lis_", (Object)Splash.getFetchVersion());
            String string2 = httpServletRequest.getParameter("file");
            String string3 = this.buildProjectNameFromFile(string2);
            if (string3 != null) {
                velocityContext.put("project", (Object)string3);
            }
            String string4 = this.a(httpServletRequest);
            Cookie cookie = new Cookie(EDITOR_STYLE, string4);
            cookie.setMaxAge(311040000);
            httpServletResponse.addCookie(cookie);
            velocityContext.put("editorStyle", (Object)string4);
            velocityContext.put("showFileExtensionName", (Object)PropertyConfigurer.getProperty((String)"urule.show.fileExtensionName"));
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setCharacterEncoding("utf-8");
            Template template = null;
            template = string4.equals(DIAGRAM_EDITOR) ? this.ve.getTemplate("html/decisiontree-editor.html", "utf-8") : this.ve.getTemplate("html/decisiontree-tree-editor.html", "utf-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
            printWriter.close();
        }
    }

    public void parseTreeNode(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("xml");
        Document document = DocumentHelper.parseText((String)string);
        Element element = document.getRootElement();
        if (this.a.support(element.getName())) {
            VariableTreeNode variableTreeNode = this.a.parse(element);
            SessionStore.setAttribute(DECISION_TREE_DATA, variableTreeNode);
        } else if (this.b.support(element.getName())) {
            SessionStore.setAttribute(DECISION_TREE_DATA, this.b.parse(element));
        } else if (this.c.support(element.getName())) {
            SessionStore.setAttribute(DECISION_TREE_DATA, this.c.parse(element));
        }
    }

    public void loadTreeNode(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object = SessionStore.getAttribute(DECISION_TREE_DATA);
        this.writeObjectToJson(httpServletResponse, object);
    }

    private String a(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("editor");
        if (StringUtils.isNotBlank((String)string)) {
            return string;
        }
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null) {
            return DIAGRAM_EDITOR;
        }
        for (Cookie cookie : cookieArray) {
            String string2 = cookie.getName();
            if (!EDITOR_STYLE.equals(string2)) continue;
            string = cookie.getValue();
        }
        if (string != null) {
            return string;
        }
        return DIAGRAM_EDITOR;
    }

    public void setVariableTreeNodeParser(VariableTreeNodeParser variableTreeNodeParser) {
        this.a = variableTreeNodeParser;
    }

    public void setActionTreeNodeParser(ActionTreeNodeParser actionTreeNodeParser) {
        this.c = actionTreeNodeParser;
    }

    public void setConditionTreeNodeParser(ConditionTreeNodeParser conditionTreeNodeParser) {
        this.b = conditionTreeNodeParser;
    }

    @Override
    public String url() {
        return "/decisiontreeeditor";
    }
}

