/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.diagram;

import com.bstek.urule.Utils;
import com.bstek.urule.builder.KnowledgeBase;
import com.bstek.urule.builder.KnowledgeBuilder;
import com.bstek.urule.builder.ResourceBase;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.console.servlet.diagram.Box;
import com.bstek.urule.console.servlet.diagram.Diagram;
import com.bstek.urule.console.servlet.diagram.DiagramContext;
import com.bstek.urule.console.servlet.diagram.Edge;
import com.bstek.urule.console.servlet.diagram.NodeInfo;
import com.bstek.urule.console.servlet.diagram.ReteNodeLayout;
import com.bstek.urule.model.Node;
import com.bstek.urule.model.rete.AndNode;
import com.bstek.urule.model.rete.CriteriaNode;
import com.bstek.urule.model.rete.Line;
import com.bstek.urule.model.rete.OrNode;
import com.bstek.urule.model.rete.Rete;
import com.bstek.urule.model.rete.TerminalNode;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class ReteDiagramServletHandler
extends RenderPageServletHandler {
    private KnowledgeBuilder a;
    private ReteNodeLayout b = new ReteNodeLayout();
    private final int c = 30;
    private final int d = 30;

    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.retriveMethod(httpServletRequest);
        if (string != null) {
            this.invokeMethod(string, httpServletRequest, httpServletResponse);
        } else {
            httpServletResponse.setDateHeader("Expires", -1L);
            httpServletResponse.setHeader("Cache-Control", "no-cache");
            httpServletResponse.setHeader("Pragma", "no-cache");
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
            velocityContext.put("files", (Object)httpServletRequest.getParameter("files"));
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/rete-diagram.html", "utf-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
            printWriter.close();
        }
    }

    public void loadReteDiagramData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        KnowledgeBase knowledgeBase;
        String string = httpServletRequest.getParameter("files");
        string = Utils.decodeURL((String)string);
        ResourceBase resourceBase = this.a.newResourceBase();
        for (String string2 : knowledgeBase = string.split(";")) {
            String[] stringArray = string2.split(",");
            string2 = stringArray[0];
            String string3 = stringArray[1];
            string2 = Utils.toUTF8((String)string2);
            resourceBase.addResource(string2, string3);
        }
        KnowledgeBase knowledgeBase2 = this.a.buildKnowledgeBase(resourceBase);
        Rete rete = knowledgeBase2.getRete();
        Diagram diagram = this.a(rete);
        this.writeObjectToJson(httpServletResponse, diagram);
    }

    private Diagram a(Rete rete) {
        Object object2;
        HashMap<Node, NodeInfo> hashMap = new HashMap<Node, NodeInfo>();
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        NodeInfo nodeInfo = new NodeInfo();
        DiagramContext diagramContext = new DiagramContext(arrayList, hashMap);
        nodeInfo.setId(diagramContext.nextId());
        nodeInfo.setLabel("\u5165\u53e3");
        nodeInfo.setColor("#98AFC7");
        nodeInfo.setWidth(30);
        nodeInfo.setHeight(30);
        nodeInfo.setRoundCorner(10);
        List list = rete.getObjectTypeNodes();
        int n = 1;
        for (Object object2 : list) {
            NodeInfo nodeInfo2 = new NodeInfo();
            nodeInfo2.setId(diagramContext.nextId());
            nodeInfo2.setLabel("T");
            String string = object2.getObjectTypeClass();
            if (string.equals("__*__")) {
                nodeInfo2.setTitle("\u5426\u5219");
            } else {
                nodeInfo2.setTitle(string);
            }
            nodeInfo2.setColor("#97CBFF");
            nodeInfo2.setLevel(n);
            nodeInfo2.setWidth(30);
            nodeInfo2.setHeight(30);
            nodeInfo2.setRoundCorner(5);
            nodeInfo.addChild(nodeInfo2);
            List list2 = object2.getLines();
            if (list2 == null) continue;
            int n2 = n + 1;
            for (Line line : list2) {
                Edge edge = new Edge(nodeInfo.getId(), nodeInfo2.getId());
                arrayList.add(edge);
                this.a(line, diagramContext, nodeInfo2, n2);
            }
        }
        Box box = this.b.layout(nodeInfo);
        object2 = new Diagram(arrayList, nodeInfo);
        if (box != null) {
            ((Diagram)object2).setWidth(box.getWidth() + 500);
            ((Diagram)object2).setHeight(box.getHeight() + 300);
        }
        return object2;
    }

    private void a(Line line, DiagramContext diagramContext, NodeInfo nodeInfo, int n) {
        CriteriaNode criteriaNode;
        Node node = line.getTo();
        if (node == null) {
            return;
        }
        Map<Node, NodeInfo> map = diagramContext.getNodeMap();
        NodeInfo nodeInfo2 = null;
        if (map.containsKey(node)) {
            nodeInfo2 = map.get(node);
            diagramContext.addEdge(new Edge(nodeInfo.getId(), nodeInfo2.getId()));
            return;
        }
        List list = null;
        nodeInfo2 = new NodeInfo();
        nodeInfo2.setLevel(n);
        nodeInfo2.setId(diagramContext.nextId());
        nodeInfo2.setWidth(30);
        nodeInfo2.setHeight(30);
        if (node instanceof CriteriaNode) {
            criteriaNode = (CriteriaNode)node;
            nodeInfo2.setColor("#B3D9D9");
            nodeInfo2.setLabel("C");
            nodeInfo2.setTitle(criteriaNode.getCriteriaInfo());
            nodeInfo2.setRoundCorner(30);
            list = criteriaNode.getLines();
        } else if (node instanceof AndNode) {
            criteriaNode = (AndNode)node;
            list = criteriaNode.getLines();
            nodeInfo2.setColor("#DAB1D5");
            nodeInfo2.setLabel("AND");
            nodeInfo2.setRoundCorner(15);
        } else if (node instanceof OrNode) {
            criteriaNode = (OrNode)node;
            list = criteriaNode.getLines();
            nodeInfo2.setColor("#82D900");
            nodeInfo2.setLabel("OR");
            nodeInfo2.setRoundCorner(15);
        } else if (node instanceof TerminalNode) {
            criteriaNode = (TerminalNode)node;
            nodeInfo2.setColor("orange");
            nodeInfo2.setLabel(criteriaNode.getRule().getName());
            nodeInfo2.setTitle(criteriaNode.getRule().getName());
            nodeInfo2.setRoundCorner(0);
        }
        map.put(node, nodeInfo2);
        nodeInfo.addChild(nodeInfo2);
        diagramContext.addEdge(new Edge(nodeInfo.getId(), nodeInfo2.getId()));
        if (list == null) {
            return;
        }
        int n2 = n + 1;
        for (Line line2 : list) {
            this.a(line2, diagramContext, nodeInfo2, n2);
        }
    }

    public void setKnowledgeBuilder(KnowledgeBuilder knowledgeBuilder) {
        this.a = knowledgeBuilder;
    }

    @Override
    public String url() {
        return "/retediagram";
    }
}

