/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.dynamic;

import com.bstek.urule.Splash;
import com.bstek.urule.Utils;
import com.bstek.urule.console.EnvironmentUtils;
import com.bstek.urule.console.Principal;
import com.bstek.urule.console.exception.NoPermissionException;
import com.bstek.urule.console.repository.ClientConfig;
import com.bstek.urule.console.repository.RepositoryService;
import com.bstek.urule.console.repository.dynamic.DynamicFile;
import com.bstek.urule.console.repository.dynamic.DynamicJarRepositoryService;
import com.bstek.urule.console.repository.model.RepositoryFile;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.console.servlet.RequestContext;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.runtime.DynamicSpringConfigLoader;
import com.bstek.urule.runtime.RemoteDynamicJarsBuilder;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class DynamicJarsServletHandler
extends RenderPageServletHandler {
    private DynamicJarRepositoryService a;
    private DynamicSpringConfigLoader b;
    private RepositoryService c;
    private RemoteDynamicJarsBuilder d;

    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.retriveMethod(httpServletRequest);
        if (string != null) {
            this.invokeMethod(string, httpServletRequest, httpServletResponse);
        } else {
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
            velocityContext.put("version", (Object)Splash.getVersion());
            velocityContext.put("_date_", (Object)_DATE);
            velocityContext.put("_lis_", (Object)Splash.getFetchVersion());
            String string2 = httpServletRequest.getParameter("file");
            String string3 = this.buildProjectNameFromFile(string2);
            if (string3 != null) {
                velocityContext.put("project", (Object)string3);
            }
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/dynamic.html", "utf-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
            printWriter.close();
        }
    }

    public void checkLatestJarsDir(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!this.validateUserPwd(httpServletRequest, this.d.getUser(), this.d.getPwd())) {
            return;
        }
        String string = "n";
        String string2 = this.b.getDynamicJarsStoreDirectDirName();
        if (string2 != null) {
            string = string2;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string3 = httpServletRequest.getParameter("dirName");
        hashMap.put("dir", string);
        if (string3 == null) {
            hashMap.put("match", false);
        } else {
            hashMap.put("match", string3.equals(string));
        }
        this.writeObjectToJson(httpServletResponse, hashMap);
    }

    public void loadDynamicJars(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!this.validateUserPwd(httpServletRequest, this.d.getUser(), this.d.getPwd())) {
            return;
        }
        String string = this.b.getDynamicJarsStoreDirectPath();
        if (string == null) {
            throw new RuleException("Current jars dir not exist.");
        }
        byte[] byArray = this.a();
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)servletOutputStream);
        dataOutputStream.write(byArray);
        dataOutputStream.flush();
        dataOutputStream.close();
        IOUtils.closeQuietly((OutputStream)servletOutputStream);
    }

    public void downloadJar(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            throw new NoPermissionException();
        }
        String string = httpServletRequest.getParameter("path");
        String string2 = httpServletRequest.getParameter("jarName");
        InputStream inputStream = this.a.loadJar(string, string2);
        httpServletResponse.setContentType("application/octet-stream");
        httpServletResponse.setCharacterEncoding("utf-8");
        String string3 = URLEncoder.encode(string2, "utf-8");
        httpServletResponse.setHeader("Content-Disposition", "attachment; filename=" + string3 + "");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        IOUtils.copy((InputStream)inputStream, (OutputStream)servletOutputStream);
        servletOutputStream.flush();
        servletOutputStream.close();
        inputStream.close();
    }

    public void sendJarsToClients(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            throw new NoPermissionException();
        }
        String string = httpServletRequest.getParameter("client");
        byte[] byArray = this.a();
        List<ClientConfig> list = this.b();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (ClientConfig clientConfig : list) {
            Map<String, Object> map;
            String string2 = clientConfig.getClient();
            if (StringUtils.isNotBlank((String)string)) {
                if (!string2.equals(string)) continue;
                map = this.a(byArray, clientConfig);
                arrayList.add(map);
                break;
            }
            map = this.a(byArray, clientConfig);
            arrayList.add(map);
        }
        this.writeObjectToJson(httpServletResponse, arrayList);
    }

    private Map<String, Object> a(byte[] byArray, ClientConfig clientConfig) {
        String string = clientConfig.getClient();
        String string2 = this.a(byArray, string);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string2 != null) {
            hashMap.put("resultMsg", "<div style='color:red;word-wrap:break-word'>" + string2 + "</div>");
        }
        hashMap.put("url", clientConfig.getClient());
        hashMap.put("name", clientConfig.getName());
        return hashMap;
    }

    private byte[] a() throws IOException, FileNotFoundException {
        String string = this.b.getDynamicJarsStoreDirectPath();
        if (string == null) {
            throw new RuleException("Current jars dir not exist.");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
        File file = new File(string);
        for (File file2 : file.listFiles()) {
            zipOutputStream.putNextEntry(new ZipEntry(file2.getName()));
            FileInputStream fileInputStream = new FileInputStream(file2);
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
        zipOutputStream.finish();
        zipOutputStream.flush();
        zipOutputStream.closeEntry();
        zipOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String a(byte[] byArray, String string) {
        String string2;
        HttpURLConnection httpURLConnection = null;
        try {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            String string3 = this.d.getUser();
            string2 = this.d.getPwd();
            String string4 = "_u=" + URLEncoder.encode(string3, "utf-8");
            string4 = string4 + "&_p=" + URLEncoder.encode(string2, "utf-8");
            string4 = string4 + "&dynamicjars=true";
            String string5 = string + "/knowledgepackagereceiver" + "?" + string4;
            URL uRL = new URL(string5);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.setRequestProperty("Accept-Charset", "utf-8");
            httpURLConnection.setRequestProperty("Content-Type", "text/json");
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.connect();
            OutputStream outputStream = httpURLConnection.getOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            dataOutputStream.write(byArray);
            dataOutputStream.flush();
            dataOutputStream.close();
            InputStream inputStream = httpURLConnection.getInputStream();
            String string6 = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            outputStream.close();
            inputStream.close();
            if (string6.equals("ok")) {
                String string7 = null;
                return string7;
            }
            String string8 = "<strong>\u63a8\u9001\u64cd\u4f5c\u6210\u529f\u5230\u8fbe\u5ba2\u6237\u7aef\uff0c\u4f46\u5ba2\u6237\u7aef\u51fa\u9519\u9519\u8bef\uff1a</strong><br>" + string6;
            return string8;
        }
        catch (Exception exception) {
            string2 = "<strong>\u670d\u52a1\u7aef\u63a8\u9001\u64cd\u4f5c\u51fa\u73b0\u9519\u8bef\uff1a</strong><br>" + this.a(exception);
            return string2;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private String a(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        String string = new String(byteArrayOutputStream.toByteArray());
        IOUtils.closeQuietly((OutputStream)printStream);
        IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
        string = string.replaceAll("\n", "<br>");
        return string;
    }

    public void deployJars(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            throw new NoPermissionException();
        }
        boolean bl = false;
        String string = this.b.buildDynamicJarsStoreDirectPath();
        List<DynamicFile> list = this.a.loadFiles();
        for (DynamicFile object : list) {
            if (object.getJars().size() > 0) {
                bl = true;
            }
            this.a.generateJars(object.getPath(), string);
        }
        HashMap hashMap = new HashMap();
        hashMap.put("exist", bl);
        if (bl) {
            this.b.loadDynamicJars(string);
            List<ClientConfig> list2 = this.b();
            hashMap.put("clients", list2);
        }
        this.writeObjectToJson(httpServletResponse, hashMap);
    }

    private List<ClientConfig> b() throws Exception {
        ArrayList<ClientConfig> arrayList = new ArrayList<ClientConfig>();
        List<RepositoryFile> list = this.c.loadProjects(null);
        for (RepositoryFile repositoryFile : list) {
            String string = repositoryFile.getName();
            List<ClientConfig> list2 = this.c.loadClientConfigs(string, false);
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public void removeFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            throw new NoPermissionException();
        }
        String string = httpServletRequest.getParameter("path");
        this.a.removeFile(string);
    }

    public void removeJar(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            throw new NoPermissionException();
        }
        String string = httpServletRequest.getParameter("path");
        String string2 = httpServletRequest.getParameter("jarName");
        this.a.removeJar(string, string2);
    }

    public void addJar(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            throw new NoPermissionException();
        }
        try {
            int n;
            Object object;
            DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
            ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
            List list = servletFileUpload.parseRequest(httpServletRequest);
            InputStream inputStream = null;
            String string = null;
            for (FileItem fileItem : list) {
                object = fileItem.getFieldName();
                if (!((String)object).equals("jar_file")) continue;
                string = fileItem.getName();
                inputStream = fileItem.getInputStream();
                break;
            }
            if ((n = string.lastIndexOf("\\")) > 0) {
                string = string.substring(n + 1, string.length());
            }
            object = new HashMap();
            String string2 = httpServletRequest.getParameter("path");
            string2 = Utils.decodeURL((String)string2);
            if (string.endsWith(".jar")) {
                this.a.addJar(string2, string, inputStream);
                object.put("jarName", string);
            } else {
                object.put("error", "\u8bf7\u9009\u62e9\u4e00\u4e2aJar\u6587\u4ef6\u4e0a\u4f20\uff01");
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            this.writeObjectToJson(httpServletResponse, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = exception.getMessage() == null ? NullPointerException.class.getName() : exception.getMessage();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("error", string);
            this.writeObjectToJson(httpServletResponse, hashMap);
        }
    }

    public void saveFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            throw new NoPermissionException();
        }
        String string = httpServletRequest.getParameter("name");
        String string2 = httpServletRequest.getParameter("comment");
        DynamicFile dynamicFile = new DynamicFile();
        dynamicFile.setName(string);
        dynamicFile.setComment(string2);
        dynamicFile.setCreateUser(principal.getName());
        this.a.saveFile(dynamicFile);
    }

    public void loadFiles(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            throw new NoPermissionException();
        }
        List<DynamicFile> list = this.a.loadFiles();
        this.writeObjectToJson(httpServletResponse, list);
    }

    public void check(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        boolean bl = false;
        List<DynamicFile> list = this.a.loadFiles();
        for (DynamicFile dynamicFile : list) {
            if (dynamicFile.getJars().size() <= 0) continue;
            bl = true;
            break;
        }
        HashMap hashMap = new HashMap();
        hashMap.put("exist", bl);
        this.writeObjectToJson(httpServletResponse, hashMap);
    }

    @Override
    public boolean anonymousAccess() {
        return true;
    }

    public void setDynamicJarRepositoryService(DynamicJarRepositoryService dynamicJarRepositoryService) {
        this.a = dynamicJarRepositoryService;
    }

    public void setDynamicSpringConfigLoader(DynamicSpringConfigLoader dynamicSpringConfigLoader) {
        this.b = dynamicSpringConfigLoader;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.c = repositoryService;
    }

    public void setRemoteDynamicJarsBuilder(RemoteDynamicJarsBuilder remoteDynamicJarsBuilder) {
        this.d = remoteDynamicJarsBuilder;
    }

    @Override
    public String url() {
        return "/dynamic";
    }
}

