/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.flow;

import com.bstek.urule.PropertyConfigurer;
import com.bstek.urule.Splash;
import com.bstek.urule.Utils;
import com.bstek.urule.console.repository.KnowledgePackageRepositoryService;
import com.bstek.urule.console.repository.RepositoryService;
import com.bstek.urule.console.repository.model.ResourcePackage;
import com.bstek.urule.console.servlet.DesignerConfigure;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.console.servlet.flow.FlowDefinitionWrapper;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.flow.FlowDefinition;
import com.bstek.urule.model.flow.ProcessDefinition;
import com.bstek.urule.model.rule.lhs.Lhs;
import com.bstek.urule.parse.ActionParser;
import com.bstek.urule.parse.LhsParser;
import com.bstek.urule.parse.deserializer.FlowDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class RuleFlowDesignerServletHandler
extends RenderPageServletHandler {
    private RepositoryService a;
    private KnowledgePackageRepositoryService b;
    private FlowDeserializer c;
    private LhsParser d;
    private Collection<ActionParser> e;

    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.retriveMethod(httpServletRequest);
        if (string != null) {
            this.invokeMethod(string, httpServletRequest, httpServletResponse);
        } else {
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
            velocityContext.put("version", (Object)Splash.getVersion());
            velocityContext.put("constantLink", (Object)DesignerConfigure.constantLink);
            velocityContext.put("variableLink", (Object)DesignerConfigure.variableLink);
            velocityContext.put("_date_", (Object)_DATE);
            velocityContext.put("_lis_", (Object)Splash.getFetchVersion());
            String string2 = httpServletRequest.getParameter("file");
            String string3 = this.buildProjectNameFromFile(string2);
            if (string3 != null) {
                velocityContext.put("project", (Object)string3);
            }
            velocityContext.put("showFileExtensionName", (Object)PropertyConfigurer.getProperty((String)"urule.show.fileExtensionName"));
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/rule-flow-designer.html", "utf-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
            printWriter.close();
        }
    }

    public void loadFlowDefinition(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("file");
        String string2 = httpServletRequest.getParameter("version");
        string = Utils.decodeURL((String)string);
        try {
            InputStream inputStream = StringUtils.isEmpty((String)string2) ? this.a.readFile(string, null) : this.a.readFile(string, string2);
            Element element = this.parseXml(inputStream);
            FlowDefinition flowDefinition = this.c.deserialize(element);
            inputStream.close();
            this.writeObjectToJson(httpServletResponse, new FlowDefinitionWrapper((ProcessDefinition)flowDefinition));
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    public void parseJoint(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("content");
        string = Utils.decodeContent((String)string);
        Element element = this.parseXml(string);
        Lhs lhs = this.d.parse(element);
        this.writeObjectToJson(httpServletResponse, lhs);
    }

    public void parseActions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("content");
        string = Utils.decodeContent((String)string);
        Element element = this.parseXml(string);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block0: for (Object e : element.elements()) {
            if (e == null || !(e instanceof Element)) continue;
            Element element2 = (Element)e;
            String string2 = element2.getName();
            for (ActionParser actionParser : this.e) {
                if (!actionParser.support(string2)) continue;
                arrayList.add(actionParser.parse(element2));
                continue block0;
            }
        }
        this.writeObjectToJson(httpServletResponse, arrayList);
    }

    protected Element parseXml(String string) {
        try {
            Document document = DocumentHelper.parseText((String)string);
            Element element = document.getRootElement();
            return element;
        }
        catch (DocumentException documentException) {
            throw new RuleException((Exception)((Object)documentException));
        }
    }

    protected Element parseXml(InputStream inputStream) {
        SAXReader sAXReader = new SAXReader();
        try {
            Document document = sAXReader.read(inputStream);
            Element element = document.getRootElement();
            return element;
        }
        catch (DocumentException documentException) {
            throw new RuleException((Exception)((Object)documentException));
        }
    }

    public void loadPackages(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("project");
        try {
            List<ResourcePackage> list = this.b.loadProjectResourcePackages(string);
            ArrayList<ResourcePackage> arrayList = new ArrayList<ResourcePackage>();
            for (ResourcePackage resourcePackage : list) {
                if (!resourcePackage.isCheck()) continue;
                arrayList.add(resourcePackage);
            }
            this.writeObjectToJson(httpServletResponse, arrayList);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    public void setLhsParser(LhsParser lhsParser) {
        this.d = lhsParser;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.a = repositoryService;
    }

    public void setKnowledgePackageRepositoryService(KnowledgePackageRepositoryService knowledgePackageRepositoryService) {
        this.b = knowledgePackageRepositoryService;
    }

    public void setFlowDeserializer(FlowDeserializer flowDeserializer) {
        this.c = flowDeserializer;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        this.e = applicationContext.getBeansOfType(ActionParser.class).values();
    }

    @Override
    public String url() {
        return "/ruleflowdesigner";
    }
}

