/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.frame;

import com.bstek.urule.PropertyConfigurer;
import com.bstek.urule.Splash;
import com.bstek.urule.Utils;
import com.bstek.urule.console.EnvironmentUtils;
import com.bstek.urule.console.Principal;
import com.bstek.urule.console.exception.NoPermissionException;
import com.bstek.urule.console.repository.DirectoryDuplicator;
import com.bstek.urule.console.repository.KnowledgePackageRepositoryService;
import com.bstek.urule.console.repository.Repository;
import com.bstek.urule.console.repository.RepositoryService;
import com.bstek.urule.console.repository.model.FileType;
import com.bstek.urule.console.repository.model.RepositoryFile;
import com.bstek.urule.console.repository.model.ResourceItem;
import com.bstek.urule.console.repository.model.ResourcePackage;
import com.bstek.urule.console.repository.model.Type;
import com.bstek.urule.console.repository.model.VersionFile;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.console.servlet.RequestContext;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.runtime.cache.CacheUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class FrameServletHandler
extends RenderPageServletHandler {
    private RepositoryService a;
    private DirectoryDuplicator b;
    private KnowledgePackageRepositoryService c;
    private String d;
    private String e;
    private String f = "URule Pro Console";
    private boolean g;
    private static final String h = "_lib_classify";

    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.retriveMethod(httpServletRequest);
        if (string != null) {
            this.invokeMethod(string, httpServletRequest, httpServletResponse);
        } else {
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
            velocityContext.put("version", (Object)Splash.getVersion());
            velocityContext.put("_date_", (Object)_DATE);
            velocityContext.put("_lis_", (Object)Splash.getFetchVersion());
            velocityContext.put("welcomePage", (Object)this.d);
            velocityContext.put("securityEnable", (Object)this.g);
            velocityContext.put("title", (Object)this.f);
            String string2 = PropertyConfigurer.getProperty((String)"urule.file.menuExtension");
            velocityContext.put("fileMenuExtension", (Object)(string2 == null ? "" : string2));
            String string3 = PropertyConfigurer.getProperty((String)"urule.file.menuExtensionUrl");
            velocityContext.put("fileMenuExtensionUrl", (Object)(string3 == null ? "" : string3));
            String string4 = PropertyConfigurer.getProperty((String)"urule.show.fileExtensionName");
            velocityContext.put("showFileExtensionName", (Object)string4);
            String string5 = PropertyConfigurer.getProperty((String)"urule.cluster");
            velocityContext.put("cluster", (Object)(string5 == null ? "false" : "true"));
            velocityContext.put("logoutURL", (Object)this.e);
            Object object = httpServletRequest.getSession().getAttribute("default_urule_security_login_user");
            if (object != null) {
                velocityContext.put("loginUser", (Object)((Principal)object).getName());
            }
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/frame.html", "utf-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
            printWriter.close();
        }
    }

    public void dirCopy(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        String string = httpServletRequest.getParameter("sourcePath");
        String string2 = httpServletRequest.getParameter("targetPath");
        this.b.copy(string, string2, principal);
        this.loadProjects(httpServletRequest, httpServletResponse);
    }

    public void fileReference(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("file");
        string = Utils.decodeURL((String)string);
        String string2 = this.a.getProject(string);
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        Repository repository = this.a.loadRepository(string2, principal, false, null, null);
        RepositoryFile repositoryFile = repository.getRootFile();
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        this.a(string, repositoryFile, arrayList);
        List<ResourcePackage> list = this.c.loadProjectResourcePackages(string2);
        block0: for (ResourcePackage resourcePackage : list) {
            for (ResourceItem resourceItem : resourcePackage.getResourceItems()) {
                if (resourceItem.getPath().indexOf(string) <= -1) continue;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("file", resourcePackage.getName() + "(" + resourcePackage.getId() + ")");
                hashMap.put("type", "kp");
                arrayList.add(hashMap);
                continue block0;
            }
        }
        this.writeObjectToJson(httpServletResponse, arrayList);
    }

    private void a(String string, RepositoryFile repositoryFile, List<Map<String, String>> list) throws Exception {
        Object object;
        String string2 = repositoryFile.getFullPath();
        String string3 = null;
        String string4 = null;
        switch (repositoryFile.getType()) {
            case action: {
                string3 = "\u52a8\u4f5c\u5e93\u6587\u4ef6";
                string4 = "/actioneditor";
                break;
            }
            case actionTemplate: {
                string3 = "\u52a8\u4f5c\u6a21\u7248\u6587\u4ef6";
                string4 = "/actiontemplate";
                break;
            }
            case complexscorecard: {
                string3 = "\u590d\u6742\u8bc4\u5206\u5361\u6587\u4ef6";
                string4 = "/complexscorecardeditor";
                break;
            }
            case conditionTemplate: {
                string3 = "\u6761\u4ef6\u6a21\u7248\u6587\u4ef6";
                string4 = "/conditiontemplate";
                break;
            }
            case constant: {
                string3 = "\u5e38\u91cf\u6587\u4ef6";
                string4 = "/constanteditor";
                break;
            }
            case crosstab: {
                string3 = "\u4ea4\u53c9\u51b3\u7b56\u8868\u6587\u4ef6";
                string4 = "/crosstabeditor";
                break;
            }
            case decisionTable: {
                string3 = "\u51b3\u7b56\u8868\u6587\u4ef6";
                string4 = "/decisiontableeditor";
                break;
            }
            case decisionTree: {
                string3 = "\u51b3\u7b56\u6811\u6587\u4ef6";
                string4 = "/decisiontreeeditor";
                break;
            }
            case flow: {
                string3 = "\u51b3\u7b56\u6d41\u6587\u4ef6";
                string4 = "/ruleflowdesigner";
                break;
            }
            case parameter: {
                string3 = "\u53c2\u6570\u5e93\u6587\u4ef6";
                string4 = "/parametereditor";
                break;
            }
            case rule: {
                string3 = "\u5411\u5bfc\u5f0f\u89c4\u5219\u6587\u4ef6";
                string4 = "/ruleseteditor";
                break;
            }
            case scorecard: {
                string3 = "\u8bc4\u5206\u5361\u6587\u4ef6";
                string4 = "/scorecardeditor";
                break;
            }
            case variable: {
                string3 = "\u53d8\u91cf\u5e93\u6587\u4ef6";
                string4 = "/variableeditor";
                break;
            }
        }
        if (string3 != null && this.a(string2, string)) {
            object = new HashMap();
            object.put("file", string2);
            object.put("type", string3);
            object.put("editor", string4);
            list.add((Map<String, String>)object);
        }
        if ((object = repositoryFile.getChildren()) == null) {
            return;
        }
        Iterator<RepositoryFile> iterator = object.iterator();
        while (iterator.hasNext()) {
            RepositoryFile repositoryFile2 = iterator.next();
            this.a(string, repositoryFile2, list);
        }
    }

    private boolean a(String string, String string2) throws Exception {
        InputStream inputStream = this.a.readFile(string);
        String string3 = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
        IOUtils.closeQuietly((InputStream)inputStream);
        return string3.contains(string2);
    }

    public void fileVersions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("path");
        string = Utils.decodeURL((String)string);
        List<VersionFile> list = this.a.getVersionFiles(string);
        this.writeObjectToJson(httpServletResponse, list);
    }

    public void fileSource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        String string = httpServletRequest.getParameter("path");
        string = Utils.decodeURL((String)string);
        InputStream inputStream = this.a.readFile(string, null);
        String string2 = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
        inputStream.close();
        String string3 = null;
        try {
            object = DocumentHelper.parseText((String)string2);
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            StringWriter stringWriter = new StringWriter();
            XMLWriter xMLWriter = new XMLWriter((Writer)stringWriter, outputFormat);
            xMLWriter.write((Document)object);
            string3 = stringWriter.toString();
        }
        catch (Exception exception) {
            string3 = string2;
        }
        object = new HashMap();
        object.put("content", string3);
        this.writeObjectToJson(httpServletResponse, object);
    }

    public void importProject(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("Permission denied!");
            printWriter.flush();
            printWriter.close();
        } else {
            DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
            ServletContext servletContext = httpServletRequest.getSession().getServletContext();
            File file = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            diskFileItemFactory.setRepository(file);
            ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
            InputStream inputStream = null;
            boolean bl = true;
            List list = servletFileUpload.parseRequest(httpServletRequest);
            if (list.size() == 0) {
                throw new ServletException("Upload file is invalid.");
            }
            for (FileItem fileItem : list) {
                String string = fileItem.getFieldName();
                if (string.equals("overwriteProject")) {
                    String string2 = new String(fileItem.get());
                    bl = Boolean.valueOf(string2);
                    continue;
                }
                if (!string.equals("file")) continue;
                inputStream = fileItem.getInputStream();
            }
            this.a.importXml(inputStream, bl);
            IOUtils.closeQuietly(inputStream);
            CacheUtils.getKnowledgeCache().clean();
            httpServletResponse.sendRedirect(httpServletRequest.getContextPath() + "/urule/frame");
        }
    }

    public void loadFileVersions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("file");
        string = Utils.decodeURL((String)string);
        List<VersionFile> list = this.a.getVersionFiles(string);
        this.writeObjectToJson(httpServletResponse, list);
    }

    public void createFolder(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("fullFolderName");
        string = Utils.decodeURL((String)string);
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        int n = string.lastIndexOf(47);
        String string2 = string.substring(0, n);
        this.checkFullPermission(principal, string2, false);
        this.a.createDir(string, principal);
        this.loadProjects(httpServletRequest, httpServletResponse);
    }

    public void copyFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("newFullPath");
        String string2 = httpServletRequest.getParameter("oldFullPath");
        string = Utils.decodeURL((String)string);
        string2 = Utils.decodeURL((String)string2);
        try {
            Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
            this.checkFullPermission(principal, string2, false);
            InputStream inputStream = this.a.readFile(string2, null);
            String string3 = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
            inputStream.close();
            this.a.createFile(string, string3, principal);
            this.loadProjects(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    public void createFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        String string = httpServletRequest.getParameter("path");
        string = Utils.decodeURL((String)string);
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        int n = string.lastIndexOf(47);
        String string2 = string.substring(0, n);
        this.checkFullPermission(principal, string2, false);
        String string3 = httpServletRequest.getParameter("type");
        FileType fileType = FileType.parse(string3);
        StringBuilder stringBuilder = new StringBuilder();
        if (fileType.equals((Object)FileType.UL)) {
            stringBuilder.append("rule \"rule01\"");
            stringBuilder.append("\n");
            stringBuilder.append("if");
            stringBuilder.append("\r\n");
            stringBuilder.append("then");
            stringBuilder.append("\r\n");
            stringBuilder.append("end");
        } else if (fileType.equals((Object)FileType.DecisionTable)) {
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            stringBuilder.append("<decision-table>");
            stringBuilder.append("<cell row=\"0\" col=\"2\" rowspan=\"1\"></cell>");
            stringBuilder.append("<cell row=\"0\" col=\"1\" rowspan=\"1\">");
            stringBuilder.append("<joint type=\"and\"/>");
            stringBuilder.append("</cell>");
            stringBuilder.append("<cell row=\"0\" col=\"0\" rowspan=\"1\">");
            stringBuilder.append("<joint type=\"and\"/>");
            stringBuilder.append("</cell>");
            stringBuilder.append("<cell row=\"1\" col=\"2\" rowspan=\"1\">");
            stringBuilder.append("</cell>");
            stringBuilder.append("<cell row=\"1\" col=\"1\" rowspan=\"1\">");
            stringBuilder.append("<joint type=\"and\"/>");
            stringBuilder.append("</cell>");
            stringBuilder.append("<cell row=\"1\" col=\"0\" rowspan=\"1\">");
            stringBuilder.append("<joint type=\"and\"/>");
            stringBuilder.append("</cell>");
            stringBuilder.append("<row num=\"0\" height=\"40\"/>");
            stringBuilder.append("<row num=\"1\" height=\"40\"/>");
            stringBuilder.append("<col num=\"0\" width=\"150\" type=\"Criteria\"/>");
            stringBuilder.append("<col num=\"1\" width=\"150\" type=\"Criteria\"/>");
            stringBuilder.append("<col num=\"2\" width=\"200\" type=\"Assignment\"/>");
            stringBuilder.append("</decision-table>");
        } else if (fileType.equals((Object)FileType.DecisionTree)) {
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            stringBuilder.append("<decision-tree>");
            stringBuilder.append("<variable-tree-node></variable-tree-node>");
            stringBuilder.append("</decision-tree>");
        } else if (fileType.equals((Object)FileType.ScriptDecisionTable)) {
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            stringBuilder.append("<script-decision-table>");
            stringBuilder.append("<script-cell row=\"0\" col=\"2\" rowspan=\"1\"></script-cell>");
            stringBuilder.append("<script-cell row=\"0\" col=\"1\" rowspan=\"1\"></script-cell>");
            stringBuilder.append("<script-cell row=\"0\" col=\"0\" rowspan=\"1\"></script-cell>");
            stringBuilder.append("<script-cell row=\"1\" col=\"2\" rowspan=\"1\"></script-cell>");
            stringBuilder.append("<script-cell row=\"1\" col=\"1\" rowspan=\"1\"></script-cell>");
            stringBuilder.append("<script-cell row=\"1\" col=\"0\" rowspan=\"1\"></script-cell>");
            stringBuilder.append("<row num=\"0\" height=\"40\"/>");
            stringBuilder.append("<row num=\"1\" height=\"40\"/>");
            stringBuilder.append("<col num=\"0\" width=\"120\" type=\"Criteria\"/>");
            stringBuilder.append("<col num=\"1\" width=\"120\" type=\"Criteria\"/>");
            stringBuilder.append("<col num=\"2\" width=\"200\" type=\"Assignment\"/>");
            stringBuilder.append("</script-decision-table>");
        } else if (fileType.equals((Object)FileType.Scorecard)) {
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            stringBuilder.append("<scorecard scoring-type=\"sum\" assign-target-type=\"none\">");
            stringBuilder.append("</scorecard>");
        } else if (fileType.equals((Object)FileType.Crosstab)) {
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            stringBuilder.append("<crosstab>");
            stringBuilder.append("<header>LEFT &amp;&amp; TOP</header>");
            stringBuilder.append("<row number=\"1\" type=\"top\"/>");
            stringBuilder.append("<column number=\"1\" type=\"left\"/>");
            stringBuilder.append("<column number=\"2\" type=\"top\"/>");
            stringBuilder.append("<row number=\"2\" type=\"left\"/>");
            stringBuilder.append("<condition-cell row=\"1\" col=\"2\"/>");
            stringBuilder.append("<condition-cell row=\"2\" col=\"1\"/>");
            stringBuilder.append("<value-cell row=\"2\" col=\"2\"/>");
            stringBuilder.append("</crosstab>");
        } else if (fileType.equals((Object)FileType.ComplexScorecard)) {
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            stringBuilder.append("<complex-scorecard scoring-type=\"sum\" assign-target-type=\"none\">");
            stringBuilder.append("<cell row=\"0\" col=\"2\" rowspan=\"1\"></cell>");
            stringBuilder.append("<cell row=\"0\" col=\"1\" rowspan=\"1\">");
            stringBuilder.append("<joint type=\"and\"/>");
            stringBuilder.append("</cell>");
            stringBuilder.append("<cell row=\"0\" col=\"0\" rowspan=\"1\">");
            stringBuilder.append("<joint type=\"and\"/>");
            stringBuilder.append("</cell>");
            stringBuilder.append("<cell row=\"1\" col=\"2\" rowspan=\"1\">");
            stringBuilder.append("</cell>");
            stringBuilder.append("<cell row=\"1\" col=\"1\" rowspan=\"1\">");
            stringBuilder.append("<joint type=\"and\"/>");
            stringBuilder.append("</cell>");
            stringBuilder.append("<cell row=\"1\" col=\"0\" rowspan=\"1\">");
            stringBuilder.append("<joint type=\"and\"/>");
            stringBuilder.append("</cell>");
            stringBuilder.append("<row num=\"0\" height=\"40\"/>");
            stringBuilder.append("<row num=\"1\" height=\"40\"/>");
            stringBuilder.append("<col num=\"0\" width=\"150\" type=\"Criteria\"/>");
            stringBuilder.append("<col num=\"1\" width=\"150\" type=\"Criteria\"/>");
            stringBuilder.append("<col num=\"2\" width=\"120\" type=\"Score\"/>");
            stringBuilder.append("</complex-scorecard>");
        } else {
            object = this.a(fileType);
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            stringBuilder.append("<" + (String)object + ">");
            stringBuilder.append("</" + (String)object + ">");
        }
        try {
            this.a.createFile(string, stringBuilder.toString(), principal);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        object = new RepositoryFile();
        ((RepositoryFile)object).setFullPath(string);
        if (fileType.equals((Object)FileType.VariableLibrary)) {
            ((RepositoryFile)object).setType(Type.variable);
        } else if (fileType.equals((Object)FileType.ActionLibrary)) {
            ((RepositoryFile)object).setType(Type.action);
        } else if (fileType.equals((Object)FileType.ConstantLibrary)) {
            ((RepositoryFile)object).setType(Type.constant);
        } else if (fileType.equals((Object)FileType.ParameterLibrary)) {
            ((RepositoryFile)object).setType(Type.parameter);
        } else if (fileType.equals((Object)FileType.DecisionTable)) {
            ((RepositoryFile)object).setType(Type.decisionTable);
        } else if (fileType.equals((Object)FileType.ScriptDecisionTable)) {
            ((RepositoryFile)object).setType(Type.scriptDecisionTable);
        } else if (fileType.equals((Object)FileType.Ruleset)) {
            ((RepositoryFile)object).setType(Type.rule);
        } else if (fileType.equals((Object)FileType.UL)) {
            ((RepositoryFile)object).setType(Type.ul);
        } else if (fileType.equals((Object)FileType.DecisionTree)) {
            ((RepositoryFile)object).setType(Type.decisionTree);
        } else if (fileType.equals((Object)FileType.RuleFlow)) {
            ((RepositoryFile)object).setType(Type.flow);
        } else if (fileType.equals((Object)FileType.Scorecard)) {
            ((RepositoryFile)object).setType(Type.scorecard);
        } else if (fileType.equals((Object)FileType.ComplexScorecard)) {
            ((RepositoryFile)object).setType(Type.complexscorecard);
        } else if (fileType.equals((Object)FileType.Crosstab)) {
            ((RepositoryFile)object).setType(Type.crosstab);
        } else if (fileType.equals((Object)FileType.ConditionTemplate)) {
            ((RepositoryFile)object).setType(Type.conditionTemplate);
        } else if (fileType.equals((Object)FileType.ActionTemplate)) {
            ((RepositoryFile)object).setType(Type.actionTemplate);
        }
        this.writeObjectToJson(httpServletResponse, object);
    }

    private String a(FileType fileType) {
        String string = null;
        switch (fileType) {
            case ActionLibrary: {
                string = "action-library";
                break;
            }
            case ConstantLibrary: {
                string = "constant-library";
                break;
            }
            case DecisionTable: {
                string = "decision-table";
                break;
            }
            case Crosstab: {
                string = "cross-table";
                break;
            }
            case DecisionTree: {
                string = "decision-tree";
                break;
            }
            case ParameterLibrary: {
                string = "parameter-library";
                break;
            }
            case RuleFlow: {
                string = "rule-flow";
                break;
            }
            case Ruleset: {
                string = "rule-set";
                break;
            }
            case ConditionTemplate: {
                string = "templates";
                break;
            }
            case ActionTemplate: {
                string = "action-templates";
                break;
            }
            case ScriptDecisionTable: {
                string = "script-decision-table";
                break;
            }
            case VariableLibrary: {
                string = "variable-library";
                break;
            }
            case UL: {
                string = "script";
                break;
            }
            case Scorecard: {
                string = "scorecard";
                break;
            }
            case ComplexScorecard: {
                string = "complex-scorecard";
                break;
            }
            case DIR: {
                throw new IllegalArgumentException("Unsupport filetype : " + (Object)((Object)fileType));
            }
        }
        return string;
    }

    public void projectExistCheck(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("newProjectName");
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        string = Utils.decodeURL((String)string);
        string = string.trim();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        try {
            hashMap.put("valid", !this.a.fileExistCheck(string));
            this.writeObjectToJson(httpServletResponse, hashMap);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    public void fileExistCheck(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("fullFileName");
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        string = Utils.decodeURL((String)string);
        string = string.trim();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        try {
            hashMap.put("valid", !this.a.fileExistCheck(string));
            this.writeObjectToJson(httpServletResponse, hashMap);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    public void deleteFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("path");
        string = Utils.decodeURL((String)string);
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        int n = string.lastIndexOf(47);
        if (n == 0 && !principal.isAdmin()) {
            throw new NoPermissionException();
        }
        this.checkFullPermission(principal, string, false);
        this.a.deleteFile(string, principal);
        String string2 = httpServletRequest.getParameter("isFolder");
        if (StringUtils.isNotBlank((String)string2) && string2.equals("true")) {
            this.loadProjects(httpServletRequest, httpServletResponse);
        }
    }

    public void lockFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("file");
        string = Utils.decodeURL((String)string);
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        this.checkFullPermission(principal, string, false);
        this.a.lockPath(string, principal);
        this.loadProjects(httpServletRequest, httpServletResponse);
    }

    public void unlockFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("file");
        string = Utils.decodeURL((String)string);
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        this.checkFullPermission(principal, string, false);
        this.a.unlockPath(string, principal);
        this.loadProjects(httpServletRequest, httpServletResponse);
    }

    public void importFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string;
        Object object2;
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
        ServletContext servletContext = httpServletRequest.getSession().getServletContext();
        File file = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        diskFileItemFactory.setRepository(file);
        ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
        servletFileUpload.setHeaderEncoding("utf-8");
        InputStream inputStream = null;
        boolean bl = true;
        List list = servletFileUpload.parseRequest(httpServletRequest);
        if (list.size() == 0) {
            throw new ServletException("Upload file is invalid.");
        }
        String string2 = null;
        String string3 = null;
        for (Object object2 : list) {
            string = object2.getFieldName();
            if (string.equals("overwrite")) {
                String string4 = new String(object2.get());
                bl = Boolean.valueOf(string4);
                continue;
            }
            if (string.equals("importFile")) {
                inputStream = object2.getInputStream();
                string3 = object2.getName();
                continue;
            }
            if (!string.contentEquals("folder")) continue;
            string2 = Utils.decodeURL((String)new String(object2.get()));
        }
        Object object3 = null;
        try {
            if (string3 == null) {
                throw new RuleException("\u672a\u80fd\u53d6\u5230\u4e0a\u4f20\u6587\u4ef6\u7684\u6587\u4ef6\u540d.");
            }
            if (!(string3.endsWith(FileType.ActionLibrary.toString()) || string3.endsWith(FileType.ActionTemplate.toString()) || string3.endsWith(FileType.ComplexScorecard.toString()) || string3.endsWith(FileType.ConditionTemplate.toString()) || string3.endsWith(FileType.ConstantLibrary.toString()) || string3.endsWith(FileType.Crosstab.toString()) || string3.endsWith(FileType.DecisionTable.toString()) || string3.endsWith(FileType.DecisionTree.toString()) || string3.endsWith(FileType.ParameterLibrary.toString()) || string3.endsWith(FileType.RuleFlow.toString()) || string3.endsWith(FileType.Ruleset.toString()) || string3.endsWith(FileType.Scorecard.toString()) || string3.endsWith(FileType.UL.toString()) || string3.endsWith(FileType.VariableLibrary.toString()))) {
                throw new RuleException("\u5f15\u64ce\u65e0\u6cd5\u652f\u6301\u7684\u6587\u4ef6\uff1a" + string3);
            }
            object2 = IOUtils.toString(inputStream, (String)"utf-8");
            inputStream.close();
            string = string2 + "/" + string3;
            if (string.startsWith("/")) {
                string = string.substring(1, string.length());
            }
            boolean bl2 = this.a.fileExist(string);
            if (bl) {
                if (bl2) {
                    this.a.saveFile(string, (String)object2, false, null, principal);
                } else {
                    this.a.createFile(string, (String)object2, principal);
                }
            } else if (bl2) {
                object3 = "\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u5b58\u5728\u540d\u4e3a\u3010" + string3 + "\u3011\u6587\u4ef6\uff0c\u4e14\u5f53\u524d\u64cd\u4f5c\u4e0d\u5141\u8bb8\u8986\u76d6\u5df2\u5b58\u5728\u6587\u4ef6.";
            } else {
                this.a.createFile(string, (String)object2, principal);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object3 = exception.getMessage();
        }
        object2 = new HashMap();
        object2.put("error", object3);
        this.writeObjectToJson(httpServletResponse, object2);
    }

    public void exportFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("file");
        string = Utils.decodeURL((String)string);
        InputStream inputStream = this.a.readFile(string);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        String string2 = string;
        if (string2.lastIndexOf(47) > -1) {
            string2 = string2.substring(string2.lastIndexOf(47) + 1, string2.length());
        }
        httpServletResponse.setContentType("application/octet-stream");
        httpServletResponse.setHeader("Content-Disposition", "attachment; filename=\"" + new String(string2.getBytes("utf-8"), "iso-8859-1") + "\"");
        httpServletResponse.setHeader("content-type", "application/octet-stream");
        IOUtils.copy((InputStream)inputStream, (OutputStream)servletOutputStream);
        inputStream.close();
        servletOutputStream.flush();
        servletOutputStream.close();
    }

    public void exportProjectBackupFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("Permission denied!");
            printWriter.flush();
            printWriter.close();
        } else {
            String string = httpServletRequest.getParameter("path");
            String string2 = Utils.decodeURL((String)string);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            String string3 = null;
            string3 = StringUtils.isBlank((String)string2) ? "all" : string2.substring(1, string2.length());
            String string4 = string3 + "-urule-repo-" + simpleDateFormat.format(new Date()) + ".bak";
            httpServletResponse.setContentType("application/octet-stream");
            httpServletResponse.setHeader("Content-Disposition", "attachment; filename=\"" + new String(string4.getBytes("utf-8"), "iso-8859-1") + "\"");
            httpServletResponse.setHeader("content-type", "application/octet-stream");
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            if (StringUtils.isBlank((String)string2)) {
                this.a.exportXml((OutputStream)servletOutputStream);
            } else {
                this.a.exportXml(string2, (OutputStream)servletOutputStream);
            }
            servletOutputStream.flush();
            servletOutputStream.close();
        }
    }

    public void createProject(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            throw new NoPermissionException();
        }
        String string = httpServletRequest.getParameter("newProjectName");
        string = Utils.decodeURL((String)string);
        boolean bl = this.a(httpServletRequest, httpServletResponse);
        this.checkFullPermission(principal, string, false);
        RepositoryFile repositoryFile = this.a.createProject(string, principal, bl);
        this.writeObjectToJson(httpServletResponse, repositoryFile);
    }

    public void loadProjects(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        boolean bl = this.a(httpServletRequest, httpServletResponse);
        String string = httpServletRequest.getParameter("projectName");
        String string2 = httpServletRequest.getParameter("searchFileName");
        string = Utils.decodeURL((String)string);
        String string3 = httpServletRequest.getParameter("types");
        FileType[] fileTypeArray = null;
        if (StringUtils.isNotBlank((String)string3) && !string3.equals("all")) {
            if (string3.equals("lib")) {
                fileTypeArray = new FileType[]{FileType.VariableLibrary, FileType.ConstantLibrary, FileType.ParameterLibrary, FileType.ActionLibrary};
            } else if (string3.equals("rule")) {
                fileTypeArray = new FileType[]{FileType.Ruleset, FileType.UL};
            } else if (string3.equals("table")) {
                fileTypeArray = new FileType[]{FileType.DecisionTable, FileType.ScriptDecisionTable, FileType.Crosstab};
            } else if (string3.equals("tree")) {
                fileTypeArray = new FileType[]{FileType.DecisionTree};
            } else if (string3.equals("flow")) {
                fileTypeArray = new FileType[]{FileType.RuleFlow};
            } else if (string3.equals("card")) {
                fileTypeArray = new FileType[]{FileType.Scorecard, FileType.ComplexScorecard};
            }
        }
        Repository repository = this.a.loadRepository(string, principal, bl, fileTypeArray, string2);
        this.a(repository.getRootFile());
        Repository repository2 = this.buildRepositoryAuthority(principal, repository);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("repo", repository2);
        hashMap.put("classify", bl);
        this.writeObjectToJson(httpServletResponse, hashMap);
    }

    private void a(RepositoryFile repositoryFile) {
        List<RepositoryFile> list = repositoryFile.getChildren();
        if (list == null) {
            return;
        }
        if (repositoryFile.getType().equals((Object)Type.scorecardLib) || repositoryFile.getType().equals((Object)Type.ruleLib) || repositoryFile.getType().equals((Object)Type.decisionTableLib) || repositoryFile.getType().equals((Object)Type.flowLib) || repositoryFile.getType().equals((Object)Type.lib) || repositoryFile.getType().equals((Object)Type.decisionTreeLib) || repositoryFile.getType().equals((Object)Type.scorecardLib) || repositoryFile.getType().equals((Object)Type.folder) || repositoryFile.getType().equals((Object)Type.all)) {
            Collections.sort(list, new Comparator<RepositoryFile>(){

                @Override
                public int compare(RepositoryFile repositoryFile, RepositoryFile repositoryFile2) {
                    if (repositoryFile.getType().equals((Object)Type.folder) && repositoryFile2.getType().equals((Object)Type.folder)) {
                        return repositoryFile.getName().compareTo(repositoryFile2.getName());
                    }
                    if (repositoryFile.getType().equals((Object)Type.folder)) {
                        return -1;
                    }
                    if (repositoryFile2.getType().equals((Object)Type.folder)) {
                        return 1;
                    }
                    return repositoryFile.getName().compareTo(repositoryFile2.getName());
                }
            });
        }
        for (RepositoryFile repositoryFile2 : list) {
            this.a(repositoryFile2);
        }
    }

    private boolean a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Cookie cookie;
        String string = httpServletRequest.getParameter("classify");
        if (StringUtils.isBlank((String)string)) {
            cookie = httpServletRequest.getCookies();
            if (cookie != null) {
                for (Cookie cookie2 : cookie) {
                    if (!h.equals(cookie2.getName())) continue;
                    string = cookie2.getValue();
                    break;
                }
            }
        } else {
            cookie = new Cookie(h, string);
            cookie.setMaxAge(2100000000);
            httpServletResponse.addCookie(cookie);
        }
        boolean bl = true;
        if (StringUtils.isNotBlank((String)string)) {
            bl = Boolean.valueOf(string);
        }
        return bl;
    }

    public void fileRename(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("path");
        string = Utils.decodeURL((String)string);
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        this.checkFullPermission(principal, string, false);
        String string2 = httpServletRequest.getParameter("newPath");
        string2 = Utils.decodeURL((String)string2);
        this.a.fileRename(string, string2);
        String string3 = httpServletRequest.getParameter("project");
        if (string3 != null && string3.equals("true")) {
            this.c.projectRename(string, string2);
            this.c.resetProjectResourcePackagesTag(string2);
        }
        this.loadProjects(httpServletRequest, httpServletResponse);
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.a = repositoryService;
    }

    public void setKnowledgePackageRepositoryService(KnowledgePackageRepositoryService knowledgePackageRepositoryService) {
        this.c = knowledgePackageRepositoryService;
    }

    public void setDirectoryDuplicator(DirectoryDuplicator directoryDuplicator) {
        this.b = directoryDuplicator;
    }

    public void setWelcomePage(String string) {
        this.d = string.startsWith("${") ? "" : string;
    }

    public void setTitle(String string) {
        if (string.startsWith("${")) {
            return;
        }
        this.f = string;
    }

    public void setLogoutURL(String string) {
        if (string.startsWith("${")) {
            return;
        }
        this.e = string;
    }

    public void setSecurityEnable(String string) {
        if (string.equals("true")) {
            this.g = true;
        }
    }

    @Override
    public String url() {
        return "/frame";
    }
}

