/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.json;

import com.bstek.urule.Splash;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.exception.RuleException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonServletHandler
extends RenderPageServletHandler {
    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.retriveMethod(httpServletRequest);
        if (string != null) {
            this.invokeMethod(string, httpServletRequest, httpServletResponse);
        } else {
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
            velocityContext.put("version", (Object)Splash.getVersion());
            velocityContext.put("_lis_", (Object)Splash.getFetchVersion());
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/json-tool.html", "utf-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
            printWriter.close();
        }
    }

    public void convert(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        StringBuilder stringBuilder;
        block5: {
            String string = httpServletRequest.getParameter("json");
            if (StringUtils.isBlank((String)string)) {
                throw new RuleException("JSON\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            string = string.trim();
            stringBuilder = new StringBuilder();
            try {
                object = new ObjectMapper();
                if (string.startsWith("[") && string.endsWith("]")) {
                    List list = (List)object.readValue(string, ArrayList.class);
                    stringBuilder.append(this.a(list));
                    break block5;
                }
                if (string.startsWith("{") && string.endsWith("}")) {
                    Map map = (Map)object.readValue(string, HashMap.class);
                    stringBuilder.append(this.a(map));
                    break block5;
                }
                throw new RuleException("\u4e0d\u652f\u6301\u7684JSON\u683c\u5f0f");
            }
            catch (Exception exception) {
                throw new RuleException("\u4e0d\u652f\u6301\u7684JSON\u683c\u5f0f");
            }
        }
        object = new HashMap();
        object.put("json", stringBuilder.toString());
        this.writeObjectToJson(httpServletResponse, object);
    }

    public void gzip(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("json");
        if (StringUtils.isBlank((String)string)) {
            throw new RuleException("JSON\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        string = string.trim();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("data", this.doGzip(string));
        this.writeObjectToJson(httpServletResponse, hashMap);
    }

    public String doGzip(String string) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(string.getBytes("utf-8"));
        gZIPOutputStream.close();
        Base64 base64 = new Base64();
        return base64.encodeAsString(byteArrayOutputStream.toByteArray());
    }

    private String a(Map<String, Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append("\"name\"");
        stringBuilder.append(":");
        stringBuilder.append("\"\u5f85\u586b\u5199\u7684\u53d8\u91cf\u5206\u7c7b\u540d\"");
        stringBuilder.append(",");
        stringBuilder.append("\"fields\"");
        stringBuilder.append(":");
        stringBuilder.append("{");
        int n = 0;
        for (String string : map.keySet()) {
            Object object = map.get(string);
            if (object == null) continue;
            if (n > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"" + string + "\"");
            stringBuilder.append(":");
            if (object instanceof Map) {
                stringBuilder.append(this.a((Map)object));
            } else if (object instanceof List) {
                stringBuilder.append(this.a((List)object));
            } else if (object instanceof Number) {
                stringBuilder.append(object);
            } else {
                stringBuilder.append("\"" + object + "\"");
            }
            ++n;
        }
        stringBuilder.append("}");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String a(List<Map<String, Object>> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int n = 0;
        for (Map<String, Object> map : list) {
            if (n > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.a(map));
            ++n;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public String url() {
        return "/json";
    }
}

