/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.permission;

import com.bstek.urule.PropertyConfigurer;
import com.bstek.urule.Splash;
import com.bstek.urule.console.EnvironmentUtils;
import com.bstek.urule.console.Principal;
import com.bstek.urule.console.exception.NoPermissionException;
import com.bstek.urule.console.repository.BaseRepositoryService;
import com.bstek.urule.console.repository.OperateType;
import com.bstek.urule.console.repository.authority.Authority;
import com.bstek.urule.console.repository.authority.AuthorityRepositoryService;
import com.bstek.urule.console.repository.authority.AuthorityUnit;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.console.servlet.RequestContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class PermissionServletHandler
extends RenderPageServletHandler {
    private AuthorityRepositoryService a;
    private String b;

    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            throw new NoPermissionException();
        }
        String string = this.retriveMethod(httpServletRequest);
        if (string != null) {
            this.invokeMethod(string, httpServletRequest, httpServletResponse);
        } else {
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
            velocityContext.put("version", (Object)Splash.getVersion());
            velocityContext.put("_date_", (Object)_DATE);
            velocityContext.put("_lis_", (Object)Splash.getFetchVersion());
            velocityContext.put("authorityType", (Object)this.b);
            velocityContext.put("showFileExtensionName", (Object)PropertyConfigurer.getProperty((String)"urule.show.fileExtensionName"));
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/permission-config-editor.html", "utf-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
            printWriter.close();
        }
    }

    public void userList(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        List<Principal> list = EnvironmentUtils.getEnvironmentProvider().getPrincipals();
        this.writeObjectToJson(httpServletResponse, list);
    }

    public void save(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            throw new NoPermissionException();
        }
        String string = httpServletRequest.getParameter("user");
        String string2 = httpServletRequest.getParameter("path");
        String string3 = httpServletRequest.getParameter("state");
        OperateType operateType = OperateType.add;
        if (string3.equals("0")) {
            operateType = OperateType.delete;
        } else if (string3.equals("1")) {
            operateType = OperateType.update;
        }
        Authority authority = new Authority();
        authority.setPath(string2);
        if (!operateType.equals((Object)OperateType.delete)) {
            String string4 = httpServletRequest.getParameter("read");
            if (string4.equals("true")) {
                authority.setRead(true);
            } else {
                authority.setRead(false);
            }
            String string5 = httpServletRequest.getParameter("write");
            if (string5.equals("true")) {
                authority.setWrite(true);
            } else {
                authority.setWrite(false);
            }
            String string6 = httpServletRequest.getParameter("save");
            if (string6.equals("true")) {
                authority.setSave(true);
            } else {
                authority.setSave(false);
            }
            String string7 = httpServletRequest.getParameter("saveas");
            if (string7.equals("true")) {
                authority.setSaveas(true);
            } else {
                authority.setSaveas(false);
            }
        }
        this.a.saveAuthority(principal, string, authority, operateType);
    }

    public void search(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("user");
        String string2 = httpServletRequest.getParameter("url");
        String string3 = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse)).getCompanyId();
        List<AuthorityUnit> list = this.a.loadAuthorityUnits(string3);
        ArrayList arrayList = new ArrayList();
        Node node = ((BaseRepositoryService)((Object)this.a)).getRootNode();
        for (AuthorityUnit authorityUnit : list) {
            String string4 = authorityUnit.getPrincipalName();
            if (StringUtils.isNotBlank((String)string) && string4.indexOf(string) == -1) continue;
            for (Authority authority : authorityUnit.getAuthorities()) {
                String string5 = authority.getPath().toLowerCase();
                if (StringUtils.isNotBlank((String)string2) && string5.indexOf(string2.toLowerCase()) == -1) continue;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("user", authorityUnit.getPrincipalName());
                hashMap.put("path", authority.getPath());
                hashMap.put("read", authority.isRead());
                hashMap.put("write", authority.isWrite());
                hashMap.put("save", authority.isSave());
                hashMap.put("saveas", authority.isSaveas());
                if (node.hasNode(this.a(authority.getPath()))) {
                    hashMap.put("exist", true);
                } else {
                    hashMap.put("exist", false);
                }
                arrayList.add(hashMap);
            }
        }
        this.writeObjectToJson(httpServletResponse, arrayList);
    }

    private String a(String string) {
        if (string.startsWith("/")) {
            return string.substring(1, string.length());
        }
        return string;
    }

    public void setAuthorityType(String string) {
        this.b = string;
    }

    public void setAuthorityRepositoryService(AuthorityRepositoryService authorityRepositoryService) {
        this.a = authorityRepositoryService;
    }

    @Override
    public String url() {
        return "/permission";
    }
}

