/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.respackage;

import com.bstek.urule.Configure;
import com.bstek.urule.ContextHolder;
import com.bstek.urule.PropertyConfigurer;
import com.bstek.urule.Splash;
import com.bstek.urule.Utils;
import com.bstek.urule.builder.KnowledgeBase;
import com.bstek.urule.builder.KnowledgeBuilder;
import com.bstek.urule.builder.ResourceBase;
import com.bstek.urule.console.EnvironmentUtils;
import com.bstek.urule.console.Principal;
import com.bstek.urule.console.cache.ResourcePackageCache;
import com.bstek.urule.console.exception.NoPermissionException;
import com.bstek.urule.console.repository.ClientConfig;
import com.bstek.urule.console.repository.KnowledgePackageRepositoryService;
import com.bstek.urule.console.repository.RepositoryService;
import com.bstek.urule.console.repository.cluster.ClusterRepositoryService;
import com.bstek.urule.console.repository.model.ResourcePackage;
import com.bstek.urule.console.repository.model.VersionFile;
import com.bstek.urule.console.servlet.JsonBuilder;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.console.servlet.RequestContext;
import com.bstek.urule.console.servlet.console.ConsoleKeyHolder;
import com.bstek.urule.console.servlet.respackage.HttpSessionKnowledgeCache;
import com.bstek.urule.console.servlet.respackage.KnowledgePackagePublishListener;
import com.bstek.urule.console.servlet.respackage.PageResourcePackage;
import com.bstek.urule.console.servlet.respackage.ResourcePackageUpdater;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.GeneralEntity;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.library.variable.Variable;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.KnowledgePackageWrapper;
import com.bstek.urule.runtime.KnowledgeSession;
import com.bstek.urule.runtime.KnowledgeSessionFactory;
import com.bstek.urule.runtime.RemoteDynamicJarsBuilder;
import com.bstek.urule.runtime.cache.CacheUtils;
import com.bstek.urule.runtime.log.FlowNodeLog;
import com.bstek.urule.runtime.log.MatchedRuleLog;
import com.bstek.urule.runtime.response.FlowExecutionResponse;
import com.bstek.urule.runtime.response.RuleExecutionResponse;
import com.bstek.urule.runtime.service.KnowledgePackageService;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class PackageServletHandler
extends RenderPageServletHandler {
    public static final String KB_KEY = "_k_b";
    public static final String VCS_KEY = "_v_c_s";
    public static final String IMPORT_EXCEL_DATA = "_import_excel_data";
    private RepositoryService a;
    private KnowledgePackageService b;
    private KnowledgeBuilder c;
    private KnowledgePackagePublishListener d;
    private RemoteDynamicJarsBuilder e;
    private HttpSessionKnowledgeCache f;
    private KnowledgePackageRepositoryService g;
    private ResourcePackageCache h;
    private ClusterRepositoryService i;

    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.retriveMethod(httpServletRequest);
        if (string != null) {
            this.invokeMethod(string, httpServletRequest, httpServletResponse);
        } else {
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
            velocityContext.put("version", (Object)Splash.getVersion());
            velocityContext.put("_date_", (Object)_DATE);
            velocityContext.put("_lis_", (Object)Splash.getFetchVersion());
            velocityContext.put("showFileExtensionName", (Object)PropertyConfigurer.getProperty((String)"urule.show.fileExtensionName"));
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/package-editor.html", "utf-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
            printWriter.close();
        }
    }

    public void compare(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String string = httpServletRequest.getParameter("project");
        String string2 = httpServletRequest.getParameter("packageId");
        if (string.startsWith("/")) {
            string = string.substring(1, string.length());
        }
        String string3 = Utils.decodeURL((String)string) + "/" + Utils.decodeURL((String)string2);
        velocityContext.put("packageInfo", (Object)string3);
        velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
        velocityContext.put("version", (Object)Splash.getVersion());
        velocityContext.put("_lis_", (Object)Splash.getFetchVersion());
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setCharacterEncoding("utf-8");
        Template template = this.ve.getTemplate("html/package-version-compare.html", "utf-8");
        PrintWriter printWriter = httpServletResponse.getWriter();
        template.merge((Context)velocityContext, (Writer)printWriter);
        printWriter.close();
    }

    public void exportKnowledgePackage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string;
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            throw new NoPermissionException();
        }
        String string2 = Utils.decodeURL((String)httpServletRequest.getParameter("project"));
        if (StringUtils.isBlank((String)string2)) {
            throw new RuleException("\u9879\u76ee\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (string2.startsWith("/")) {
            string2 = string2.substring(1, string2.length());
        }
        if (StringUtils.isBlank((String)(string = Utils.decodeURL((String)httpServletRequest.getParameter("packageId"))))) {
            throw new RuleException("\u77e5\u8bc6\u5305ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String string3 = string2 + "/" + string;
        String string4 = string2 + "#" + string + ".data";
        httpServletResponse.setHeader("Content-Disposition", "attachment; filename=" + new String(string4.getBytes("UTF-8"), "ISO8859-1"));
        String string5 = httpServletRequest.getParameter("version");
        InputStream inputStream = this.g.getKnowledgePackgeData(string3, string5);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        IOUtils.copy((InputStream)inputStream, (OutputStream)servletOutputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)servletOutputStream);
    }

    public void loadPackages(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("project");
        string = Utils.decodeURL((String)string);
        List<ResourcePackage> list = this.g.loadProjectResourcePackages(string);
        PageResourcePackage pageResourcePackage = new PageResourcePackage(httpServletRequest, list);
        this.writeObjectToJson(httpServletResponse, pageResourcePackage);
    }

    public void loadFlows(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        KnowledgeBase knowledgeBase = (KnowledgeBase)this.f.get(httpServletRequest, KB_KEY);
        Collection collection = knowledgeBase.getFlowMap().values();
        this.writeObjectToJson(httpServletResponse, collection);
    }

    public void pushKnowledgePackageToClients(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        Object object2;
        Object object3;
        String string = httpServletRequest.getParameter("project");
        String string2 = (string = Utils.decodeURL((String)string)) + "/" + Utils.decodeURL((String)httpServletRequest.getParameter("packageId"));
        if (string2.startsWith("/")) {
            string2 = string2.substring(1, string2.length());
        }
        String string3 = httpServletRequest.getParameter("client");
        String string4 = httpServletRequest.getParameter("version");
        byte[] byArray = null;
        if (StringUtils.isNotBlank((String)string4)) {
            byArray = this.g.getKnowledgePackgeBytes(string2, string4);
        } else {
            object3 = CacheUtils.getKnowledgeCache().getKnowledge(string2);
            object2 = new ObjectMapper();
            object2.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
            object2.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
            object2.setDateFormat((DateFormat)new SimpleDateFormat(Configure.getDateFormat()));
            object = object2.writeValueAsString((Object)new KnowledgePackageWrapper((KnowledgePackage)object3));
            byArray = Utils.compress((String)object);
        }
        object3 = this.a.loadClientConfigs(string, false);
        object2 = new ArrayList();
        object = object3.iterator();
        while (object.hasNext()) {
            Map<String, Object> map;
            ClientConfig clientConfig = (ClientConfig)object.next();
            if (StringUtils.isNotBlank((String)string3)) {
                if (!string3.equals(clientConfig.getClient())) continue;
                map = this.a(string2, byArray, clientConfig);
                object2.add(map);
                break;
            }
            map = this.a(string2, byArray, clientConfig);
            object2.add(map);
        }
        this.writeObjectToJson(httpServletResponse, object2);
    }

    private Map<String, Object> a(String string, byte[] byArray, ClientConfig clientConfig) {
        String string2 = this.a(string, byArray, clientConfig.getClient());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string2 == null) {
            hashMap.put("result", true);
            hashMap.put("info", "<div class='text-info' style='line-height:30px'>\u63a8\u9001\u5230\u5ba2\u6237\u7aef\uff1a" + clientConfig.getName() + "\uff1a" + clientConfig.getClient() + " \u6210\u529f</div>");
        } else {
            hashMap.put("result", false);
            hashMap.put("info", "<div class='text-danger' style='line-height:30px'>\u63a8\u9001\u5230\u5ba2\u6237\u7aef\uff1a" + clientConfig.getName() + "\uff1a" + clientConfig.getClient() + " \u5931\u8d25</div>");
            hashMap.put("error", "<div style='margin-left:10px;color:red;word-wrap:break-word'>" + string2 + "</div>");
        }
        return hashMap;
    }

    public void loadClients(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("project");
        string = Utils.decodeURL((String)string);
        List<ClientConfig> list = this.a.loadClientConfigs(string, false);
        this.writeObjectToJson(httpServletResponse, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String a(String string, byte[] byArray, String string2) {
        String string3;
        HttpURLConnection httpURLConnection = null;
        try {
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            String string4 = "packageId=" + URLEncoder.encode(string, "utf-8");
            string4 = string4 + "&_u=" + Utils.encodeURL((String)this.e.getUser()) + "";
            string4 = string4 + "&_p=" + Utils.encodeURL((String)this.e.getPwd()) + "";
            string3 = string2 + "/knowledgepackagereceiver" + "?" + string4;
            URL uRL = new URL(string3);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.setRequestProperty("Accept-Charset", "utf-8");
            httpURLConnection.setRequestProperty("Content-Type", "text/json");
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.connect();
            OutputStream outputStream = httpURLConnection.getOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            dataOutputStream.write(byArray);
            dataOutputStream.flush();
            dataOutputStream.close();
            InputStream inputStream = httpURLConnection.getInputStream();
            if (inputStream == null) {
                String string5 = "Unknow client error!";
                return string5;
            }
            String string6 = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            outputStream.close();
            inputStream.close();
            if (string6.equals("ok")) {
                String string7 = null;
                return string7;
            }
            String string8 = "<strong>\u63a8\u9001\u64cd\u4f5c\u6210\u529f\u5230\u8fbe\u5ba2\u6237\u7aef\uff0c\u4f46\u5ba2\u6237\u7aef\u51fa\u9519\u9519\u8bef\uff1a</strong><br>" + string6;
            return string8;
        }
        catch (Exception exception) {
            string3 = "<strong>\u670d\u52a1\u7aef\u63a8\u9001\u64cd\u4f5c\u51fa\u73b0\u9519\u8bef\uff1a</strong><br>" + this.a(exception);
            return string3;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private String a(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        String string = new String(byteArrayOutputStream.toByteArray());
        IOUtils.closeQuietly((OutputStream)printStream);
        IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
        string = string.replaceAll("\n", "<br>");
        return string;
    }

    public void removeDeployKnowledgePackage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            throw new NoPermissionException();
        }
        String string = httpServletRequest.getParameter("project");
        String string2 = (string = Utils.decodeURL((String)string)) + "/" + Utils.decodeURL((String)httpServletRequest.getParameter("packageId"));
        if (string2.startsWith("/")) {
            string2 = string2.substring(1, string2.length());
        }
        this.g.removeDeployKnowledgePackge(string2);
    }

    public void removeKnowledgePackage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            throw new NoPermissionException();
        }
        String string = httpServletRequest.getParameter("project");
        String string2 = (string = Utils.decodeURL((String)string)) + "/" + Utils.decodeURL((String)httpServletRequest.getParameter("packageId"));
        if (string2.startsWith("/")) {
            string2 = string2.substring(1, string2.length());
        }
        String string3 = httpServletRequest.getParameter("version");
        this.g.removeKnowledgePackge(string2, string3);
    }

    public void activeKnowledgePackage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            throw new NoPermissionException();
        }
        String string = httpServletRequest.getParameter("project");
        String string2 = (string = Utils.decodeURL((String)string)) + "/" + Utils.decodeURL((String)httpServletRequest.getParameter("packageId"));
        if (string2.startsWith("/")) {
            string2 = string2.substring(1, string2.length());
        }
        String string3 = httpServletRequest.getParameter("version");
        if (this.d != null) {
            this.d.beforeActive(string2, string3);
        }
        this.g.activeKnowledgePackage(string2, string3);
        VersionFile versionFile = this.g.getActivedKnowledgePackge(string2);
        KnowledgePackage knowledgePackage = this.g.getKnowledgePackge(string2, versionFile.getName());
        CacheUtils.getKnowledgeCache().putKnowledge(string2, knowledgePackage);
        if (this.d != null) {
            this.d.afterActive(knowledgePackage, string3);
        }
        this.i.reloadServersKnowledgePackage(principal, string2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.a(string, hashMap);
        this.writeObjectToJson(httpServletResponse, hashMap);
    }

    public void loadVersions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            throw new NoPermissionException();
        }
        String string = httpServletRequest.getParameter("project");
        String string2 = (string = Utils.decodeURL((String)string)) + "/" + Utils.decodeURL((String)httpServletRequest.getParameter("packageId"));
        if (string2.startsWith("/")) {
            string2 = string2.substring(1, string2.length());
        }
        List<VersionFile> list = this.g.getKnowledgePackges(string2);
        this.writeObjectToJson(httpServletResponse, list);
    }

    public void loadPackageVersionFiles(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            throw new NoPermissionException();
        }
        String string = httpServletRequest.getParameter("project");
        String string2 = (string = Utils.decodeURL((String)string)) + "/" + Utils.decodeURL((String)httpServletRequest.getParameter("packageId"));
        if (string2.startsWith("/")) {
            string2 = string2.substring(1, string2.length());
        }
        String string3 = httpServletRequest.getParameter("sourceVersion");
        Map<String, Object> map = this.g.loadKnowledgePackageFiles(string2, string3);
        String string4 = httpServletRequest.getParameter("targetVersion");
        Map<String, Object> map2 = this.g.loadKnowledgePackageFiles(string2, string4);
        HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
        hashMap.put("sourceData", map);
        hashMap.put("targetData", map2);
        this.writeObjectToJson(httpServletResponse, hashMap);
    }

    public void refreshKnowledgeCache(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        if (!principal.isAdmin()) {
            throw new NoPermissionException();
        }
        String string = httpServletRequest.getParameter("active");
        boolean bl = true;
        if (StringUtils.isNotBlank((String)string) && string.equals("0")) {
            bl = false;
        }
        String string2 = httpServletRequest.getParameter("version");
        ContextHolder.putData((String)"_version", (Object)string2);
        String string3 = httpServletRequest.getParameter("project");
        string3 = Utils.decodeURL((String)string3);
        String string4 = string3 + "/" + Utils.decodeURL((String)httpServletRequest.getParameter("packageId"));
        if (string4.startsWith("/")) {
            string4 = string4.substring(1, string4.length());
        }
        String string5 = httpServletRequest.getParameter("comment");
        if (this.d != null) {
            this.d.beforePublish(string4, string5, bl);
        }
        KnowledgePackage knowledgePackage = this.b.rebuildKnowledgePackage(string4);
        if (bl) {
            CacheUtils.getKnowledgeCache().putKnowledge(string4, knowledgePackage);
        }
        this.g.saveKnowledgePackage(string4, knowledgePackage, string5, principal.getName(), bl);
        if (this.d != null) {
            this.d.afterPublish(knowledgePackage, string5, bl);
        }
        this.i.reloadServersKnowledgePackage(principal, string4);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.a(string3, hashMap);
        this.writeObjectToJson(httpServletResponse, hashMap);
    }

    private void a(String string, Map<String, Object> map) throws Exception {
        List<ClientConfig> list = this.a.loadClientConfigs(string, false);
        if (list.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 1;
            for (ClientConfig clientConfig : list) {
                if (n > 1) {
                    stringBuffer.append("<br>");
                }
                stringBuffer.append(clientConfig.getName() + "\uff1a" + clientConfig.getClient());
                ++n;
            }
            map.put("clientInfo", stringBuffer.toString());
        }
    }

    public void loadForTestVariableCategories(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("version");
        if (string != null) {
            ContextHolder.putData((String)"_version", (Object)string);
        }
        KnowledgeBase knowledgeBase = this.a(httpServletRequest);
        List list = knowledgeBase.getResourceLibrary().getVariableCategories();
        this.f.put(httpServletRequest, VCS_KEY, list);
        this.writeObjectToJson(httpServletResponse, list);
    }

    private KnowledgeBase a(HttpServletRequest httpServletRequest) throws IOException {
        KnowledgeBase knowledgeBase;
        String string = httpServletRequest.getParameter("files");
        string = Utils.decodeURL((String)string);
        ResourceBase resourceBase = this.c.newResourceBase();
        for (String string2 : knowledgeBase = string.split(";")) {
            String[] stringArray = string2.split(",");
            string2 = stringArray[0];
            String string3 = null;
            if (stringArray.length > 1) {
                string3 = stringArray[1];
            }
            resourceBase.addResource(string2, string3);
        }
        KnowledgeBase knowledgeBase2 = this.c.buildKnowledgeBase(resourceBase);
        this.f.remove(httpServletRequest, KB_KEY);
        this.f.put(httpServletRequest, KB_KEY, knowledgeBase2);
        return knowledgeBase2;
    }

    public void admin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("admin", principal.isAdmin());
        this.writeObjectToJson(httpServletResponse, hashMap);
    }

    public void saveResourcePackages(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("project");
        string = Utils.decodeURL((String)string);
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        ResourcePackageUpdater resourcePackageUpdater = new ResourcePackageUpdater(this.a, this.g);
        resourcePackageUpdater.doUpdate(httpServletRequest, principal);
        this.g.resetProjectResourcePackagesTag(string);
        this.h.cleanResourcePackages(string);
        this.h.storeResourcePackages(this.g.loadProjectResourcePackages(string));
        this.h.resetResourcePackageTag(string, this.g.getProjectResourcePackagesTag(string));
    }

    private List<VariableCategory> a(List<Map<String, Object>> list) {
        ArrayList<VariableCategory> arrayList = new ArrayList<VariableCategory>();
        for (Map<String, Object> map : list) {
            VariableCategory variableCategory = new VariableCategory();
            arrayList.add(variableCategory);
            for (String string : map.keySet()) {
                List list2;
                if (string.equals("name")) {
                    variableCategory.setName((String)map.get(string));
                    continue;
                }
                if (string.equals("clazz")) {
                    variableCategory.setClazz((String)map.get(string));
                    continue;
                }
                if (!string.equals("variables") || (list2 = (List)map.get(string)) == null) continue;
                for (Map map2 : list2) {
                    Variable variable = new Variable();
                    variableCategory.addVariable(variable);
                    for (String string2 : map2.keySet()) {
                        if (string2.equals("name")) {
                            variable.setName((String)map2.get(string2));
                            continue;
                        }
                        if (string2.equals("label")) {
                            variable.setLabel((String)map2.get(string2));
                            continue;
                        }
                        if (string2.equals("type")) {
                            variable.setType(Datatype.valueOf((String)((String)map2.get(string2))));
                            continue;
                        }
                        if (!string2.equals("defaultValue")) continue;
                        variable.setDefaultValue((String)map2.get(string2));
                    }
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public void doJsonQuickTest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        void var16_23;
        Object object;
        String string = httpServletRequest.getParameter("input");
        String string2 = httpServletRequest.getParameter("output");
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(Configure.getDateFormat());
        objectMapper.getDeserializationConfig().withDateFormat((DateFormat)simpleDateFormat);
        objectMapper.setDateFormat((DateFormat)simpleDateFormat);
        KnowledgeBase knowledgeBase = this.a(httpServletRequest);
        ResourceLibrary resourceLibrary = knowledgeBase.getResourceLibrary();
        List list = (List)objectMapper.readValue(string, ArrayList.class);
        List list2 = (List)objectMapper.readValue(string2, ArrayList.class);
        List<Map<String, Object>> list3 = this.a(list, resourceLibrary.getVariableCategories());
        KnowledgePackage knowledgePackage = knowledgeBase.getKnowledgePackage();
        KnowledgeSession knowledgeSession = KnowledgeSessionFactory.newKnowledgeSession((KnowledgePackage)knowledgePackage);
        Map<String, Object> ruleExecutionResponse2 = null;
        for (Map<String, Object> ruleExecutionResponse3 : list3) {
            if (ruleExecutionResponse3 instanceof GeneralEntity) {
                knowledgeSession.insert(ruleExecutionResponse3);
                continue;
            }
            if (ruleExecutionResponse2 == null) {
                ruleExecutionResponse2 = ruleExecutionResponse3;
                continue;
            }
            ruleExecutionResponse2.putAll(ruleExecutionResponse3);
        }
        Map map = knowledgeBase.getFlowMap();
        Object var16_17 = null;
        if (map != null && map.size() > 0) {
            object = (String)map.keySet().iterator().next();
            if (ruleExecutionResponse2 != null) {
                FlowExecutionResponse flowExecutionResponse = knowledgeSession.startProcess((String)object, ruleExecutionResponse2);
            } else {
                FlowExecutionResponse flowExecutionResponse = knowledgeSession.startProcess((String)object);
            }
        } else if (ruleExecutionResponse2 != null) {
            RuleExecutionResponse ruleExecutionResponse = knowledgeSession.fireRules(ruleExecutionResponse2);
        } else {
            RuleExecutionResponse ruleExecutionResponse = knowledgeSession.fireRules();
        }
        knowledgeSession.writeLogFile();
        object = this.a((List<Map<String, Object>>)list2, list3, knowledgeSession.getParameters());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("output", object);
        hashMap.put("time", var16_23.getDuration());
        String string3 = ConsoleKeyHolder.getKey();
        if (string3 != null) {
            hashMap.put("logUrl", "console?key=" + string3 + "");
        }
        ConsoleKeyHolder.clean();
        this.writeObjectToJson(httpServletResponse, hashMap);
    }

    public void packageStateChange(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("packageId");
        String string2 = httpServletRequest.getParameter("project");
        if ((string2 = Utils.decodeURL((String)string2)).startsWith("/")) {
            string2 = string2.substring(1, string2.length());
        }
        boolean bl = Boolean.valueOf(httpServletRequest.getParameter("state"));
        String string3 = string2 + "/" + string;
        this.g.knowledgePackageStateChange(string3, bl);
    }

    /*
     * WARNING - void declaration
     */
    public void doQuickTest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        void var16_23;
        Object object;
        String string = httpServletRequest.getParameter("input");
        String string2 = httpServletRequest.getParameter("output");
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(Configure.getDateFormat());
        objectMapper.getDeserializationConfig().withDateFormat((DateFormat)simpleDateFormat);
        objectMapper.setDateFormat((DateFormat)simpleDateFormat);
        KnowledgeBase knowledgeBase = this.a(httpServletRequest);
        ResourceLibrary resourceLibrary = knowledgeBase.getResourceLibrary();
        List list = (List)objectMapper.readValue(string, ArrayList.class);
        List list2 = (List)objectMapper.readValue(string2, ArrayList.class);
        List<Map<String, Object>> list3 = this.b(list, resourceLibrary.getVariableCategories());
        KnowledgePackage knowledgePackage = knowledgeBase.getKnowledgePackage();
        KnowledgeSession knowledgeSession = KnowledgeSessionFactory.newKnowledgeSession((KnowledgePackage)knowledgePackage);
        Map<String, Object> ruleExecutionResponse2 = null;
        for (Map<String, Object> ruleExecutionResponse3 : list3) {
            if (ruleExecutionResponse3 instanceof GeneralEntity) {
                knowledgeSession.insert(ruleExecutionResponse3);
                continue;
            }
            if (ruleExecutionResponse2 == null) {
                ruleExecutionResponse2 = ruleExecutionResponse3;
                continue;
            }
            ruleExecutionResponse2.putAll(ruleExecutionResponse3);
        }
        Map map = knowledgeBase.getFlowMap();
        Object var16_17 = null;
        if (map != null && map.size() > 0) {
            object = (String)map.keySet().iterator().next();
            if (ruleExecutionResponse2 != null) {
                FlowExecutionResponse flowExecutionResponse = knowledgeSession.startProcess((String)object, ruleExecutionResponse2);
            } else {
                FlowExecutionResponse flowExecutionResponse = knowledgeSession.startProcess((String)object);
            }
        } else if (ruleExecutionResponse2 != null) {
            RuleExecutionResponse ruleExecutionResponse = knowledgeSession.fireRules(ruleExecutionResponse2);
        } else {
            RuleExecutionResponse ruleExecutionResponse = knowledgeSession.fireRules();
        }
        knowledgeSession.writeLogFile();
        object = this.b(list2, list3, knowledgeSession.getParameters());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("output", object);
        hashMap.put("time", var16_23.getDuration());
        String string3 = ConsoleKeyHolder.getKey();
        if (string3 != null) {
            hashMap.put("logUrl", "console?key=" + string3 + "");
        }
        ConsoleKeyHolder.clean();
        this.writeObjectToJson(httpServletResponse, hashMap);
    }

    private List<Map<String, Object>> a(List<Map<String, Object>> list, List<Map<String, Object>> list2, Map<String, Object> map) throws Exception {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map2 : list) {
            Object object;
            String string = (String)map2.get("categoryName");
            if (string.equals("\u53c2\u6570")) {
                object = new HashMap();
                arrayList.add((Map<String, Object>)object);
                object.put("name", string);
                object.put("fields", map);
                continue;
            }
            object = (String)map2.get("categoryClass");
            for (Map<String, Object> map3 : list2) {
                String string2;
                if (!(map3 instanceof GeneralEntity) || !((String)object).equals(string2 = ((GeneralEntity)map3).getTargetClass())) continue;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                arrayList.add(hashMap);
                hashMap.put("name", string);
                hashMap.put("fields", map3);
            }
        }
        return arrayList;
    }

    private List<Map<String, Object>> b(List<Map<String, Object>> list, List<Map<String, Object>> list2, Map<String, Object> map) throws Exception {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map2 : list) {
            Object object;
            HashMap<String, Object> hashMap;
            Object object2;
            List list3 = (List)map2.get("fields");
            if (list3 == null || list3.size() == 0) continue;
            String string = (String)map2.get("categoryName");
            if (string.equals("\u53c2\u6570")) {
                object2 = new HashMap();
                arrayList.add((Map<String, Object>)object2);
                object2.put("name", string);
                ArrayList arrayList2 = new ArrayList();
                object2.put("fields", arrayList2);
                for (Object object3 : list3) {
                    hashMap = new HashMap();
                    arrayList2.add(hashMap);
                    object = (String)object3.get("name");
                    Iterator iterator = Utils.getObjectProperty(map, (String)object);
                    hashMap.put("name", (String)object3.get("label"));
                    hashMap.put("value", iterator);
                }
                continue;
            }
            object2 = (String)map2.get("categoryClass");
            for (Map<String, Object> map3 : list2) {
                Object object3;
                if (!(map3 instanceof GeneralEntity) || !((String)object2).equals(object3 = ((GeneralEntity)map3).getTargetClass())) continue;
                hashMap = new HashMap<String, Object>();
                arrayList.add(hashMap);
                hashMap.put("name", string);
                object = new ArrayList();
                hashMap.put("fields", object);
                for (Map map4 : list3) {
                    HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                    object.add(hashMap2);
                    String string2 = (String)map4.get("name");
                    Object object4 = Utils.getObjectProperty((Object)map3, (String)string2);
                    hashMap2.put("name", (String)map4.get("label"));
                    hashMap2.put("value", object4);
                }
            }
        }
        return arrayList;
    }

    private List<Map<String, Object>> a(List<Map<String, Object>> list, List<VariableCategory> list2) throws Exception {
        HashSet<Object> hashSet = new HashSet<Object>();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : list) {
            Object object;
            GeneralEntity generalEntity = null;
            String string = (String)map.get("name");
            List list3 = null;
            if (string.equals("\u53c2\u6570")) {
                generalEntity = new HashMap();
                hashSet.add(string);
            } else {
                object = null;
                for (VariableCategory variableCategory : list2) {
                    if (!variableCategory.getName().equals(string)) continue;
                    object = variableCategory.getClazz();
                    list3 = variableCategory.getVariables();
                    break;
                }
                if (object == null) {
                    throw new RuleException("\u4e0d\u80fd\u627e\u5230\u8f93\u5165\u53d8\u91cf\u3010" + string + "\u3011\u5728\u53d8\u91cf\u5e93\u91cc\u5bf9\u5e94\u7684\u5b9a\u4e49\u4fe1\u606f\uff01");
                }
                generalEntity = new GeneralEntity(object);
                hashSet.add(object);
            }
            arrayList.add((Map<String, Object>)generalEntity);
            object = (Map)map.get("fields");
            block2: for (String string2 : object.keySet()) {
                Object object22;
                Object object3 = null;
                for (Object object22 : list3) {
                    if (!object22.getName().equals(string2) && !object22.getLabel().equals(string2)) continue;
                    object3 = object22;
                    break;
                }
                if (object3 == null) {
                    throw new RuleException("\u4e0d\u80fd\u627e\u5230\u8f93\u5165\u53d8\u91cf\u3010" + string + "\u3011\u4e2d\u5b9a\u4e49\u7684\u5b57\u6bb5\u3010" + string2 + "\u3011\u5728\u53d8\u91cf\u5e93\u4e2d\u5bf9\u5e94\u7684\u5b9a\u4e49\u4fe1\u606f\uff01");
                }
                Datatype datatype = object3.getType();
                object22 = object.get(string2);
                Object object4 = null;
                object4 = datatype.equals((Object)Datatype.List) || datatype.equals((Object)Datatype.Object) || datatype.equals((Object)Datatype.Set) || datatype.equals((Object)Datatype.Map) ? JsonBuilder.getInstance().buildComplexObject(object22, list2) : datatype.convert(object22);
                String[] stringArray = string2.split("\\.");
                Object object5 = generalEntity;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    if (i == stringArray.length - 1) {
                        Utils.setObjectProperty((Object)object5, (String)string3, (Object)object4);
                        continue block2;
                    }
                    HashMap hashMap = Utils.getObjectProperty((Object)object5, (String)string3);
                    if (hashMap == null) {
                        hashMap = new HashMap();
                        Utils.setObjectProperty((Object)object5, (String)string3, hashMap);
                    }
                    object5 = hashMap;
                }
            }
        }
        return arrayList;
    }

    private List<Map<String, Object>> b(List<Map<String, Object>> list, List<VariableCategory> list2) throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : list) {
            Object object;
            GeneralEntity generalEntity = null;
            String string = (String)map.get("categoryName");
            if (string.equals("\u53c2\u6570")) {
                generalEntity = new HashMap();
                hashSet.add(string);
            } else {
                object = (String)map.get("categoryClass");
                generalEntity = new GeneralEntity((String)object);
                hashSet.add((String)object);
            }
            arrayList.add((Map<String, Object>)generalEntity);
            object = (List)map.get("fields");
            this.a((List<Map<String, Object>>)object, (Map<String, Object>)generalEntity, list2);
        }
        return arrayList;
    }

    private void a(List<Map<String, Object>> list, Map<String, Object> map, List<VariableCategory> list2) throws Exception {
        if (list == null) {
            return;
        }
        block0: for (Map<String, Object> map2 : list) {
            String string = (String)map2.get("name");
            String string2 = (String)map2.get("value");
            if (string2 == null) continue;
            String string3 = (String)map2.get("type");
            Datatype datatype = Datatype.parse((String)string3);
            Object object = null;
            if (datatype.equals((Object)Datatype.List) || datatype.equals((Object)Datatype.Object) || datatype.equals((Object)Datatype.Set) || datatype.equals((Object)Datatype.Map)) {
                object = JsonBuilder.getInstance().buildComplexObject(string2, list2);
                map.put(string, object);
            } else {
                object = datatype.convert((Object)string2);
            }
            String[] stringArray = string.split("\\.");
            Object object2 = map;
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                if (i == stringArray.length - 1) {
                    Utils.setObjectProperty(object2, (String)string4, (Object)object);
                    continue block0;
                }
                HashMap hashMap = Utils.getObjectProperty(object2, (String)string4);
                if (hashMap == null) {
                    hashMap = new HashMap();
                    Utils.setObjectProperty((Object)object2, (String)string4, hashMap);
                }
                object2 = hashMap;
            }
        }
    }

    public void doTest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string;
        List list;
        List list22;
        KnowledgeSession knowledgeSession2;
        Object object;
        String string2 = httpServletRequest.getParameter("data");
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(Configure.getDateFormat());
        objectMapper.getDeserializationConfig().withDateFormat((DateFormat)simpleDateFormat);
        objectMapper.setDateFormat((DateFormat)simpleDateFormat);
        List list3 = (List)objectMapper.readValue(string2, ArrayList.class);
        List<VariableCategory> list4 = this.a(list3);
        HashMap<VariableCategory, KnowledgeBase> hashMap = new HashMap<VariableCategory, KnowledgeBase>();
        for (VariableCategory variableCategory : list4) {
            String string3 = variableCategory.getClazz();
            object = null;
            object = variableCategory.getName().equals("\u53c2\u6570") ? new HashMap() : new GeneralEntity(string3);
            for (KnowledgeSession knowledgeSession2 : variableCategory.getVariables()) {
                this.a(object, (Variable)knowledgeSession2);
            }
            hashMap.put(variableCategory, (KnowledgeBase)object);
        }
        String string4 = httpServletRequest.getParameter("flowId");
        long l = System.currentTimeMillis();
        object = (KnowledgeBase)this.f.get(httpServletRequest, KB_KEY);
        if (object == null) {
            object = this.a(httpServletRequest);
        }
        KnowledgePackage knowledgePackage = object.getKnowledgePackage();
        knowledgeSession2 = KnowledgeSessionFactory.newKnowledgeSession((KnowledgePackage)knowledgePackage);
        Map map = null;
        for (Object object2 : hashMap.values()) {
            if (!(object2 instanceof GeneralEntity) && object2 instanceof HashMap) {
                map = (Map)object2;
                continue;
            }
            knowledgeSession2.insert(object2);
        }
        if (StringUtils.isNotEmpty((String)string4)) {
            if (map != null) {
                knowledgeSession2.startProcess(string4, map);
            } else {
                knowledgeSession2.startProcess(string4);
            }
        } else if (map == null) {
            knowledgeSession2.fireRules();
        } else {
            knowledgeSession2.fireRules(map);
        }
        for (Object object2 : hashMap.keySet()) {
            Object object3 = hashMap.get(object2);
            if (object3 == null) continue;
            if (object3 instanceof Map && !(object3 instanceof GeneralEntity)) {
                object3 = knowledgeSession2.getParameters();
            }
            for (List list22 : object2.getVariables()) {
                this.a(object3, (Variable)list22, objectMapper);
            }
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        knowledgeSession2.writeLogFile();
        list22 = knowledgeSession2.getLogManager().buildMatchedRuleLog();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u8017\u65f6\uff1a" + l3 + "ms<br>");
        stringBuffer.append("<div style='color:#9E9E9E;font-size:12px'>\u4ee5\u4e0b\u4e3a\u6267\u884c\u65e5\u5fd7\u4fe1\u606f\uff0c\u65e5\u5fd7\u4fe1\u606f\u6709\u65e0\u53d6\u51b3\u4e8eurule.debug\u5c5e\u6027\u662f\u5426\u7f6e\u8bbe\u7f6e\u4e3atrue\uff0c\u4e14\u89c4\u5219\u7684\u201c\u5141\u8bb8\u8c03\u8bd5\u4fe1\u606f\u8f93\u51fa\u201d\u5c5e\u6027\u662f\u5426\u8bbe\u7f6e\u4e3atrue</div>");
        if (list22.size() > 0) {
            stringBuffer.append("<br>\u5339\u914d\u7684\u89c4\u5219\u5171" + list22.size() + "\u4e2a<br>");
            stringBuffer.append("<span style='color:blue'>");
            this.a(list22, stringBuffer);
            stringBuffer.append("</span>");
        }
        if ((list = knowledgeSession2.getLogManager().buildFlowNodeData()).size() > 0) {
            stringBuffer.append("<br><br>\u7ecf\u8fc7\u7684\u89c4\u5219\u6d41\u8282\u70b9\u6570\u91cf\u4e3a\uff1a" + list.size() + "\u4e2a<br>");
            stringBuffer.append("<span style='color:green'>");
            this.b(list, stringBuffer);
            stringBuffer.append("</span>");
        }
        if ((string = ConsoleKeyHolder.getKey()) != null) {
            stringBuffer.append("<br><br><a href='console?key=" + string + "' target='_blank'>\u67e5\u770b\u8be6\u7ec6\u65e5\u5fd7</a>");
        }
        ConsoleKeyHolder.clean();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("info", stringBuffer.toString());
        hashMap2.put("data", list4);
        this.writeObjectToJson(httpServletResponse, hashMap2);
    }

    private void a(Object object, Variable variable) {
        String string;
        String string2 = variable.getName();
        if (string2.indexOf(".") != -1) {
            this.a(object, string2);
        }
        if (StringUtils.isBlank((String)(string = variable.getDefaultValue()))) {
            return;
        }
        Datatype datatype = variable.getType();
        if (datatype.equals((Object)Datatype.List)) {
            Utils.setObjectProperty((Object)object, (String)string2, this.a(string));
        } else if (datatype.equals((Object)Datatype.Set)) {
            Utils.setObjectProperty((Object)object, (String)string2, this.b(string));
        } else {
            if (datatype.equals((Object)Datatype.Map)) {
                return;
            }
            Object object2 = datatype.convert((Object)string);
            if (datatype.equals((Object)Datatype.Enum) && object2 instanceof String && object instanceof GeneralEntity) {
                GeneralEntity generalEntity = (GeneralEntity)object;
                String string3 = generalEntity.getTargetClass();
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(string3);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (clazz != null) {
                    try {
                        Field field = clazz.getDeclaredField(string2);
                        String string4 = field.getType().getName();
                        Class<?> clazz2 = Class.forName(string4);
                        object2 = Enum.valueOf(clazz2, object2.toString());
                    }
                    catch (Exception exception) {
                        throw new RuleException(exception);
                    }
                }
            }
            Utils.setObjectProperty((Object)object, (String)string2, (Object)object2);
        }
    }

    private List<Object> a(String string) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            if (string.startsWith("[") && string.endsWith("]")) {
                return (List)objectMapper.readValue(string, ArrayList.class);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Map map = (Map)objectMapper.readValue(string, HashMap.class);
            if (map.containsKey("rows")) {
                List list = (List)map.get("rows");
                String string2 = (String)map.get("type");
                Object v = map.get("rows");
                if (string2.equals("Integer")) {
                    List list2 = (List)v;
                    for (Map map2 : list2) {
                        Object v2 = map2.get("value");
                        if (v2 == null) continue;
                        BigDecimal bigDecimal = Utils.toBigDecimal(v2);
                        arrayList.add(bigDecimal.intValue());
                    }
                } else if (string2.equals("Double")) {
                    List list3 = (List)v;
                    for (Map map3 : list3) {
                        Object v3 = map3.get("value");
                        if (v3 == null) continue;
                        BigDecimal bigDecimal = Utils.toBigDecimal(v3);
                        arrayList.add(bigDecimal.doubleValue());
                    }
                } else if (string2.equals("Float")) {
                    List list4 = (List)v;
                    for (Map map4 : list4) {
                        Object v4 = map4.get("value");
                        if (v4 == null) continue;
                        BigDecimal bigDecimal = Utils.toBigDecimal(v4);
                        arrayList.add(Float.valueOf(bigDecimal.floatValue()));
                    }
                } else if (string2.equals("String")) {
                    List list5 = (List)v;
                    for (Map map5 : list5) {
                        Object v5 = map5.get("value");
                        if (v5 == null) continue;
                        arrayList.add(v5.toString());
                    }
                } else {
                    for (Object e : list) {
                        if (!(e instanceof Map)) continue;
                        GeneralEntity generalEntity = new GeneralEntity(string2);
                        generalEntity.putAll((Map)e);
                        arrayList.add(generalEntity);
                    }
                }
                return arrayList;
            }
            return null;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    private Set<Object> b(String string) {
        try {
            HashSet<Object> hashSet = new HashSet<Object>();
            ObjectMapper objectMapper = new ObjectMapper();
            Map map = (Map)objectMapper.readValue(string, HashMap.class);
            if (map.containsKey("rows")) {
                List list = (List)map.get("rows");
                String string2 = (String)map.get("type");
                Object v = map.get("rows");
                if (string2.equals("Integer")) {
                    List list2 = (List)v;
                    for (Map map2 : list2) {
                        Object v2 = map2.get("value");
                        if (v2 == null) continue;
                        BigDecimal bigDecimal = Utils.toBigDecimal(v2);
                        hashSet.add(bigDecimal.intValue());
                    }
                } else if (string2.equals("Double")) {
                    List list3 = (List)v;
                    for (Map map3 : list3) {
                        Object v3 = map3.get("value");
                        if (v3 == null) continue;
                        BigDecimal bigDecimal = Utils.toBigDecimal(v3);
                        hashSet.add(bigDecimal.doubleValue());
                    }
                } else if (string2.equals("Float")) {
                    List list4 = (List)v;
                    for (Map map4 : list4) {
                        Object v4 = map4.get("value");
                        if (v4 == null) continue;
                        BigDecimal bigDecimal = Utils.toBigDecimal(v4);
                        hashSet.add(Float.valueOf(bigDecimal.floatValue()));
                    }
                } else if (string2.equals("String")) {
                    List list5 = (List)v;
                    for (Map map5 : list5) {
                        Object v5 = map5.get("value");
                        if (v5 == null) continue;
                        hashSet.add(v5.toString());
                    }
                } else {
                    for (Object e : list) {
                        if (!(e instanceof Map)) continue;
                        GeneralEntity generalEntity = new GeneralEntity((String)map.get("type"));
                        generalEntity.putAll((Map)e);
                        hashSet.add(generalEntity);
                    }
                }
                return hashSet;
            }
            return null;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    private void a(Object object, String string) {
        int n = string.indexOf(".");
        if (n == -1) {
            return;
        }
        String string2 = string.substring(0, n);
        string = string.substring(n + 1);
        try {
            Object object2 = PropertyUtils.getProperty((Object)object, (String)string2);
            if (object2 != null) {
                this.a(object2, string);
                return;
            }
            GeneralEntity generalEntity = new GeneralEntity(string2);
            PropertyUtils.setProperty((Object)object, (String)string2, (Object)generalEntity);
            this.a((Object)generalEntity, string);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    private void a(List<MatchedRuleLog> list, StringBuffer stringBuffer) {
        int n = 0;
        for (MatchedRuleLog matchedRuleLog : list) {
            if (n > 0) {
                stringBuffer.append("\uff0c<br>");
            }
            stringBuffer.append(matchedRuleLog.getRuleName() + "(" + matchedRuleLog.getRuleFile() + ")");
            ++n;
        }
    }

    private void b(List<FlowNodeLog> list, StringBuffer stringBuffer) {
        int n = 0;
        for (FlowNodeLog flowNodeLog : list) {
            if (n > 0) {
                stringBuffer.append("\uff0c<br>");
            }
            stringBuffer.append(flowNodeLog.getNodeName() + "(" + flowNodeLog.getFile() + ")");
            ++n;
        }
    }

    private void a(Object object, Variable variable, ObjectMapper objectMapper) {
        try {
            String string = variable.getName();
            Object object2 = Utils.getObjectProperty((Object)object, (String)string);
            if (object2 != null) {
                Datatype datatype = variable.getType();
                if (datatype.equals((Object)Datatype.List) || datatype.equals((Object)Datatype.Set) || datatype.equals((Object)Datatype.Object) || datatype.equals((Object)Datatype.Map)) {
                    String string2 = objectMapper.writeValueAsString(object2);
                    variable.setDefaultValue(string2);
                } else {
                    String string3 = datatype.convertObjectToString(object2);
                    variable.setDefaultValue(string3);
                }
            }
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        Collection collection = applicationContext.getBeansOfType(KnowledgePackagePublishListener.class).values();
        if (collection.size() > 0) {
            this.d = (KnowledgePackagePublishListener)collection.iterator().next();
        }
    }

    public void setClusterRepositoryService(ClusterRepositoryService clusterRepositoryService) {
        this.i = clusterRepositoryService;
    }

    public void setResourcePackageCache(ResourcePackageCache resourcePackageCache) {
        this.h = resourcePackageCache;
    }

    public void setKnowledgePackageService(KnowledgePackageService knowledgePackageService) {
        this.b = knowledgePackageService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.a = repositoryService;
    }

    public void setKnowledgeBuilder(KnowledgeBuilder knowledgeBuilder) {
        this.c = knowledgeBuilder;
    }

    public void setHttpSessionKnowledgeCache(HttpSessionKnowledgeCache httpSessionKnowledgeCache) {
        this.f = httpSessionKnowledgeCache;
    }

    public void setKnowledgePackageRepositoryService(KnowledgePackageRepositoryService knowledgePackageRepositoryService) {
        this.g = knowledgePackageRepositoryService;
    }

    public void setRemoteDynamicJarsBuilder(RemoteDynamicJarsBuilder remoteDynamicJarsBuilder) {
        this.e = remoteDynamicJarsBuilder;
    }

    @Override
    public String url() {
        return "/packageeditor";
    }
}

