/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.ruleset;

import com.bstek.urule.PropertyConfigurer;
import com.bstek.urule.Splash;
import com.bstek.urule.Utils;
import com.bstek.urule.console.EnvironmentUtils;
import com.bstek.urule.console.Principal;
import com.bstek.urule.console.repository.Repository;
import com.bstek.urule.console.repository.RepositoryService;
import com.bstek.urule.console.repository.model.FileType;
import com.bstek.urule.console.repository.model.RepositoryFile;
import com.bstek.urule.console.repository.model.Type;
import com.bstek.urule.console.servlet.DesignerConfigure;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.console.servlet.RequestContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.tika.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class RuleSetServletEditorHandler
extends RenderPageServletHandler {
    private RepositoryService a;

    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.retriveMethod(httpServletRequest);
        if (string != null) {
            this.invokeMethod(string, httpServletRequest, httpServletResponse);
        } else {
            Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("isAdmin", (Object)principal.isAdmin());
            velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
            velocityContext.put("version", (Object)Splash.getVersion());
            velocityContext.put("constantLink", (Object)DesignerConfigure.constantLink);
            velocityContext.put("variableLink", (Object)DesignerConfigure.variableLink);
            velocityContext.put("_date_", (Object)_DATE);
            velocityContext.put("_lis_", (Object)Splash.getFetchVersion());
            String string2 = httpServletRequest.getParameter("file");
            string2 = Utils.decodeURL((String)string2);
            String string3 = this.buildProjectNameFromFile(string2);
            if (string3 != null) {
                velocityContext.put("project", (Object)string3);
            }
            velocityContext.put("showFileExtensionName", (Object)PropertyConfigurer.getProperty((String)"urule.show.fileExtensionName"));
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/ruleset-editor.html", "utf-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
            printWriter.close();
        }
    }

    public void loadProjectPendedGroups(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("project");
        string = Utils.decodeURL((String)string);
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        Repository repository = this.a.loadRepository(string, principal, false, new FileType[]{FileType.Ruleset}, null);
        RepositoryFile repositoryFile = repository.getRootFile();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.a(repositoryFile, hashMap);
        this.writeObjectToJson(httpServletResponse, hashMap);
    }

    private void a(RepositoryFile repositoryFile, Map<String, String> map) throws Exception {
        Object object;
        if (repositoryFile.getType().equals((Object)Type.rule)) {
            object = repositoryFile.getFullPath();
            this.parseResourcePendedGroups((String)object, map);
        }
        if ((object = repositoryFile.getChildren()) == null) {
            return;
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            RepositoryFile repositoryFile2 = (RepositoryFile)iterator.next();
            this.a(repositoryFile2, map);
        }
    }

    protected void parseResourcePendedGroups(String string, Map<String, String> map) throws Exception {
        InputStream inputStream = this.a.readFile(string);
        SAXReader sAXReader = new SAXReader();
        Document document = sAXReader.read(inputStream);
        Element element = document.getRootElement();
        for (Object e : element.elements()) {
            String string2;
            Element element2;
            String string3;
            if (e == null || !(e instanceof Element) || !(string3 = (element2 = (Element)e).getName()).equals("rule") && !string3.equals("loop-rule") || !StringUtils.isNotBlank((String)(string2 = element2.attributeValue("pended-group")))) continue;
            if (map.containsKey(string2)) {
                String string4 = map.get(string2);
                if (string4.indexOf(string) != -1) continue;
                map.put(string2, string4 + ",<br>" + string);
                continue;
            }
            map.put(string2, string);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public void searchRules(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("key");
        string = Utils.decodeURL((String)string);
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        Repository repository = this.a.loadRepository(null, principal, false, new FileType[]{FileType.Ruleset}, null);
        RepositoryFile repositoryFile = repository.getRootFile();
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        this.a(string, repositoryFile, arrayList);
        this.writeObjectToJson(httpServletResponse, arrayList);
    }

    private void a(String string, RepositoryFile repositoryFile, List<Map<String, String>> list) throws Exception {
        Object object;
        if (repositoryFile.getType().equals((Object)Type.rule)) {
            object = repositoryFile.getFullPath();
            this.parseResourceRules((String)object, string, list);
        }
        if ((object = repositoryFile.getChildren()) == null) {
            return;
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            RepositoryFile repositoryFile2 = (RepositoryFile)iterator.next();
            this.a(string, repositoryFile2, list);
        }
    }

    protected void parseResourceRules(String string, String string2, List<Map<String, String>> list) throws Exception {
        InputStream inputStream = this.a.readFile(string);
        SAXReader sAXReader = new SAXReader();
        Document document = sAXReader.read(inputStream);
        Element element = document.getRootElement();
        for (Object e : element.elements()) {
            String string3;
            Element element2;
            String string4;
            if (e == null || !(e instanceof Element) || !(string4 = (element2 = (Element)e).getName()).equals("rule") && !string4.equals("loop-rule") || (string3 = element2.attributeValue("name")).indexOf(string2) <= -1) continue;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", string3);
            hashMap.put("path", string);
            list.add(hashMap);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.a = repositoryService;
    }

    @Override
    public String url() {
        return "/ruleseteditor";
    }
}

