/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.scorecard;

import com.bstek.urule.console.repository.ProjectVariable;
import com.bstek.urule.console.repository.model.FileType;
import com.bstek.urule.console.servlet.scorecard.CellData;
import com.bstek.urule.console.servlet.scorecard.RowData;
import com.bstek.urule.console.servlet.scorecard.ScoreTableData;
import com.bstek.urule.console.servlet.scorecard.TableHeader;
import com.bstek.urule.dsl.DSLRuleSetBuilder;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.library.variable.Variable;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.model.rule.SimpleValue;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.VariableCategoryValue;
import com.bstek.urule.model.rule.VariableValue;
import com.bstek.urule.model.rule.lhs.Criteria;
import com.bstek.urule.model.rule.lhs.Criterion;
import com.bstek.urule.model.rule.lhs.Junction;
import com.bstek.urule.model.rule.lhs.Or;
import com.bstek.urule.model.scorecard.ScorecardDefinition;
import com.bstek.urule.parse.deserializer.ScorecardDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;

public class ScoreTableBuilder {
    private ScoreTableData a;
    private DSLRuleSetBuilder b;
    private List<ProjectVariable> c;
    private ScorecardDeserializer d;
    private List<String> e = new ArrayList<String>();

    public ScoreTableBuilder(ScoreTableData scoreTableData, DSLRuleSetBuilder dSLRuleSetBuilder, List<ProjectVariable> list, ScorecardDeserializer scorecardDeserializer) {
        this.a = scoreTableData;
        this.b = dSLRuleSetBuilder;
        this.c = list;
        this.d = scorecardDeserializer;
    }

    public ScorecardDefinition buildTable() {
        try {
            String string = this.a();
            Document document = DocumentHelper.parseText((String)string);
            return this.d.deserialize(document.getRootElement());
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String a() throws IOException {
        Object object;
        List<CellData> list;
        StringBuilder stringBuilder = new StringBuilder();
        List<TableHeader> list2 = this.a.getHeaders();
        TableHeader tableHeader = this.a(list2, false, false);
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuilder.append("<scorecard weight-support=\"false\" name=\"\u4eceExcel\u4e2d\u5bfc\u5165\u7684\u8bc4\u5206\u5361\" attr-col-width=\"200\" attr-col-name=\"\u5c5e\u6027\" attr-col-category=\"" + tableHeader.getName() + "\" condition-col-width=\"220\" condition-col-name=\"\u6761\u4ef6\" score-col-width=\"180\" score-col-name=\"\u5206\u503c\" scoring-type=\"sum\" assign-target-type=\"none\">");
        List<RowData> list3 = this.a.getRows();
        int n = 2;
        for (RowData object2 : list3) {
            void var11_22;
            list = object2.getCells();
            Object object3 = null;
            for (CellData cellData : list) {
                object = cellData.getHeader();
                if (((TableHeader)object).isCondition() || ((TableHeader)object).isScore()) continue;
                object3 = cellData;
                break;
            }
            if (object3 == null) continue;
            stringBuilder.append("<attribute-row row-number=\"" + n + "\">");
            int n2 = ((CellData)object3).getSpan();
            boolean bl = true;
            while (var11_22 < n2) {
                stringBuilder.append("<condition-row row-number=\"" + ++n + "\"/>");
                ++var11_22;
            }
            stringBuilder.append("</attribute-row>");
            ++n;
        }
        n = 2;
        for (int i = 0; i < list3.size(); ++i) {
            RowData rowData = list3.get(i);
            list = rowData.getCells();
            for (CellData cellData : list) {
                Variable variable;
                TableHeader tableHeader2 = cellData.getHeader();
                object = cellData.getContent();
                int n3 = cellData.getSpan();
                if (n3 == 0) {
                    n3 = 1;
                }
                if (!tableHeader2.isCondition() && !tableHeader2.isScore()) {
                    variable = this.a(tableHeader2.getName(), (String)object);
                    stringBuilder.append("<card-cell type=\"attribute\" row=\"" + n + "\" col=\"" + (cellData.getCol() + 1) + "\" var=\"" + variable.getName() + "\" var-label=\"" + variable.getLabel() + "\" datatype=\"" + variable.getDataType() + "\"");
                    stringBuilder.append("/>");
                    continue;
                }
                if (tableHeader2.isScore()) {
                    stringBuilder.append("<card-cell type=\"score\" row=\"" + n + "\" col=\"" + (cellData.getCol() + 1) + "\">");
                    stringBuilder.append("<value content=\"" + (String)object + "\" type=\"Input\"/>");
                    stringBuilder.append("</card-cell>");
                    continue;
                }
                if (tableHeader2.isCondition()) {
                    stringBuilder.append("<card-cell type=\"condition\" row=\"" + n + "\" col=\"" + (cellData.getCol() + 1) + "\">");
                    variable = this.b.buildCriterion((String)object);
                    stringBuilder.append(this.a((Criterion)variable));
                    stringBuilder.append("</card-cell>");
                    continue;
                }
                throw new RuleException("\u65e0\u6cd5\u8bc6\u522b\u7684\u5355\u5143\u683c\uff1a" + (String)object + "");
            }
            ++n;
        }
        for (String string : this.e) {
            if (string.endsWith(FileType.VariableLibrary.toString())) {
                stringBuilder.append("<import-variable-library path=\"" + string + "\"/>");
                continue;
            }
            stringBuilder.append("<import-parameter-library path=\"" + string + "\"/>");
        }
        stringBuilder.append("</scorecard>");
        return stringBuilder.toString();
    }

    private TableHeader a(List<TableHeader> list, boolean bl, boolean bl2) {
        for (TableHeader tableHeader : list) {
            if (bl && tableHeader.isScore()) {
                return tableHeader;
            }
            if (bl2 && tableHeader.isCondition()) {
                return tableHeader;
            }
            if (bl || bl2 || tableHeader.isScore() || tableHeader.isCondition()) continue;
            return tableHeader;
        }
        throw new RuleException("\u5217\u5b9a\u4e49\u5b58\u5728\u95ee\u9898\uff01");
    }

    private Variable a(String string, String string2) {
        for (ProjectVariable projectVariable : this.c) {
            List<VariableCategory> list = projectVariable.getVariableCategories();
            for (VariableCategory variableCategory : list) {
                List list2;
                if (!variableCategory.getName().equals(string)) continue;
                String string3 = "jcr:" + projectVariable.getPath();
                if (!this.e.contains(string3)) {
                    this.e.add(string3);
                }
                if ((list2 = variableCategory.getVariables()) == null) continue;
                for (Variable variable : list2) {
                    if (!variable.getLabel().equals(string2) && !variable.getName().equals(string2)) continue;
                    return variable;
                }
            }
        }
        throw new RuleException("\u53d8\u91cf[" + string + "." + string2 + "]\u5728\u5f53\u524d\u9879\u76ee\u4e2d\u672a\u5b9a\u4e49!");
    }

    private String a(Criterion criterion) {
        StringBuilder stringBuilder = new StringBuilder();
        if (criterion instanceof Junction) {
            Junction junction = (Junction)criterion;
            List list = junction.getCriterions();
            String string = "and";
            if (junction instanceof Or) {
                string = "or";
            }
            stringBuilder.append("<joint type=\"" + string + "\">");
            if (list != null) {
                for (Criterion criterion2 : list) {
                    if (!(criterion2 instanceof Criteria)) continue;
                    Criteria criteria = (Criteria)criterion2;
                    stringBuilder.append("<condition op=\"" + criteria.getOp().name() + "\">");
                    Value value = criteria.getValue();
                    String string2 = this.a(value);
                    if (string2 != null) {
                        stringBuilder.append(string2);
                    }
                    stringBuilder.append("</condition>");
                }
            }
        } else {
            stringBuilder.append("<joint type=\"and\">");
            Criteria criteria = (Criteria)criterion;
            stringBuilder.append("<condition op=\"" + criteria.getOp().name() + "\">");
            Value value = criteria.getValue();
            stringBuilder.append(this.a(value));
            stringBuilder.append("</condition>");
        }
        stringBuilder.append("</joint>");
        return stringBuilder.toString();
    }

    private String a(Value value) {
        String string;
        SimpleValue simpleValue;
        if (value == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (value instanceof SimpleValue) {
            simpleValue = (SimpleValue)value;
            string = StringEscapeUtils.escapeXml((String)simpleValue.getContent());
            stringBuilder.append("<value content=\"" + string + "\" type=\"Input\">");
        } else if (value instanceof VariableCategoryValue) {
            simpleValue = (VariableCategoryValue)value;
            string = simpleValue.getVariableCategory();
            String string2 = StringEscapeUtils.escapeXml((String)string);
            stringBuilder.append("<value content=\"" + string2 + "\" type=\"Input\">");
        } else if (value instanceof VariableValue) {
            simpleValue = (VariableValue)value;
            string = simpleValue.getVariableCategory() + "." + simpleValue.getVariableLabel();
            string = StringEscapeUtils.escapeXml((String)string);
            stringBuilder.append("<value content=\"" + string + "\" type=\"Input\">");
        } else {
            stringBuilder.append("<value content=\"\" type=\"Input\">");
        }
        simpleValue = value.getArithmetic();
        if (simpleValue == null) {
            stringBuilder.append("</value>");
            return stringBuilder.toString();
        }
        string = simpleValue.getType();
        stringBuilder.append("<complex-arith type=\"" + string.name() + "\">");
        stringBuilder.append(this.a(simpleValue.getValue()));
        stringBuilder.append("</complex-arith>");
        stringBuilder.append("</value>");
        return stringBuilder.toString();
    }
}

