/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.scorecard;

import com.bstek.urule.PropertyConfigurer;
import com.bstek.urule.Splash;
import com.bstek.urule.Utils;
import com.bstek.urule.console.EnvironmentUtils;
import com.bstek.urule.console.Principal;
import com.bstek.urule.console.repository.ProjectVariable;
import com.bstek.urule.console.repository.RepositoryService;
import com.bstek.urule.console.repository.model.FileType;
import com.bstek.urule.console.servlet.DesignerConfigure;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.console.servlet.RequestContext;
import com.bstek.urule.console.servlet.SessionStore;
import com.bstek.urule.console.servlet.common.CommonServletHandler;
import com.bstek.urule.console.servlet.scorecard.CellData;
import com.bstek.urule.console.servlet.scorecard.RowData;
import com.bstek.urule.console.servlet.scorecard.ScoreTableBuilder;
import com.bstek.urule.console.servlet.scorecard.ScoreTableData;
import com.bstek.urule.console.servlet.scorecard.TableHeader;
import com.bstek.urule.dsl.DSLRuleSetBuilder;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.library.variable.CategoryType;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.parse.deserializer.ScorecardDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class ScorecardEditorServletHandler
extends RenderPageServletHandler {
    private RepositoryService a;
    private CommonServletHandler b;
    private DSLRuleSetBuilder c;
    private ScorecardDeserializer d;

    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.retriveMethod(httpServletRequest);
        if (string != null) {
            this.invokeMethod(string, httpServletRequest, httpServletResponse);
        } else {
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
            velocityContext.put("version", (Object)Splash.getVersion());
            velocityContext.put("constantLink", (Object)DesignerConfigure.constantLink);
            velocityContext.put("variableLink", (Object)DesignerConfigure.variableLink);
            velocityContext.put("_date_", (Object)_DATE);
            velocityContext.put("_lis_", (Object)Splash.getFetchVersion());
            String string2 = httpServletRequest.getParameter("file");
            String string3 = this.buildProjectNameFromFile(string2);
            if (string3 != null) {
                velocityContext.put("project", (Object)string3);
            }
            velocityContext.put("showFileExtensionName", (Object)PropertyConfigurer.getProperty((String)"urule.show.fileExtensionName"));
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/scorecard-editor.html", "utf-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
            printWriter.close();
        }
    }

    public void importExcel(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            ProjectVariable projectVariable;
            Object object;
            Object object2;
            Object object3;
            String string = httpServletRequest.getParameter("project");
            string = Utils.decodeURL((String)string);
            DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
            ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
            List list = servletFileUpload.parseRequest(httpServletRequest);
            Iterator iterator = list.iterator();
            ScoreTableData scoreTableData = null;
            while (iterator.hasNext()) {
                object3 = (FileItem)iterator.next();
                object2 = object3.getFieldName();
                if (!((String)object2).equals("excel_file")) continue;
                object = object3.getInputStream();
                scoreTableData = this.a((InputStream)object);
                ((InputStream)object).close();
                break;
            }
            if (scoreTableData == null) {
                throw new RuleException("\u8bf7\u4e0a\u4f20\u4e00\u4e2aExcel\u6587\u4ef6\uff01");
            }
            object3 = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
            object2 = this.a.loadProjectLibraries(string, (Principal)object3);
            object = object2.iterator();
            while (object.hasNext()) {
                projectVariable = (ProjectVariable)object.next();
                String string2 = projectVariable.getPath();
                Object object4 = this.b.buildData(string2).get(0);
                if (string2.endsWith(FileType.ParameterLibrary.toString())) {
                    List list2 = (List)object4;
                    ArrayList<VariableCategory> arrayList = new ArrayList<VariableCategory>();
                    VariableCategory variableCategory = new VariableCategory();
                    variableCategory.setClazz(HashMap.class.getName());
                    variableCategory.setName("\u53c2\u6570");
                    variableCategory.setType(CategoryType.Clazz);
                    variableCategory.setVariables(list2);
                    arrayList.add(variableCategory);
                    projectVariable.setVariableCategories(arrayList);
                    continue;
                }
                projectVariable.setVariableCategories((List)object4);
            }
            object = new ScoreTableBuilder(scoreTableData, this.c, (List<ProjectVariable>)object2, this.d);
            projectVariable = ((ScoreTableBuilder)object).buildTable();
            SessionStore.setAttribute("_import_data_", projectVariable);
            hashMap.put("fail", false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = this.buildErrorMsg(exception);
            hashMap.put("fail", true);
            hashMap.put("msg", string);
        }
        this.writeObjectToJson(httpServletResponse, hashMap);
    }

    private ScoreTableData a(InputStream inputStream) throws Exception {
        XSSFWorkbook xSSFWorkbook = new XSSFWorkbook(inputStream);
        if (xSSFWorkbook.getNumberOfSheets() == 0) {
            xSSFWorkbook.close();
            throw new RuleException("\u5bfc\u5165Excel\u4e0d\u5408\u6cd5\uff01");
        }
        ArrayList<RowData> arrayList = new ArrayList<RowData>();
        XSSFSheet xSSFSheet = xSSFWorkbook.getSheetAt(0);
        int n = xSSFSheet.getLastRowNum();
        List<TableHeader> list = this.a(xSSFSheet);
        for (int i = 1; i <= n; ++i) {
            XSSFRow xSSFRow = xSSFSheet.getRow(i);
            RowData rowData = new RowData();
            arrayList.add(rowData);
            ArrayList<CellData> arrayList2 = new ArrayList<CellData>();
            rowData.setCells(arrayList2);
            for (int j = 0; j < list.size(); ++j) {
                int n2;
                XSSFCell xSSFCell = xSSFRow.getCell(j);
                if (xSSFCell == null || (n2 = this.a(i, j, xSSFSheet)) == 0) continue;
                TableHeader tableHeader = list.get(j);
                CellData cellData = new CellData();
                if (n2 > 0) {
                    cellData.setSpan(n2);
                }
                cellData.setHeader(tableHeader);
                CellType cellType = xSSFCell.getCellTypeEnum();
                switch (cellType) {
                    case STRING: {
                        cellData.setContent(xSSFCell.getStringCellValue());
                        break;
                    }
                    case BOOLEAN: {
                        cellData.setContent(String.valueOf(xSSFCell.getBooleanCellValue()));
                        break;
                    }
                    case NUMERIC: {
                        xSSFCell.setCellType(CellType.STRING);
                        cellData.setContent(xSSFCell.getStringCellValue());
                        break;
                    }
                }
                cellData.setRow(i - 1);
                cellData.setCol(j);
                arrayList2.add(cellData);
            }
        }
        xSSFWorkbook.close();
        return new ScoreTableData(list, arrayList);
    }

    private int a(int n, int n2, XSSFSheet xSSFSheet) {
        List list = xSSFSheet.getMergedRegions();
        for (CellRangeAddress cellRangeAddress : list) {
            if (cellRangeAddress.getFirstColumn() == n2 && cellRangeAddress.getFirstRow() == n) {
                int n3 = cellRangeAddress.getLastRow() - cellRangeAddress.getFirstRow();
                return ++n3;
            }
            if (n2 < cellRangeAddress.getFirstColumn() || n2 > cellRangeAddress.getLastColumn() || n < cellRangeAddress.getFirstRow() || n > cellRangeAddress.getLastRow()) continue;
            return 0;
        }
        return -1;
    }

    private List<TableHeader> a(XSSFSheet xSSFSheet) {
        XSSFRow xSSFRow = xSSFSheet.getRow(0);
        ArrayList<TableHeader> arrayList = new ArrayList<TableHeader>();
        int n = xSSFRow.getLastCellNum();
        for (int i = 0; i < n; ++i) {
            XSSFCell xSSFCell = xSSFRow.getCell(i);
            String string = xSSFCell.getStringCellValue();
            if (StringUtils.isBlank((String)string)) continue;
            TableHeader tableHeader = new TableHeader();
            arrayList.add(tableHeader);
            tableHeader.setName(string);
        }
        return arrayList;
    }

    public void setCommonServletHandler(CommonServletHandler commonServletHandler) {
        this.b = commonServletHandler;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.a = repositoryService;
    }

    public void setScorecardDeserializer(ScorecardDeserializer scorecardDeserializer) {
        this.d = scorecardDeserializer;
    }

    public void setDslRuleSetBuilder(DSLRuleSetBuilder dSLRuleSetBuilder) {
        this.c = dSLRuleSetBuilder;
    }

    @Override
    public String url() {
        return "/scorecardeditor";
    }
}

