/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.server;

import com.bstek.urule.Splash;
import com.bstek.urule.console.EnvironmentUtils;
import com.bstek.urule.console.Principal;
import com.bstek.urule.console.repository.cluster.ClusterRepositoryService;
import com.bstek.urule.console.repository.cluster.ServerInfo;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.console.servlet.RequestContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class ServerConfigServletHandler
extends RenderPageServletHandler {
    private ClusterRepositoryService a;

    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.retriveMethod(httpServletRequest);
        if (string != null) {
            this.invokeMethod(string, httpServletRequest, httpServletResponse);
        } else {
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
            velocityContext.put("version", (Object)Splash.getVersion());
            velocityContext.put("_date_", (Object)_DATE);
            velocityContext.put("_lis_", (Object)Splash.getFetchVersion());
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/server-config-editor.html", "utf-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
            printWriter.close();
        }
    }

    public void loadData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        this.writeObjectToJson(httpServletResponse, this.a.loadServers(principal));
    }

    public void save(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        String string = httpServletRequest.getParameter("name");
        String string2 = httpServletRequest.getParameter("url");
        ServerInfo serverInfo = new ServerInfo(string, string2);
        this.a.saveServer(serverInfo, principal);
    }

    public void remove(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        String string = httpServletRequest.getParameter("name");
        String string2 = httpServletRequest.getParameter("url");
        ServerInfo serverInfo = new ServerInfo(string, string2);
        this.a.removeServer(serverInfo, principal);
    }

    public void setClusterRepositoryService(ClusterRepositoryService clusterRepositoryService) {
        this.a = clusterRepositoryService;
    }

    @Override
    public String url() {
        return "/serverconfig";
    }
}

