/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.template;

import com.bstek.urule.Utils;
import com.bstek.urule.console.EnvironmentUtils;
import com.bstek.urule.console.Principal;
import com.bstek.urule.console.exception.NoPermissionException;
import com.bstek.urule.console.repository.TemplateRepositoryService;
import com.bstek.urule.console.repository.model.RepositoryFile;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.console.servlet.RequestContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class TemplateServletHandler
extends RenderPageServletHandler {
    private TemplateRepositoryService a;

    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.retriveMethod(httpServletRequest);
        if (string != null) {
            this.invokeMethod(string, httpServletRequest, httpServletResponse);
        } else {
            Principal principal = EnvironmentUtils.getEnvironmentProvider().getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
            if (!principal.isAdmin()) {
                throw new NoPermissionException();
            }
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
            String string2 = httpServletRequest.getParameter("project");
            string2 = Utils.decodeURL((String)string2);
            velocityContext.put("project", (Object)string2);
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/template-editor.html", "utf-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
            printWriter.close();
        }
    }

    public void removeTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = this.a(httpServletRequest);
        String string2 = httpServletRequest.getParameter("category");
        String string3 = httpServletRequest.getParameter("name");
        String string4 = string + "/" + "__rules_templates__" + "/" + string2 + "/" + string3;
        this.a.removeTemplateFile(string4);
    }

    public void removeCategory(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = this.a(httpServletRequest);
        String string2 = httpServletRequest.getParameter("category");
        this.a.removeTemplateCategory(string, string2);
    }

    public void saveCategory(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = this.a(httpServletRequest);
        String string2 = httpServletRequest.getParameter("categoryName");
        string2 = string2.trim();
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        this.a.createTemplateCategory(principal, string, string2);
    }

    public void saveTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = this.a(httpServletRequest);
        String string2 = httpServletRequest.getParameter("category");
        String string3 = httpServletRequest.getParameter("content");
        string3 = Utils.decodeContent((String)string3);
        String string4 = httpServletRequest.getParameter("name");
        string4 = string4.trim();
        String string5 = httpServletRequest.getParameter("comment");
        String string6 = string + "/" + "__rules_templates__" + "/" + string2 + "/" + string4;
        Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
        this.a.createTemplateFile(principal, string6, string5, string3);
    }

    public void loadTemplates(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("project");
        if (string == null) {
            string = this.a(httpServletRequest);
        }
        List<RepositoryFile> list = this.a.loadTemplates(string);
        this.writeObjectToJson(httpServletResponse, list);
    }

    private String a(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("file");
        if ((string = Utils.decodeURL((String)string)).startsWith("/")) {
            string = string.substring(1, string.length());
        }
        int n = string.indexOf("/");
        String string2 = string.substring(0, n);
        return string2;
    }

    public void setTemplateRepositoryService(TemplateRepositoryService templateRepositoryService) {
        this.a = templateRepositoryService;
    }

    @Override
    public String url() {
        return "/template";
    }
}

