/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.test;

import com.bstek.urule.Utils;
import com.bstek.urule.console.repository.scenario.DataField;
import com.bstek.urule.console.repository.scenario.ScenarioRepositoryService;
import com.bstek.urule.console.repository.scenario.SimulateData;
import com.bstek.urule.console.repository.scenario.TestScenario;
import com.bstek.urule.console.servlet.JsonBuilder;
import com.bstek.urule.console.servlet.test.DataObject;
import com.bstek.urule.console.servlet.test.ObjectField;
import com.bstek.urule.console.servlet.test.ResultWrapper;
import com.bstek.urule.console.servlet.test.ScenarioData;
import com.bstek.urule.console.servlet.test.TestResult;
import com.bstek.urule.console.servlet.test.ValueCompare;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.GeneralEntity;
import com.bstek.urule.model.flow.FlowDefinition;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.variable.Variable;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.KnowledgeSession;
import com.bstek.urule.runtime.KnowledgeSessionFactory;
import com.bstek.urule.runtime.assertor.AssertorEvaluator;
import com.bstek.urule.runtime.log.LogManager;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ScenarioTestExecuting {
    private ScenarioRepositoryService a;
    private AssertorEvaluator b;

    public ScenarioTestExecuting(ScenarioRepositoryService scenarioRepositoryService) {
        this.a = scenarioRepositoryService;
        this.b = (AssertorEvaluator)Utils.getApplicationContext().getBean("urule.assertorEvaluator");
    }

    public ResultWrapper doTest(TestScenario testScenario, KnowledgePackage knowledgePackage, List<VariableCategory> list, String string) throws Exception {
        Long l = System.currentTimeMillis();
        Map<String, ScenarioData> map = this.a(testScenario, string);
        KnowledgeSession knowledgeSession = KnowledgeSessionFactory.newKnowledgeSession((KnowledgePackage)knowledgePackage);
        Long l2 = System.currentTimeMillis();
        ResultWrapper resultWrapper = new ResultWrapper();
        resultWrapper.setPrepareTime(l2 - l);
        ArrayList<TestResult> arrayList = new ArrayList<TestResult>();
        resultWrapper.setResultList(arrayList);
        long l3 = System.currentTimeMillis();
        for (ScenarioData scenarioData : map.values()) {
            List<DataObject> list2 = scenarioData.getInput();
            List<GeneralEntity> list3 = this.a(list2, list);
            HashMap hashMap = new HashMap();
            long l4 = System.currentTimeMillis();
            for (Object object : list3) {
                if (object.getTargetClass().equals("\u53c2\u6570") || object.getTargetClass().equals(HashMap.class.getName())) {
                    hashMap.putAll(object);
                    continue;
                }
                knowledgeSession.insert(object);
            }
            Map map2 = knowledgePackage.getFlowMap();
            if (map2 != null && map2.size() > 0) {
                Object object;
                object = ((FlowDefinition)map2.values().iterator().next()).getId();
                if (hashMap.size() > 0) {
                    knowledgeSession.startProcess((String)object, hashMap);
                } else {
                    knowledgeSession.startProcess((String)object);
                }
            } else if (hashMap.size() > 0) {
                knowledgeSession.fireRules(hashMap);
            } else {
                knowledgeSession.fireRules();
            }
            long l5 = System.currentTimeMillis();
            long l6 = l5 - l4;
            TestResult testResult = new TestResult();
            arrayList.add(testResult);
            testResult.setScenarioId(scenarioData.getScenarioId());
            testResult.setScenarioDesc(scenarioData.getScenarioDesc());
            testResult.setConsumeTime(l6);
            testResult.setInputData(scenarioData.getInput().toString());
            testResult.setOutputData(scenarioData.getOutput() != null ? scenarioData.getOutput().toString() : null);
            LogManager logManager = knowledgeSession.getLogManager();
            if (testScenario.isShowLog()) {
                testResult.addLogs(logManager.getLogger().getLogs());
            }
            if (testScenario.isShowFiredFlowNodeList()) {
                testResult.addFlowNodeList(logManager.buildFlowNodeData());
            }
            if (testScenario.isShowNotMatchRuleList()) {
                testResult.addNotMatchedRuleList(logManager.buildNotMatchRuleData());
            }
            if (testScenario.isShowMatchedRuleList()) {
                testResult.addMatchedRuleList(logManager.buildMatchedRuleLog());
            }
            List<ValueCompare> list4 = this.a(scenarioData.getOutput(), list3, list, knowledgeSession.getParameters());
            testResult.setValueCompares(list4);
        }
        long l7 = System.currentTimeMillis();
        resultWrapper.setTotalTime(l7 - l3);
        resultWrapper.setProject(string);
        return resultWrapper;
    }

    private List<ValueCompare> a(List<DataObject> list, List<GeneralEntity> list2, List<VariableCategory> list3, Map<String, Object> generalEntity) {
        ArrayList<ValueCompare> arrayList = new ArrayList<ValueCompare>();
        if (list == null) {
            return arrayList;
        }
        for (DataObject dataObject : list) {
            String string = dataObject.getName();
            GeneralEntity generalEntity2 = null;
            if (string.equals("\u53c2\u6570")) {
                generalEntity2 = generalEntity;
            } else {
                VariableCategory variableCategory = JsonBuilder.getInstance().findVariableCategory(list3, string);
                String string2 = variableCategory.getClazz();
                generalEntity2 = this.a(list2, string2);
            }
            for (ObjectField objectField : dataObject.getFields()) {
                String string3 = objectField.getName();
                Object object = Utils.getObjectProperty((Object)generalEntity2, (String)string3);
                String string4 = objectField.getValue();
                boolean bl = this.b.evaluate(object, (Object)string4, objectField.getDatatype(), objectField.getOp());
                ValueCompare valueCompare = new ValueCompare();
                valueCompare.setMatched(bl);
                valueCompare.setCategory(string);
                valueCompare.setFieldName(objectField.getLabel());
                valueCompare.setData(object);
                valueCompare.setExpectedData(string4);
                valueCompare.setOp(objectField.getOp());
                arrayList.add(valueCompare);
            }
        }
        return arrayList;
    }

    private GeneralEntity a(List<GeneralEntity> list, String string) {
        for (GeneralEntity generalEntity : list) {
            if (!generalEntity.getTargetClass().equals(string)) continue;
            return generalEntity;
        }
        throw new RuleException("\u5bf9\u8c61\u7c7b\u3010" + string + "\u3011\u4e0d\u5b58\u5728");
    }

    private List<GeneralEntity> a(List<DataObject> list, List<VariableCategory> list2) throws Exception {
        Object object;
        ArrayList<GeneralEntity> arrayList = new ArrayList<GeneralEntity>();
        for (DataObject dataObject : list) {
            VariableCategory variableCategory = JsonBuilder.getInstance().findVariableCategory(list2, dataObject.getName());
            object = new GeneralEntity(variableCategory.getClazz());
            arrayList.add((GeneralEntity)object);
            block1: for (ObjectField objectField : dataObject.getFields()) {
                String string = objectField.getValue();
                if (string == null) continue;
                Variable variable = JsonBuilder.getInstance().findVariable(variableCategory, objectField.getLabel());
                Datatype datatype = variable.getType();
                Object object2 = null;
                object2 = datatype.equals((Object)Datatype.Object) || datatype.equals((Object)Datatype.List) || datatype.equals((Object)Datatype.Set) ? JsonBuilder.getInstance().buildComplexObject(string, list2) : datatype.convert((Object)string);
                Object object3 = object;
                String[] stringArray = variable.getName().split("\\.");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (i == stringArray.length - 1) {
                        Utils.setObjectProperty((Object)object3, (String)string2, (Object)object2);
                        continue block1;
                    }
                    HashMap hashMap = Utils.getObjectProperty((Object)object3, (String)string2);
                    if (hashMap == null) {
                        hashMap = new HashMap();
                        Utils.setObjectProperty((Object)object3, (String)string2, hashMap);
                    }
                    object3 = hashMap;
                }
            }
        }
        for (VariableCategory variableCategory : list2) {
            if (variableCategory.getName().equals("\u53c2\u6570")) continue;
            boolean bl = false;
            for (GeneralEntity generalEntity : arrayList) {
                if (!generalEntity.getTargetClass().equals(variableCategory.getClazz())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            object = new GeneralEntity(variableCategory.getClazz());
            arrayList.add((GeneralEntity)object);
        }
        return arrayList;
    }

    private Map<String, ScenarioData> a(TestScenario testScenario, String string) throws Exception {
        InputStream inputStream = this.a.loadTestScenarioExcel(testScenario.getExcelId(), string);
        XSSFWorkbook xSSFWorkbook = new XSSFWorkbook(inputStream);
        Map<String, ScenarioData> map = this.a(testScenario, xSSFWorkbook.getSheetAt(0));
        this.a(testScenario, map, xSSFWorkbook.getSheetAt(1));
        xSSFWorkbook.close();
        inputStream.close();
        return map;
    }

    private Map<String, ScenarioData> a(TestScenario testScenario, XSSFSheet xSSFSheet) {
        Object object;
        String string;
        Object object2;
        XSSFRow xSSFRow;
        Object object3;
        String string2;
        List<SimulateData> list = testScenario.getInputData();
        XSSFRow xSSFRow2 = xSSFSheet.getRow(0);
        List list2 = xSSFSheet.getMergedRegions();
        int n = 2;
        ArrayList<SimulateData> arrayList = new ArrayList<SimulateData>();
        Cell cell = xSSFRow2.getCell(n);
        while (cell != null) {
            string2 = this.a(cell);
            if (string2 == null) {
                throw new RuleException("1\u884c" + (n + 1) + "\u5217\u5355\u5143\u683c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
            object3 = this.b(list, string2);
            if (object3 == null) {
                throw new RuleException("\u8f93\u5165\u6570\u636e\u5bf9\u8c61\u7b2c1\u884c\u7b2c" + (n + 1) + "\u5217\u503c\u4e3a\"" + string2 + "\"\u5728\u914d\u7f6e\u4e2d\u672a\u5b9a\u4e49!");
            }
            SimulateData simulateData = new SimulateData();
            simulateData.setName(string2);
            simulateData.setFields(((SimulateData)object3).getFields());
            arrayList.add(simulateData);
            n += this.a(list2, 0, n);
            cell = xSSFRow2.getCell(n);
        }
        n = 2;
        string2 = xSSFSheet.getRow(1);
        for (SimulateData simulateData : arrayList) {
            List<DataField> list3 = simulateData.getFields();
            xSSFRow = new ArrayList();
            for (int i = 0; i < list3.size(); ++i) {
                object2 = string2.getCell(n);
                string = this.a((Cell)object2);
                object = this.a(list3, string, false);
                if (object == null) {
                    throw new RuleException("\u8f93\u5165\u6570\u636e\u5bf9\u8c61\u7b2c2\u884c\u7b2c" + (n + 1) + "\u5217\u503c\u4e3a\"" + string + "\"\u5728\u914d\u7f6e\u5bf9\u8c61\"" + simulateData.getName() + "\"\u4e2d\u4e0d\u5b58\u5728!");
                }
                xSSFRow.add(object);
                ++n;
            }
            simulateData.setFields((List<DataField>)xSSFRow);
        }
        object3 = new LinkedHashMap<String, ScenarioData>();
        int n2 = xSSFSheet.getLastRowNum();
        for (int i = 2; i <= n2; ++i) {
            Cell cell2;
            xSSFRow = xSSFSheet.getRow(i);
            if (xSSFRow == null || StringUtils.isBlank((String)(object2 = this.a(cell2 = xSSFRow.getCell(0))))) continue;
            string = xSSFRow.getCell(1);
            object = this.a((Cell)string);
            if (object3.containsKey(object2)) {
                throw new RuleException("\u573a\u666f\u6570\u636e\u5b9a\u4e49\u4e2d\u573a\u666fID\u3010" + (String)object2 + "\u3011\u5b58\u5728\u91cd\u590d\u503c");
            }
            ScenarioData scenarioData = new ScenarioData();
            object3.put((String)object2, (ScenarioData)scenarioData);
            scenarioData.setScenarioId((String)object2);
            scenarioData.setScenarioDesc((String)object);
            ArrayList<DataObject> arrayList2 = new ArrayList<DataObject>();
            scenarioData.setInput(arrayList2);
            n = 2;
            for (SimulateData simulateData : arrayList) {
                DataObject dataObject = new DataObject();
                dataObject.setName(simulateData.getName());
                arrayList2.add(dataObject);
                ArrayList<ObjectField> arrayList3 = new ArrayList<ObjectField>();
                dataObject.setFields(arrayList3);
                List<DataField> list4 = simulateData.getFields();
                for (DataField dataField : list4) {
                    ObjectField objectField = new ObjectField();
                    arrayList3.add(objectField);
                    objectField.setLabel(dataField.getLabel());
                    objectField.setName(dataField.getName());
                    objectField.setOp(dataField.getOp());
                    objectField.setDatatype(dataField.getDatatype());
                    Cell cell3 = xSSFRow.getCell(n);
                    String string3 = this.a(cell3);
                    objectField.setValue(string3);
                    ++n;
                }
            }
        }
        return object3;
    }

    private DataField a(List<DataField> list, String string, boolean bl) {
        for (DataField dataField : list) {
            String string2;
            if (!(bl ? (string2 = "\"" + dataField.getLabel() + "\"" + dataField.getOp()).equals(string) : dataField.getLabel().equals(string))) continue;
            return dataField;
        }
        return null;
    }

    private SimulateData b(List<SimulateData> list, String string) {
        for (SimulateData simulateData : list) {
            if (!string.equals(simulateData.getName())) continue;
            return simulateData;
        }
        return null;
    }

    private String a(Cell cell) {
        CellType cellType = cell.getCellTypeEnum();
        switch (cellType) {
            case _NONE: {
                return null;
            }
            case BLANK: {
                return null;
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case ERROR: {
                return null;
            }
            case FORMULA: {
                return String.valueOf(cell.getCellFormula());
            }
            case NUMERIC: {
                return this.b(cell);
            }
            case STRING: {
                return cell.getStringCellValue();
            }
        }
        return null;
    }

    private String b(Cell cell) {
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            Date date = cell.getDateCellValue();
            if (date != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return simpleDateFormat.format(date);
            }
            return null;
        }
        cell.setCellType(CellType.STRING);
        return cell.getStringCellValue();
    }

    private void a(TestScenario testScenario, Map<String, ScenarioData> map, XSSFSheet xSSFSheet) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        List<SimulateData> list = testScenario.getOutputData();
        XSSFRow xSSFRow = xSSFSheet.getRow(0);
        List list2 = xSSFSheet.getMergedRegions();
        int n = 1;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            Cell cell = xSSFRow.getCell(n);
            if (cell == null) {
                throw new RuleException("[\u9884\u671f\u7ed3\u679c]\u4e2d\u7b2c2\u884c" + (n + 1) + "\u5217\u5355\u5143\u683c\u4e0d\u5b58\u5728!");
            }
            Object object5 = this.a(cell);
            if (object5 == null) {
                throw new RuleException("1\u884c" + (n + 1) + "\u5217\u5355\u5143\u683c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
            object4 = this.b(list, (String)object5);
            if (object4 == null) {
                throw new RuleException("[\u9884\u671f\u7ed3\u679c]\u4e2d\u7b2c1\u884c" + (n + 1) + "\u5217\u503c\u4e3a\"" + (String)object5 + "\"\u4e0e\u914d\u7f6e\u4e2d\u672a\u5b9a\u4e49!");
            }
            object3 = new SimulateData();
            ((SimulateData)object3).setName((String)object5);
            ((SimulateData)object3).setFields(((SimulateData)object4).getFields());
            arrayList.add(object3);
            n += this.a(list2, 0, n);
        }
        n = 1;
        XSSFRow xSSFRow2 = xSSFSheet.getRow(1);
        for (Object object5 : arrayList) {
            object4 = ((SimulateData)object5).getFields();
            object3 = new ArrayList();
            for (int i = 0; i < object4.size(); ++i) {
                object2 = xSSFRow2.getCell(n);
                if (object2 == null) {
                    throw new RuleException("[\u9884\u671f\u7ed3\u679c]\u4e2d\u7b2c2\u884c" + (n + 1) + "\u5217\u5355\u5143\u683c\u4e0d\u5b58\u5728!");
                }
                object = this.a((Cell)object2);
                DataField dataField = this.a((List<DataField>)object4, (String)object, true);
                if (dataField == null) {
                    throw new RuleException("[\u9884\u671f\u7ed3\u679c]\u4e2d\u7b2c2\u884c" + (n + 1) + "\u5217\u503c\u4e3a\"" + (String)object + "\"\u5728\u914d\u7f6e\u5bf9\u8c61\"" + ((SimulateData)object5).getName() + "\"\u4e2d\u4e0d\u5b58\u5728!");
                }
                object3.add(dataField);
                ++n;
            }
            ((SimulateData)object5).setFields((List<DataField>)object3);
        }
        int n2 = xSSFSheet.getLastRowNum();
        for (int i = 2; i <= n2; ++i) {
            object4 = xSSFSheet.getRow(i);
            object3 = object4.getCell(0);
            if (object3 == null) {
                throw new RuleException("[\u9884\u671f\u7ed3\u679c]\u4e2d\u7b2c" + (i + 1) + "\u884c1\u5217\u5355\u5143\u683c\u4e0d\u5b58\u5728\uff0c\u6b64\u5355\u5143\u683c\u5e94\u8be5\u5b9a\u4e49\u5bf9\u5e94\u7684\u573a\u666fID\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684Excel.");
            }
            String string = this.a((Cell)object3);
            if (StringUtils.isBlank((String)string)) continue;
            if (!map.containsKey(string)) {
                throw new RuleException("[\u9884\u671f\u7ed3\u679c]\u4e2d\u4f7f\u7528\u7684\u573a\u666fID\u3010" + string + "\u3011\u5728\u573a\u666f\u6570\u636e\u4e2d\u672a\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684Excel.");
            }
            object2 = map.get(string);
            object = new ArrayList();
            ((ScenarioData)object2).setOutput((List<DataObject>)object);
            n = 1;
            for (SimulateData simulateData : arrayList) {
                DataObject dataObject = new DataObject();
                object.add(dataObject);
                dataObject.setName(simulateData.getName());
                ArrayList<ObjectField> arrayList2 = new ArrayList<ObjectField>();
                dataObject.setFields(arrayList2);
                for (DataField dataField : simulateData.getFields()) {
                    ObjectField objectField = new ObjectField();
                    arrayList2.add(objectField);
                    objectField.setLabel(dataField.getLabel());
                    objectField.setName(dataField.getName());
                    objectField.setOp(dataField.getOp());
                    objectField.setDatatype(dataField.getDatatype());
                    Cell cell = object4.getCell(n);
                    if (cell == null) {
                        throw new RuleException("[\u9884\u671f\u7ed3\u679c]\u4e2d\u7b2c" + (i + 1) + "\u884c" + (n + 1) + "\u5217\u5355\u5143\u683c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684Excel.");
                    }
                    String string2 = this.a(cell);
                    objectField.setValue(string2);
                    ++n;
                }
            }
        }
    }

    private int a(List<CellRangeAddress> list, int n, int n2) {
        for (CellRangeAddress cellRangeAddress : list) {
            if (cellRangeAddress.getFirstRow() != n || cellRangeAddress.getFirstColumn() != n2) continue;
            return cellRangeAddress.getLastColumn() - cellRangeAddress.getFirstColumn() + 1;
        }
        return 1;
    }
}

