/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.ul;

import com.bstek.urule.PropertyConfigurer;
import com.bstek.urule.Splash;
import com.bstek.urule.Utils;
import com.bstek.urule.builder.ResourceLibraryBuilder;
import com.bstek.urule.console.repository.RepositoryService;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.dsl.DSLRuleSetBuilder;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.rule.RuleSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class ULEditorServletHandler
extends RenderPageServletHandler {
    private DSLRuleSetBuilder a;
    private ResourceLibraryBuilder b;
    private RepositoryService c;

    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.retriveMethod(httpServletRequest);
        if (string != null) {
            this.invokeMethod(string, httpServletRequest, httpServletResponse);
        } else {
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
            velocityContext.put("version", (Object)Splash.getVersion());
            velocityContext.put("_lis_", (Object)Splash.getFetchVersion());
            String string2 = httpServletRequest.getParameter("file");
            String string3 = this.buildProjectNameFromFile(string2);
            if (string3 != null) {
                velocityContext.put("project", (Object)string3);
            }
            velocityContext.put("showFileExtensionName", (Object)PropertyConfigurer.getProperty((String)"urule.show.fileExtensionName"));
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/ul-editor.html", "utf-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
            printWriter.close();
        }
    }

    public void loadUL(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("file");
        string = Utils.decodeURL((String)string);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        String string2 = httpServletRequest.getParameter("version");
        InputStream inputStream = null;
        try {
            inputStream = StringUtils.isEmpty((String)string2) ? this.c.readFile(string, null) : this.c.readFile(string, string2);
            IOUtils.copy((InputStream)inputStream, (OutputStream)servletOutputStream);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            servletOutputStream.close();
            inputStream.close();
        }
    }

    public void loadULLibs(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("content");
        RuleSet ruleSet = this.a.build(string, null);
        ResourceLibrary resourceLibrary = this.b.buildResourceLibrary((Collection)ruleSet.getLibraries());
        this.writeObjectToJson(httpServletResponse, resourceLibrary);
    }

    public void setDslRuleSetBuilder(DSLRuleSetBuilder dSLRuleSetBuilder) {
        this.a = dSLRuleSetBuilder;
    }

    public void setResourceLibraryBuilder(ResourceLibraryBuilder resourceLibraryBuilder) {
        this.b = resourceLibraryBuilder;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.c = repositoryService;
    }

    @Override
    public String url() {
        return "/uleditor";
    }
}

