/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.user;

import com.bstek.urule.PropertyConfigurer;
import com.bstek.urule.Splash;
import com.bstek.urule.console.DefaultPrincipal;
import com.bstek.urule.console.EnvironmentUtils;
import com.bstek.urule.console.Principal;
import com.bstek.urule.console.exception.NoPermissionException;
import com.bstek.urule.console.repository.SecurityRepositoryService;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.console.servlet.RequestContext;
import com.bstek.urule.exception.RuleException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class UserServletHandler
extends RenderPageServletHandler {
    private SecurityRepositoryService a;

    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.retriveMethod(httpServletRequest);
        if (string != null) {
            this.invokeMethod(string, httpServletRequest, httpServletResponse);
        } else {
            Principal principal = EnvironmentUtils.getLoginPrincipal(new RequestContext(httpServletRequest, httpServletResponse));
            if (!principal.isAdmin()) {
                throw new NoPermissionException();
            }
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
            velocityContext.put("version", (Object)Splash.getVersion());
            velocityContext.put("userComment", (Object)PropertyConfigurer.getProperty((String)"urule.security.userCommment"));
            velocityContext.put("_lis_", (Object)Splash.getFetchVersion());
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/user.html", "utf-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
            printWriter.close();
        }
    }

    public void resetPassword(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("username");
        String string2 = httpServletRequest.getParameter("newPassword");
        this.a.resetPassword(string, string2);
    }

    public void changePassword(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        DefaultPrincipal defaultPrincipal = (DefaultPrincipal)httpServletRequest.getSession().getAttribute("default_urule_security_login_user");
        if (defaultPrincipal == null) {
            throw new RuleException("\u8bf7\u5148\u767b\u5f55\uff01");
        }
        String string = defaultPrincipal.getName();
        String string2 = httpServletRequest.getParameter("password");
        String string3 = httpServletRequest.getParameter("newPassword");
        String string4 = null;
        string4 = string.equals("admin") ? this.a.changeAdminPassword(string2, string3) : this.a.changePassword(string, string2, string3);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("error", string4);
        this.writeObjectToJson(httpServletResponse, hashMap);
    }

    public void deleteUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("username");
        String string2 = this.a.deleteUser(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("error", string2);
        this.writeObjectToJson(httpServletResponse, hashMap);
    }

    public void addUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("username");
        String string2 = httpServletRequest.getParameter("password");
        String string3 = httpServletRequest.getParameter("comment");
        String string4 = this.a.addUser(string, string3, string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("error", string4);
        this.writeObjectToJson(httpServletResponse, hashMap);
    }

    public void loadUsers(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        List<Principal> list = this.a.loadUsers();
        this.writeObjectToJson(httpServletResponse, list);
    }

    public void setSecurityRepositoryService(SecurityRepositoryService securityRepositoryService) {
        this.a = securityRepositoryService;
    }

    @Override
    public String url() {
        return "/user";
    }
}

