/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.variable;

import com.bstek.urule.ClassUtils;
import com.bstek.urule.Splash;
import com.bstek.urule.Utils;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.variable.Act;
import com.bstek.urule.model.library.variable.Variable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class VariableEditorServletHandler
extends RenderPageServletHandler {
    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.retriveMethod(httpServletRequest);
        if (string != null) {
            this.invokeMethod(string, httpServletRequest, httpServletResponse);
        } else {
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
            velocityContext.put("version", (Object)Splash.getVersion());
            velocityContext.put("_date_", (Object)_DATE);
            velocityContext.put("_lis_", (Object)Splash.getFetchVersion());
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/variable-editor.html", "utf-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
            printWriter.close();
        }
    }

    public void importXml(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
        ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
        InputStream inputStream = null;
        try {
            List list = servletFileUpload.parseRequest(httpServletRequest);
            if (list.size() != 1) {
                throw new ServletException("Upload xml file is invalid.");
            }
            FileItem fileItem = (FileItem)list.get(0);
            inputStream = fileItem.getInputStream();
            String string = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
            ArrayList<Variable> arrayList = new ArrayList<Variable>();
            Document document = DocumentHelper.parseText((String)string);
            Element element = document.getRootElement();
            String string2 = element.attributeValue("clazz");
            for (Object e : element.elements()) {
                if (e == null || !(e instanceof Element)) continue;
                Element element2 = (Element)e;
                Variable variable = new Variable();
                variable.setAct(Act.InOut);
                variable.setDefaultValue(element2.attributeValue("defaultValue"));
                variable.setLabel(element2.attributeValue("label"));
                variable.setName(element2.attributeValue("name"));
                variable.setType(Datatype.valueOf((String)element2.attributeValue("type")));
                arrayList.add(variable);
            }
            HashMap hashMap = new HashMap();
            hashMap.put("clazz", string2);
            hashMap.put("variables", arrayList);
            this.writeObjectToJson(httpServletResponse, hashMap);
        }
        catch (Exception exception) {
            try {
                throw new ServletException((Throwable)exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public void generateFields(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("clazz");
        Class<?> clazz = this.a(string);
        List list = ClassUtils.classToVariables(clazz);
        this.writeObjectToJson(httpServletResponse, list);
    }

    private Class<?> a(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)Utils.getApplicationContext().getAutowireCapableBeanFactory();
            try {
                clazz = defaultListableBeanFactory.getBeanClassLoader().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new RuleException((Exception)classNotFoundException2);
            }
        }
        return clazz;
    }

    @Override
    public String url() {
        return "/variableeditor";
    }
}

