import java.awt.Color; 
import java.awt.Font; 
import java.awt.Graphics2D; 
import java.awt.font.FontRenderContext; 
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage; 
import java.io.BufferedInputStream; 
import java.io.File; 
import java.io.FileInputStream; 
import java.io.FileNotFoundException; 
import java.io.FileOutputStream; 
import java.io.IOException; 
import java.io.InputStream; 
import java.math.BigDecimal; 
import java.sql.CallableStatement; 
import java.sql.Connection; 
import java.sql.Date; 
import java.sql.DriverManager; 
import java.sql.PreparedStatement; 
import java.sql.ResultSet; 
import java.sql.ResultSetMetaData; 
import java.sql.SQLException; 
import java.sql.Statement; 
import javax.imageio.ImageIO; 
public class BasicApp { 
  //   DM JDBC  
  String jdbcString = "dm.jdbc.driver.DmDriver"; 
  //   DM URLӴ 
  String urlString = "jdbc:dm://localhost:5236"; 
  //  û 
  String userName = "SYSDBA"; 
  //  û 
  String password = "SYSDBA"; 
  //  Ӷ 
  Connection conn = null; 
  /*   JDBC  
    * @throws SQLException  쳣  */ 
  public void loadJdbcDriver() throws SQLException { 
    try { 
      System.out.println("Loading JDBC Driver..."); 
      //   JDBC  
      Class.forName(jdbcString); 
    } catch (ClassNotFoundException e) { 
      throw new SQLException("Load JDBC Driver Error : " + e.getMessage()); 
    } catch (Exception ex) { 
      throw new SQLException("Load JDBC Driver Error : " 
          + ex.getMessage()); 
    } 
  }
  /*   DM ݿ 
    * @throws SQLException  쳣  */ 
  public void connect() throws SQLException { 
    try { 
      System.out.println("Connecting to DM Server..."); 
      //   DM ݿ 
      conn = DriverManager.getConnection(urlString, userName, password); 
    } catch (SQLException e) { 
      throw new SQLException("Connect to DM Server Error : " 
          + e.getMessage()); 
    } 
  } 
  /*  ر   
    * @throws SQLException  쳣  */ 
  public void disConnect() throws SQLException { 
    try { 
      //  ر 
      conn.close(); 
    } catch (SQLException e) { 
      throw new SQLException("close connection error : " + e.getMessage()); 
    } 
  } 
  /*  ƷϢ 
    * @throws SQLException  쳣  */ 
  public void insertTable() throws SQLException { 
    //   
    String sql = "INSERT INTO production.product(name,author,publisher,publishtime," 
        + "product_subcategoryid,productno,satetystocklevel,originalprice,nowprice,discount," 
        + "description,photo,type,papertotal,wordtotal,sellstarttime,sellendtime) " 
        + "VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);"; 
    //   
    PreparedStatement pstmt = conn.prepareStatement(sql); 
    //  Ϊֵ 
    pstmt.setString(1, ""); 
    pstmt.setString(2, "޹"); 
    pstmt.setString(3, "л"); 
    pstmt.setDate(4, Date.valueOf("2005-04-01")); 
    pstmt.setInt(5, 4); 
    pstmt.setString(6, "9787101046121"); 
    pstmt.setInt(7, 10); 
    pstmt.setBigDecimal(8, new BigDecimal(19.0000)); 
    pstmt.setBigDecimal(9, new BigDecimal(15.2000)); 
    pstmt.setBigDecimal(10, new BigDecimal(8.0)); 
    pstmt.setString(11, "塷йһƪ»С˵йС˵ɶƪչƪԭ˵йء"); 
    //  ôֶβ   
    try { 
      //  һͼƬڲֶ 
      String filePath = "c:\\.jpg"; 
      CreateImage(filePath); 
      File file = new File(filePath);   
      InputStream in = new BufferedInputStream(new FileInputStream(file));   
      pstmt.setBinaryStream(12, in, (int) file.length()); 
    } catch (FileNotFoundException e) { 
      System.out.println(e.getMessage()); 
      //  ûͼƬΪ NULL 
      pstmt.setNull(12, java.sql.Types.BINARY); 
    } catch (IOException e) { 
    System.out.println(e.getMessage()); 
    }   
    pstmt.setString(13, "25"); 
    pstmt.setInt(14, 943); 
    pstmt.setInt(15, 93000); 
    pstmt.setDate(16, Date.valueOf("2006-03-20")); 
    pstmt.setDate(17, Date.valueOf("1900-01-01")); 
    //  ִ 
    pstmt.executeUpdate(); 
    //  ر 
    pstmt.close(); 
  } 
  /*  ѯƷϢ 
    * @throws SQLException  쳣  */ 
  public void queryProduct() throws SQLException { 
    //  ѯ 
    String sql = "SELECT productid,name,author,description,photo FROM  production.product WHERE 
productid=11"; 
    //   
    Statement stmt = conn.createStatement(); 
    //  ִвѯ 
    ResultSet rs = stmt.executeQuery(sql); 
    //  ʾ 
    displayResultSet(rs); 
    //  رս 
    rs.close(); 
    //  ر 
    stmt.close(); 
  }   
  /*  ޸ĲƷϢ     * @throws SQLException  쳣  */ 
  public void updateTable() throws SQLException { 
    //   
    String sql = "UPDATE production.product SET name = ?" 
        + "WHERE productid = 11;"; 
    //   
    PreparedStatement pstmt = conn.prepareStatement(sql); 
    //  Ϊֵ 
    pstmt.setString(1, "壨ϣ"); 
    //  ִ 
    pstmt.executeUpdate(); 
    //  ر 
    pstmt.close(); 
  } 
  /*  ɾƷϢ 
    * @throws SQLException  쳣  */ 
  public void deleteTable() throws SQLException { 
    //  ɾ 
    String sql = "DELETE FROM production.product WHERE productid = 11;"; 
    //   
    Statement stmt = conn.createStatement(); 
    //  ִ 
    stmt.executeUpdate(sql); 
    //  ر 
    stmt.close(); 
  } 
  /*  ѯƷϢ 
    * @throws SQLException  쳣  */ 
  public void queryTable() throws SQLException { 
    //  ѯ 
    String sql = "SELECT productid,name,author,publisher FROM production.product"; 
    //   
    Statement stmt = conn.createStatement(); 
    //  ִвѯ 
    ResultSet rs = stmt.executeQuery(sql); 
    //  ʾ 
    displayResultSet(rs); 
    //  رս 
    rs.close(); 
    //  ر 
    stmt.close(); 
  } 
  /*  ô洢޸ĲƷϢ 
    * @throws SQLException  쳣  */
  public void updateProduct() throws SQLException { 
    //   
    String sql = "{ CALL production.updateProduct(?,?) }"; 
    //   
    CallableStatement cstmt = conn.prepareCall(sql); 
    //  Ϊֵ 
    cstmt.setInt(1, 1); 
    cstmt.setString(2, "¥Σϣ"); 
    //  ִ 
    cstmt.execute(); 
    //  ر 
    cstmt.close(); 
  } 
  /*  ʾ 
    * @param rs   
    * @throws SQLException  쳣  */ 
  private void displayResultSet(ResultSet rs) throws SQLException { 
    //  ȡýԪ 
    ResultSetMetaData rsmd = rs.getMetaData(); 
    //  ȡý 
    int numCols = rsmd.getColumnCount(); 
    //  ʾбͷ 
    for (int i = 1; i <= numCols; i++) { 
      if (i > 1) { 
        System.out.print(","); 
      } 
      System.out.print(rsmd.getColumnLabel(i)); 
    } 
    System.out.println(""); 
    //  ʾ 
    while (rs.next()) { 
      for (int i = 1; i <= numCols; i++) { 
        if (i > 1) { 
          System.out.print(","); 
        } 
        //  ֶ 
        if ("IMAGE".equals(rsmd.getColumnTypeName(i))) { 
          byte[] data = rs.getBytes(i); 
          if (data != null && data.length > 0) { 
            FileOutputStream fos; 
            try { 
              fos = new FileOutputStream("c:\\ 1.jpg"); 
              fos.write(data); 
              fos.close(); 
            } catch (FileNotFoundException e) { 
              System.out.println(e.getMessage()); 
            } catch (IOException e) { 
              System.out.println(e.getMessage()); 
            } 
          } 
    System.out.print("ֶдļ c:\\ 1.jpg" + data.length); 
        } else { 
          //  ֶͨ 
          System.out.print(rs.getString(i)); 
        } 
      } 
      System.out.println(""); 
    } 
  } 
    /*  һͼƬڲֶ 
    * @throws IOException  쳣  */ 
  private void CreateImage(String path) throws IOException { 
    int width = 100; 
    int height = 100; 
    String s = ""; 
    File file = new File(path); 
    Font font = new Font("Serif", Font.BOLD, 10); 
    BufferedImage bi = new BufferedImage(width, height, 
        BufferedImage.TYPE_INT_RGB); 
    Graphics2D g2 = (Graphics2D) bi.getGraphics(); 
    g2.setBackground(Color.WHITE); 
    g2.clearRect(0, 0, width, height); 
    g2.setPaint(Color.RED); 
    FontRenderContext context = g2.getFontRenderContext(); 
    Rectangle2D bounds = font.getStringBounds(s, context); 
    double x = (width - bounds.getWidth()) / 2; 
    double y = (height - bounds.getHeight()) / 2; 
    double ascent = -bounds.getY(); 
    double baseY = y + ascent; 
    g2.drawString(s, (int) x, (int) baseY); 
    ImageIO.write(bi, "jpg", file); 
  } 
  /* 
    *    @param args   
    */ 
  public static void main(String args[]) { 
    try { 
      //  		
      BasicApp basicApp = new BasicApp(); 
      //   
      basicApp.loadJdbcDriver(); 
      //   DM ݿ 
      basicApp.connect(); 
      //   
      System.out.println("---  ƷϢ  ---"); 
      basicApp.insertTable(); 
      //  ѯдֶεĲƷϢ 
      System.out.println("---  ʾ  ---"); 
      basicApp.queryProduct(); 
      //  ޸ǰѯƷϢ 
      System.out.println("---  ޸ǰѯƷϢ  ---"); 
      basicApp.queryTable(); 
      //  ޸ĲƷϢ 
      System.out.println("---  ޸ĲƷϢ  ---"); 
      basicApp.updateTable(); 
      //  ޸ĺѯƷϢ 
      System.out.println("---  ޸ĺѯƷϢ  ---"); 
      basicApp.queryTable(); 
      //  ɾƷϢ 
      System.out.println("---  ɾƷϢ  ---"); 
      basicApp.deleteTable(); 
      //  ɾѯƷϢ 
      System.out.println("---  ɾѯƷϢ  ---"); 
      basicApp.queryTable(); 
      //  ô洢޸ĲƷϢ 
      System.out.println("---  ô洢޸ĲƷϢ  ---"); 
      basicApp.updateProduct(); 
      //  ڴ洢̸ºѯƷϢ 
      System.out.println("---  ô洢̺ѯƷϢ  ---"); 
      basicApp.queryTable(); 
      //  ر 
      basicApp.disConnect(); 
    } catch (SQLException e) { 
      System.out.println(e.getMessage()); 
    } 
  } 
 
} 	  