/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.execution;

import com.dangdang.ddframe.job.executor.ShardingContexts;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.lite.internal.execution.ExecutionNode;
import com.dangdang.ddframe.job.lite.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.job.util.config.ShardingItemParameters;
import com.dangdang.ddframe.job.util.env.LocalHostService;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ExecutionContextService {
    private final JobNodeStorage jobNodeStorage;
    private final ConfigurationService configService;
    private final LocalHostService localHostService;

    public ExecutionContextService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.configService = new ConfigurationService(regCenter, jobName);
        this.localHostService = new LocalHostService();
    }

    public ShardingContexts getJobShardingContext(List<Integer> shardingItems) {
        LiteJobConfiguration liteJobConfig = this.configService.load(false);
        this.removeRunningIfMonitorExecution(liteJobConfig.isMonitorExecution(), shardingItems);
        if (shardingItems.isEmpty()) {
            return new ShardingContexts(this.buildTaskId(liteJobConfig, shardingItems), liteJobConfig.getJobName(), liteJobConfig.getTypeConfig().getCoreConfig().getShardingTotalCount(), liteJobConfig.getTypeConfig().getCoreConfig().getJobParameter(), Collections.emptyMap());
        }
        Map shardingItemParameterMap = new ShardingItemParameters(liteJobConfig.getTypeConfig().getCoreConfig().getShardingItemParameters()).getMap();
        return new ShardingContexts(this.buildTaskId(liteJobConfig, shardingItems), liteJobConfig.getJobName(), liteJobConfig.getTypeConfig().getCoreConfig().getShardingTotalCount(), liteJobConfig.getTypeConfig().getCoreConfig().getJobParameter(), this.getAssignedShardingItemParameterMap(shardingItems, shardingItemParameterMap));
    }

    private String buildTaskId(LiteJobConfiguration liteJobConfig, List<Integer> shardingItems) {
        return Joiner.on((String)"@-@").join((Object)liteJobConfig.getJobName(), (Object)Joiner.on((String)",").join(shardingItems), new Object[]{"READY", this.localHostService.getIp(), UUID.randomUUID().toString()});
    }

    private void removeRunningIfMonitorExecution(boolean monitorExecution, List<Integer> shardingItems) {
        if (!monitorExecution) {
            return;
        }
        ArrayList<Integer> runningShardingItems = new ArrayList<Integer>(shardingItems.size());
        for (int each : shardingItems) {
            if (!this.isRunning(each)) continue;
            runningShardingItems.add(each);
        }
        shardingItems.removeAll(runningShardingItems);
    }

    private boolean isRunning(int shardingItem) {
        return this.jobNodeStorage.isJobNodeExisted(ExecutionNode.getRunningNode(shardingItem));
    }

    private Map<Integer, String> getAssignedShardingItemParameterMap(List<Integer> shardingItems, Map<Integer, String> shardingItemParameterMap) {
        HashMap<Integer, String> result = new HashMap<Integer, String>(shardingItemParameterMap.size(), 1.0f);
        for (int each : shardingItems) {
            result.put(each, shardingItemParameterMap.get(each));
        }
        return result;
    }
}

