/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.execution;

import com.dangdang.ddframe.job.lite.internal.config.ConfigurationNode;
import com.dangdang.ddframe.job.lite.internal.config.LiteJobConfigurationGsonFactory;
import com.dangdang.ddframe.job.lite.internal.execution.ExecutionService;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;

public class ExecutionListenerManager
extends AbstractListenerManager {
    private final ExecutionService executionService;
    private final ConfigurationNode configNode;

    public ExecutionListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
        this.configNode = new ConfigurationNode(jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new MonitorExecutionChangedJobListener());
    }

    class MonitorExecutionChangedJobListener
    extends AbstractJobListener {
        MonitorExecutionChangedJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (ExecutionListenerManager.this.configNode.isConfigPath(path) && TreeCacheEvent.Type.NODE_UPDATED == event.getType() && !LiteJobConfigurationGsonFactory.fromJson(new String(event.getData().getData())).isMonitorExecution()) {
                ExecutionListenerManager.this.executionService.removeExecutionInfo();
            }
        }
    }
}

