/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.failover;

import com.dangdang.ddframe.job.lite.internal.config.ConfigurationNode;
import com.dangdang.ddframe.job.lite.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.lite.internal.config.LiteJobConfigurationGsonFactory;
import com.dangdang.ddframe.job.lite.internal.execution.ExecutionNode;
import com.dangdang.ddframe.job.lite.internal.execution.ExecutionService;
import com.dangdang.ddframe.job.lite.internal.failover.FailoverNode;
import com.dangdang.ddframe.job.lite.internal.failover.FailoverService;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.job.lite.internal.sharding.ShardingService;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;

public class FailoverListenerManager
extends AbstractListenerManager {
    private final ConfigurationService configService;
    private final ExecutionService executionService;
    private final ShardingService shardingService;
    private final FailoverService failoverService;
    private final ConfigurationNode configNode;
    private final ExecutionNode executionNode;
    private final FailoverNode failoverNode;

    public FailoverListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.configService = new ConfigurationService(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.failoverService = new FailoverService(regCenter, jobName);
        this.configNode = new ConfigurationNode(jobName);
        this.executionNode = new ExecutionNode(jobName);
        this.failoverNode = new FailoverNode(jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new JobCrashedJobListener());
        this.addDataListener(new FailoverJobCrashedJobListener());
        this.addDataListener(new FailoverSettingsChangedJobListener());
    }

    private void failover(Integer item, TreeCacheEvent event) {
        if (!this.isJobCrashAndNeedFailover(item, event)) {
            return;
        }
        this.failoverService.setCrashedFailoverFlag(item);
        if (!this.executionService.hasRunningItems(this.shardingService.getLocalHostShardingItems())) {
            this.failoverService.failoverIfNecessary();
        }
    }

    private boolean isJobCrashAndNeedFailover(Integer item, TreeCacheEvent event) {
        return null != item && TreeCacheEvent.Type.NODE_REMOVED == event.getType() && !this.executionService.isCompleted(item) && this.configService.load(true).isFailover();
    }

    class FailoverSettingsChangedJobListener
    extends AbstractJobListener {
        FailoverSettingsChangedJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (FailoverListenerManager.this.configNode.isConfigPath(path) && TreeCacheEvent.Type.NODE_UPDATED == event.getType() && !LiteJobConfigurationGsonFactory.fromJson(new String(event.getData().getData())).isFailover()) {
                FailoverListenerManager.this.failoverService.removeFailoverInfo();
            }
        }
    }

    class FailoverJobCrashedJobListener
    extends AbstractJobListener {
        FailoverJobCrashedJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            FailoverListenerManager.this.failover(FailoverListenerManager.this.failoverNode.getItemByExecutionFailoverPath(path), event);
        }
    }

    class JobCrashedJobListener
    extends AbstractJobListener {
        JobCrashedJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            FailoverListenerManager.this.failover(FailoverListenerManager.this.executionNode.getItemByRunningItemPath(path), event);
        }
    }
}

