/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.guarantee;

import com.dangdang.ddframe.job.lite.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.lite.internal.guarantee.GuaranteeNode;
import com.dangdang.ddframe.job.lite.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import java.util.Collection;

public class GuaranteeService {
    private final JobNodeStorage jobNodeStorage;
    private final ConfigurationService configService;

    public GuaranteeService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.configService = new ConfigurationService(regCenter, jobName);
    }

    public void registerStart(Collection<Integer> shardingItems) {
        for (int each : shardingItems) {
            this.jobNodeStorage.createJobNodeIfNeeded(GuaranteeNode.getStartedNode(each));
        }
    }

    public boolean isAllStarted() {
        return this.jobNodeStorage.isJobNodeExisted("guarantee/started") && this.configService.load(false).getTypeConfig().getCoreConfig().getShardingTotalCount() == this.jobNodeStorage.getJobNodeChildrenKeys("guarantee/started").size();
    }

    public void clearAllStartedInfo() {
        this.jobNodeStorage.removeJobNodeIfExisted("guarantee/started");
    }

    public void registerComplete(Collection<Integer> shardingItems) {
        for (int each : shardingItems) {
            this.jobNodeStorage.createJobNodeIfNeeded(GuaranteeNode.getCompletedNode(each));
        }
    }

    public boolean isAllCompleted() {
        return this.jobNodeStorage.isJobNodeExisted("guarantee/completed") && this.configService.load(false).getTypeConfig().getCoreConfig().getShardingTotalCount() <= this.jobNodeStorage.getJobNodeChildrenKeys("guarantee/completed").size();
    }

    public void clearAllCompletedInfo() {
        this.jobNodeStorage.removeJobNodeIfExisted("guarantee/completed");
    }
}

