/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.sharding;

import com.dangdang.ddframe.job.lite.api.strategy.JobShardingStrategy;
import com.dangdang.ddframe.job.lite.api.strategy.JobShardingStrategyFactory;
import com.dangdang.ddframe.job.lite.api.strategy.JobShardingStrategyOption;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.lite.internal.election.LeaderElectionService;
import com.dangdang.ddframe.job.lite.internal.execution.ExecutionService;
import com.dangdang.ddframe.job.lite.internal.server.ServerService;
import com.dangdang.ddframe.job.lite.internal.sharding.ShardingNode;
import com.dangdang.ddframe.job.lite.internal.storage.JobNodePath;
import com.dangdang.ddframe.job.lite.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.job.lite.internal.storage.TransactionExecutionCallback;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.job.util.concurrent.BlockUtils;
import com.dangdang.ddframe.job.util.config.ShardingItems;
import com.dangdang.ddframe.job.util.env.LocalHostService;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.api.transaction.CuratorTransactionFinal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardingService {
    private static final Logger log = LoggerFactory.getLogger(ShardingService.class);
    private final String jobName;
    private final JobNodeStorage jobNodeStorage;
    private final LocalHostService localHostService = new LocalHostService();
    private final LeaderElectionService leaderElectionService;
    private final ConfigurationService configService;
    private final ServerService serverService;
    private final ExecutionService executionService;
    private final JobNodePath jobNodePath;

    public ShardingService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobName = jobName;
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.leaderElectionService = new LeaderElectionService(regCenter, jobName);
        this.configService = new ConfigurationService(regCenter, jobName);
        this.serverService = new ServerService(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
        this.jobNodePath = new JobNodePath(jobName);
    }

    public void setReshardingFlag() {
        this.jobNodeStorage.createJobNodeIfNeeded("leader/sharding/necessary");
    }

    public boolean isNeedSharding() {
        return this.jobNodeStorage.isJobNodeExisted("leader/sharding/necessary");
    }

    public void shardingIfNecessary() {
        List<String> availableShardingServers = this.serverService.getAvailableShardingServers();
        if (availableShardingServers.isEmpty()) {
            this.clearShardingInfo();
            return;
        }
        if (!this.isNeedSharding()) {
            return;
        }
        if (!this.leaderElectionService.isLeader().booleanValue()) {
            this.blockUntilShardingCompleted();
            return;
        }
        LiteJobConfiguration liteJobConfig = this.configService.load(false);
        if (liteJobConfig.isMonitorExecution()) {
            this.waitingOtherJobCompleted();
        }
        log.debug("Job '{}' sharding begin.", (Object)this.jobName);
        this.jobNodeStorage.fillEphemeralJobNode("leader/sharding/processing", "");
        this.clearShardingInfo();
        JobShardingStrategy jobShardingStrategy = JobShardingStrategyFactory.getStrategy(liteJobConfig.getJobShardingStrategyClass());
        JobShardingStrategyOption option = new JobShardingStrategyOption(this.jobName, liteJobConfig.getTypeConfig().getCoreConfig().getShardingTotalCount());
        this.jobNodeStorage.executeInTransaction(new PersistShardingInfoTransactionExecutionCallback(jobShardingStrategy.sharding(availableShardingServers, option)));
        log.debug("Job '{}' sharding complete.", (Object)this.jobName);
    }

    private void blockUntilShardingCompleted() {
        while (!this.leaderElectionService.isLeader().booleanValue() && (this.jobNodeStorage.isJobNodeExisted("leader/sharding/necessary") || this.jobNodeStorage.isJobNodeExisted("leader/sharding/processing"))) {
            log.debug("Job '{}' sleep short time until sharding completed.", (Object)this.jobName);
            BlockUtils.waitingShortTime();
        }
    }

    private void waitingOtherJobCompleted() {
        while (this.executionService.hasRunningItems()) {
            log.debug("Job '{}' sleep short time until other job completed.", (Object)this.jobName);
            BlockUtils.waitingShortTime();
        }
    }

    private void clearShardingInfo() {
        for (String each : this.serverService.getAllServers()) {
            this.jobNodeStorage.removeJobNodeIfExisted(ShardingNode.getShardingNode(each));
        }
    }

    public List<Integer> getLocalHostShardingItems() {
        String ip = this.localHostService.getIp();
        if (!this.jobNodeStorage.isJobNodeExisted(ShardingNode.getShardingNode(ip))) {
            return Collections.emptyList();
        }
        return ShardingItems.toItemList((String)this.jobNodeStorage.getJobNodeDataDirectly(ShardingNode.getShardingNode(ip)));
    }

    class PersistShardingInfoTransactionExecutionCallback
    implements TransactionExecutionCallback {
        private final Map<String, List<Integer>> shardingItems;

        @Override
        public void execute(CuratorTransactionFinal curatorTransactionFinal) throws Exception {
            for (Map.Entry<String, List<Integer>> entry : this.shardingItems.entrySet()) {
                ((CuratorTransactionBridge)curatorTransactionFinal.create().forPath(ShardingService.this.jobNodePath.getFullPath(ShardingNode.getShardingNode(entry.getKey())), ShardingItems.toItemsString(entry.getValue()).getBytes())).and();
            }
            ((CuratorTransactionBridge)curatorTransactionFinal.delete().forPath(ShardingService.this.jobNodePath.getFullPath("leader/sharding/necessary"))).and();
            ((CuratorTransactionBridge)curatorTransactionFinal.delete().forPath(ShardingService.this.jobNodePath.getFullPath("leader/sharding/processing"))).and();
        }

        @ConstructorProperties(value={"shardingItems"})
        public PersistShardingInfoTransactionExecutionCallback(Map<String, List<Integer>> shardingItems) {
            this.shardingItems = shardingItems;
        }
    }
}

